#***********************************************************************************************************************************************
#*  
#*  (C) 2011     Andrzej Bk     Uniwersytet Ekonomiczny we Wrocawiu
#*  
#*  Skrypt do ksiki:
#*  "Analiza danych jakociowych i symbolicznych z wykorzystaniem programu R", C.H. Beck, Warszawa 2011.
#*  
#*  Kod poniszy moe by modyfikowany, kopiowany i rozprowadzany na warunkach licencji GPL 2 (http://gnu.org.pl/text/licencja-gnu.html), 
#*  a w szczeglnoci pod warunkiem umieszczenia w zmodyfikowanym pliku widocznej informacji o dokonanych zmianach, wraz z dat ich dokonania. 
#*  
#***********************************************************************************************************************************************

#MCL (Multinomial Conditional Logit) - wielomianowy warunkowy model logitowy (zmienne objaniajce opisuj profile)
#Estymacja parametrw modelu wyborw dyskretnych na podstawie modelu proporcjonalnego hazardu Coxa 
#Dane: D. Jaskowski [2008]
library(survival)
source("Pclm.r")
source("Prs.r")
dane<-read.csv2("stoki3.csv", header=TRUE)
options(OutDec=",")
print(dane[1:10,])
P<-9                    #liczba profilw
modelph<-coxph(formula=Surv(time,status)~miejscowosc1+miejscowosc2+stok1+baza1+baza2+zaplecze1+zaplecze2+strata(resp),data=dane,method="breslow",model=TRUE)
print(modelph)
#uytecznoci cakowite profilw
M<-model.matrix(modelph)#macierz ukadu czynnikowego ze zmiennymi sztucznymi (zero-jeden)
B<-modelph$coef		#parametry
U<-M[1:P,]%*%B		#uytecznoci cakowite 9 profilw
print("Uytecznoci cakowite profilw")
print(U)
#prawdopodobiestwa wyboru profilw
Pr<-Pclm(B, M[1:P,])	#prawdopodobiestwa wyboru profilw
Ps<-Prs(Pr)			#posortowane prawdopodobiestwa wyboru profilw
colnames(Ps)<-c("Profil","Prawdopodobiestwo wyboru")
print("Prawdopodobiestwa wyboru profilw uporzdkowane malejco")
print(Ps)
sum(Ps[,2])
print("Wykres wanoci poziomw atrybutw")
windows(width=6, height=4, pointsize=7)
nazwy<-c("miejscowosc1","miejscowosc2","stok1","baza1","baza2","zaplecze1","zaplecze2")
barplot(exp(B),ylab="exp(B)",xlab="atrybuty",ylim=c(0,4.0),names.arg=nazwy,las=1)
abline(h=1)