#***********************************************************************************************************************************************
#*  
#*  (C) 2011     Justyna Brzeziska     Uniwersytet Ekonomiczny w Katowicach
#*  
#*  Skrypt do ksiki:
#*  "Analiza danych jakociowych i symbolicznych z wykorzystaniem programu R", C.H. Beck, Warszawa 2011.
#*  
#*  Kod poniszy moe by modyfikowany, kopiowany i rozprowadzany na warunkach licencji GPL 2 (http://gnu.org.pl/text/licencja-gnu.html), 
#*  a w szczeglnoci pod warunkiem umieszczenia w zmodyfikowanym pliku widocznej informacji o dokonanych zmianach, wraz z dat ich dokonania. 
#*  
#***********************************************************************************************************************************************

library(ca)      #zawiera funkcje do analizy korespondencji
library(faraway) #zawiera zbir danych "debt"
library(vcd)     #zawiera funkcje liczce miary wspzalenoci
library(clusterSim) # w nim indeks sylwetkowy do taksonomii
options(OutDec=",")
data(debt)
dane<-debt
dane$incomegp[dane$incomegp=='1']<-'1.najniszy'
dane$incomegp[dane$incomegp=='2']<-'2.niski'
dane$incomegp[dane$incomegp=='3']<-'3.redni'
dane$incomegp[dane$incomegp==4]<-'4.wysoki'
dane$incomegp[dane$incomegp==5]<-'5.najwyszy'
dane$house[dane$house==1]<-'wynajty'
dane$house[dane$house==2]<-'kredyt'
dane$house[dane$house==3]<-'wasny'
wybrane<-which(names(dane)=='incomegp'|names(dane)=='house'|names(dane)=='prodebt')
dane<-dane[!apply(is.na(debt[,wybrane]),1,any),wybrane] #usunicie obserwacji z brakami danych w uwzgldnionych w analizie zmiennych
dane$prodebt<-cut(dane$prodebt,quantile(dane$prodebt, probs = seq(0, 1, 0.2)),labels=FALSE)
names(dane)<-c("dochd.","dom.","skonn.zadu.")
model.mca<-mjca(dane,lambda="adjusted",nd=3)
print(model.mca)
summary(model.mca)
print("Wyodrbnienie wsprzdnych i etykiet punktw z mapy percepcji w celu zrealizowania analizy taksonomicznej - przygotowanie zbioru danych do taksonomii.",quote=FALSE)
dane.do.taksonomii<-as.data.frame(0.001*summary(model.mca)$columns[,c(5,8,11)])
row.names(dane.do.taksonomii)<-c(model.mca$levelnames)
print(dane.do.taksonomii)
macierz.odlegoci<-dist(dane.do.taksonomii,method="euclidean")
model.taks<-hclust(macierz.odlegoci,method="ward")
par(mfrow=c(1,2))
plot(model.taks,labels=row.names(dane.do.taksonomii),main="",sub="",xlab="",ylab="Poziom poczenia klas",cex=0.7,las=1)
trzy.klasy<-c(1,1,2,3,3,3,2,1,2,2,1,3,3) # przynalenos do klas odczytana np. z dendrogramu
cztery.klasy<-c(1,2,3,4,4,4,3,1,3,3,2,4,4) 
piec.klas<-c(1,2,3,4,4,4,5,1,5,3,2,4,4)
silhouette=c()
silhouette[1]=index.S(macierz.odlegoci,trzy.klasy)
silhouette[2]=index.S(macierz.odlegoci,cztery.klasy)
silhouette[3]=index.S(macierz.odlegoci,piec.klas)
print("Wartoci indeksu sylwetkowego dla podziau na trzy, cztery i pi klas (klasyfikacja metod Warda):",quote=FALSE)
print(silhouette)
model.taks<-hclust(macierz.odlegoci,method="complete")
plot(model.taks,labels=row.names(dane.do.taksonomii),main="",sub="",xlab="",ylab="Poziom poczenia klas",cex=0.7,las=1)
trzy.klasy<-c(1,1,2,3,3,3,2,1,2,2,1,3,3) # przynalenos do klas odczytana np. z dendrogramu
cztery.klasy<-c(1,2,3,4,4,4,3,1,3,3,2,4,4) 
piec.klas<-c(1,2,3,4,4,4,3,1,3,5,2,4,4)
silhouette=c()
silhouette[1]=index.S(macierz.odlegoci,trzy.klasy)
silhouette[2]=index.S(macierz.odlegoci,cztery.klasy)
silhouette[3]=index.S(macierz.odlegoci,piec.klas)
print("Wartoci indeksu sylwetkowego dla podziau na trzy, cztery i pi klas (klasyfikacja metod kompletnego poczenia):",quote=FALSE)
print(silhouette)