#***********************************************************************************************************************************************
#*  
#*  (C) 2009     Andrzej Bk     Uniwersytet Ekonomiczny we Wrocawiu
#*  
#*  Przykad do ksiki:
#*  "Statystyczna analiza danych z wykorzystaniem programu R", PWN, Warszawa 2009.
#*  
#*  Kod poniszy moe by modyfikowany, kopiowany i rozprowadzany na warunkach licencji GPL 2 (http://gnu.org.pl/text/licencja-gnu.html), 
#*  a w szczeglnoci pod warunkiem umieszczenia w zmodyfikowanym pliku widocznej informacji o dokonanych zmianach, wraz z dat ich dokonania. 
#*  
#***********************************************************************************************************************************************

source("totalutilities.r")
#kodowanie quasi-eksperymentalne atrybutw
options(contrasts=c("contr.sum","contr.poly"))
options(OutDec=",")
x <- read.csv2("Dane_10_1a.csv", header=TRUE)   #profile
y <- read.csv2("Dane_10_1c.csv", header=TRUE)   #preferencje empiryczne 
m <- length(x)     #liczba atrybutw
n <- nrow(x)       #liczba profilw
S <- nrow(y)/n     #liczba respondentw
xnms <- names(x)   #nazwy zmiennych objaniajcych (atrybuty)
Lj <- vector("numeric", m)   #liczba poziomw j-tego atrybutu
for(j in 1:m) {Lj[j] <- nlevels(factor(x[[xnms[j]]]))}
p <- sum(Lj)-m+1   #liczba poziomw wszystkich atrybutw z wyrazem wolnym (bez poziomw odniesienia), 
                   #liczba zmiennych sztucznych plus wyraz wolny
ynms <- names(y)   #nazwa zmiennej objanianej (preferencje)
xtmp <- paste("factor(x$", xnms, sep="", paste(")"))
xfrm <- paste(xtmp, collapse="+")
Usi <- totalutilities(xfrm, y, x, n, p, S) 
print(round(Usi, 1))