/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.view.set;

import java.util.Arrays;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.GraphVar;
import org.chocosolver.solver.variables.delta.ISetDeltaMonitor;
import org.chocosolver.solver.variables.events.GraphEventType;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.solver.variables.events.SetEventType;
import org.chocosolver.solver.variables.view.delta.SetGraphViewDeltaMonitor;
import org.chocosolver.solver.variables.view.set.SetGraphView;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.procedure.IntProcedure;

public class SetNodeGraphView<E extends GraphVar<?>>
extends SetGraphView<E> {
    public SetNodeGraphView(String name, E graphVar) {
        super(name, graphVar);
    }

    public SetNodeGraphView(E graphVar) {
        this("NODES(" + graphVar.getName() + ")", graphVar);
    }

    @Override
    public ISet getLB() {
        return this.graphVar.getMandatoryNodes();
    }

    @Override
    public ISet getUB() {
        return this.graphVar.getPotentialNodes();
    }

    @Override
    public boolean instantiateTo(int[] value, ICause cause) throws ContradictionException {
        boolean changed = !this.isInstantiated();
        for (int i : value) {
            this.force(i, cause);
        }
        if (this.getLB().size() != value.length) {
            this.contradiction(cause, this.getName() + " cannot be instantiated to " + Arrays.toString(value));
        }
        if (this.getUB().size() != value.length) {
            Object object = this.getUB().iterator();
            while (object.hasNext()) {
                int i = (Integer)object.next();
                if (this.getLB().contains(i)) continue;
                this.remove(i, cause);
            }
        }
        return changed;
    }

    @Override
    protected boolean doRemoveSetElement(int element) throws ContradictionException {
        return this.graphVar.removeNode(element, this);
    }

    @Override
    protected boolean doForceSetElement(int element) throws ContradictionException {
        return this.graphVar.enforceNode(element, this);
    }

    @Override
    public void notify(IEventType event, int variableIdx) throws ContradictionException {
        if (event == GraphEventType.REMOVE_NODE) {
            this.notifyPropagators(SetEventType.REMOVE_FROM_ENVELOPE, this);
        }
        if (event == GraphEventType.ADD_NODE) {
            this.notifyPropagators(SetEventType.ADD_TO_KER, this);
        }
    }

    @Override
    public boolean isInstantiated() {
        return this.getLB().size() == this.getUB().size();
    }

    @Override
    public ISetDeltaMonitor monitorDelta(ICause propagator) {
        return new SetGraphViewDeltaMonitor(this.graphVar.monitorDelta(propagator)){

            @Override
            public void forEach(IntProcedure proc, SetEventType evt) throws ContradictionException {
                if (evt == SetEventType.ADD_TO_KER) {
                    this.deltaMonitor.forEachNode(proc, GraphEventType.ADD_NODE);
                } else if (evt == SetEventType.REMOVE_FROM_ENVELOPE) {
                    this.deltaMonitor.forEachNode(proc, GraphEventType.REMOVE_NODE);
                }
            }
        };
    }
}

