## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## -----------------------------------------------------------------------------
a <- 8
f <- function(x, y) {
  p <- x*y
  u <- runif(1)

  errcond <- p + floor(u * 100) %% 10 + a
  if(errcond %% 4 == 0) stop("condition ", errcond %% 8, call. = FALSE)

  # rlang::dbl
  dbl(p = p, u = u)
}

## -----------------------------------------------------------------------------
outdir <- file.path(tempdir(), "piecemeal_demo")

## -----------------------------------------------------------------------------
sim <- piecemeal::init(outdir) # short for `piecemeal::Piecemeal$new(outdir)`

## -----------------------------------------------------------------------------
sim$reset()

## -----------------------------------------------------------------------------
sim$cluster(2)

## -----------------------------------------------------------------------------
sim$factorial(x = 2^(0:1), y = 3^(0:3))

## -----------------------------------------------------------------------------
sim$nrep(3)

## -----------------------------------------------------------------------------
sim$worker(f)

## -----------------------------------------------------------------------------
sim

## ----eval = FALSE-------------------------------------------------------------
# sim$
#   cluster(2)$
#   factorial(x = 2^(0:1), y = 3^(0:3))$
#   nrep(3)$
#   worker(f)

## -----------------------------------------------------------------------------
head(sim$todo(), 2)

## -----------------------------------------------------------------------------
sim$run()

## -----------------------------------------------------------------------------
sim$status() # or summary(sim)

## -----------------------------------------------------------------------------
sim$export_vars("a")
sim$run()

## -----------------------------------------------------------------------------
sim$setup({library(rlang)})
sim$run()

## -----------------------------------------------------------------------------
list.files(outdir, recursive = TRUE)

## -----------------------------------------------------------------------------
sim$run()

## -----------------------------------------------------------------------------
sim$result_df()

## -----------------------------------------------------------------------------
head(sim$erred(), 2)

## ----error = TRUE-------------------------------------------------------------
try({
errcfg <- sim$erred()[[1]]
# debugonce(f) # to step through it
set.seed(errcfg$seed)
do.call(f, errcfg$treatment)
})

## -----------------------------------------------------------------------------
f <- function(x, y) {
  p <- x*y
  u <- runif(1)
  dbl(p = p, u = u)
}

## -----------------------------------------------------------------------------
sim$worker(f)
sim

## -----------------------------------------------------------------------------
sim$run()

## -----------------------------------------------------------------------------
sim$result_df()

## -----------------------------------------------------------------------------
sim$nrep(5)

## -----------------------------------------------------------------------------
sim$eta()

## -----------------------------------------------------------------------------
sim$run()
sim$result_df()

