/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.util;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.net.URL;
import java.util.logging.Logger;

public class TextDataReader {
    private static Logger log = Logger.getLogger("umontreal.iro.lecuyer.util");

    public static double[] readDoubleData(Reader reader) throws IOException {
        String string;
        LineNumberReader lineNumberReader = new LineNumberReader(reader);
        double[] dArray = new double[5];
        int n = 0;
        while ((string = lineNumberReader.readLine()) != null) {
            int n2;
            if ((string = string.trim()).startsWith("#")) continue;
            for (n2 = 0; n2 < string.length() && (string.charAt(n2) == '+' || string.charAt(n2) == '-' || string.charAt(n2) == 'e' || string.charAt(n2) == 'E' || string.charAt(n2) == '.' || Character.isDigit(string.charAt(n2))); ++n2) {
            }
            if ((string = string.substring(0, n2)).equals("")) continue;
            try {
                dArray[n++] = Double.parseDouble(string);
                if (n < dArray.length) continue;
                double[] dArray2 = new double[2 * n];
                System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
                dArray = dArray2;
            }
            catch (NumberFormatException numberFormatException) {
                log.warning("Invalid line " + lineNumberReader.getLineNumber() + ": " + string);
            }
        }
        if (dArray.length != n) {
            double[] dArray3 = new double[n];
            System.arraycopy(dArray, 0, dArray3, 0, n);
            return dArray3;
        }
        return dArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double[] readDoubleData(URL uRL) throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader(uRL.openStream());
        try {
            double[] dArray = TextDataReader.readDoubleData(inputStreamReader);
            return dArray;
        }
        finally {
            ((Reader)inputStreamReader).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double[] readDoubleData(File file) throws IOException {
        FileReader fileReader = new FileReader(file);
        try {
            double[] dArray = TextDataReader.readDoubleData(fileReader);
            return dArray;
        }
        finally {
            fileReader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double[] readDoubleData(String string) throws IOException {
        FileReader fileReader = new FileReader(string);
        try {
            double[] dArray = TextDataReader.readDoubleData(fileReader);
            return dArray;
        }
        finally {
            fileReader.close();
        }
    }

    public static int[] readIntData(Reader reader) throws IOException {
        String string;
        LineNumberReader lineNumberReader = new LineNumberReader(reader);
        int[] nArray = new int[5];
        int n = 0;
        while ((string = lineNumberReader.readLine()) != null) {
            int n2;
            if ((string = string.trim()).startsWith("#")) continue;
            for (n2 = 0; n2 < string.length() && (string.charAt(n2) == '+' || string.charAt(n2) == '-' || Character.isDigit(string.charAt(n2))); ++n2) {
            }
            if ((string = string.substring(0, n2)).equals("")) continue;
            try {
                nArray[n++] = Integer.parseInt(string);
                if (n < nArray.length) continue;
                int[] nArray2 = new int[2 * n];
                System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
                nArray = nArray2;
            }
            catch (NumberFormatException numberFormatException) {
                log.warning("Invalid line " + lineNumberReader.getLineNumber() + ": " + string);
            }
        }
        if (nArray.length != n) {
            int[] nArray3 = new int[n];
            System.arraycopy(nArray, 0, nArray3, 0, n);
            return nArray3;
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] readIntData(URL uRL) throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader(uRL.openStream());
        try {
            int[] nArray = TextDataReader.readIntData(inputStreamReader);
            return nArray;
        }
        finally {
            ((Reader)inputStreamReader).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] readIntData(File file) throws IOException {
        FileReader fileReader = new FileReader(file);
        try {
            int[] nArray = TextDataReader.readIntData(fileReader);
            return nArray;
        }
        finally {
            fileReader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] readIntData(String string) throws IOException {
        FileReader fileReader = new FileReader(string);
        try {
            int[] nArray = TextDataReader.readIntData(fileReader);
            return nArray;
        }
        finally {
            fileReader.close();
        }
    }

    public static String[] readStringData(Reader reader) throws IOException {
        String[] stringArray;
        String string;
        LineNumberReader lineNumberReader = new LineNumberReader(reader);
        String[] stringArray2 = new String[5];
        int n = 0;
        while ((string = lineNumberReader.readLine()) != null) {
            if ((string = string.trim()).startsWith("#")) continue;
            stringArray2[n++] = string;
            if (n < stringArray2.length) continue;
            stringArray = new String[2 * n];
            System.arraycopy(stringArray2, 0, stringArray, 0, stringArray2.length);
            stringArray2 = stringArray;
        }
        if (stringArray2.length != n) {
            stringArray = new String[n];
            System.arraycopy(stringArray2, 0, stringArray, 0, n);
            return stringArray;
        }
        return stringArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] readStringData(URL uRL) throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader(uRL.openStream());
        try {
            String[] stringArray = TextDataReader.readStringData(inputStreamReader);
            return stringArray;
        }
        finally {
            ((Reader)inputStreamReader).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] readStringData(File file) throws IOException {
        FileReader fileReader = new FileReader(file);
        try {
            String[] stringArray = TextDataReader.readStringData(fileReader);
            return stringArray;
        }
        finally {
            fileReader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] readStringData(String string) throws IOException {
        FileReader fileReader = new FileReader(string);
        try {
            String[] stringArray = TextDataReader.readStringData(fileReader);
            return stringArray;
        }
        finally {
            fileReader.close();
        }
    }

    public static double[][] readDoubleData2D(Reader reader) throws IOException {
        String string;
        LineNumberReader lineNumberReader = new LineNumberReader(reader);
        double[][] dArrayArray = new double[5][];
        int n = 0;
        while ((string = lineNumberReader.readLine()) != null) {
            if ((string = string.trim()).startsWith("#")) continue;
            if (string.equals(";")) {
                dArrayArray[n++] = new double[0];
            } else {
                int n2 = 0;
                int n3 = 0;
                boolean bl = false;
                double[] dArray = new double[5];
                int n4 = 0;
                while (n2 < string.length() && !bl) {
                    while (n2 < string.length() && (string.charAt(n2) == '+' || string.charAt(n2) == '-' || string.charAt(n2) == 'e' || string.charAt(n2) == 'E' || string.charAt(n2) == '.' || Character.isDigit(string.charAt(n2)))) {
                        ++n2;
                    }
                    if (n2 >= string.length() || Character.isWhitespace(string.charAt(n2))) {
                        String string2 = string.substring(n3, n2);
                        n3 = ++n2;
                        if (string2.equals("")) continue;
                        try {
                            dArray[n4++] = Double.parseDouble(string2);
                            if (n4 < dArray.length) continue;
                            double[] dArray2 = new double[2 * n4];
                            System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
                            dArray = dArray2;
                        }
                        catch (NumberFormatException numberFormatException) {
                            log.warning("Invalid column " + n4 + " at line " + lineNumberReader.getLineNumber() + ": " + string2);
                        }
                        continue;
                    }
                    bl = true;
                }
                if (n4 > 0) {
                    dArrayArray[n] = new double[n4];
                    System.arraycopy(dArray, 0, dArrayArray[n], 0, n4);
                    ++n;
                } else {
                    log.warning("Invalid line " + lineNumberReader.getLineNumber() + ": " + string);
                }
            }
            if (n != dArrayArray.length) continue;
            double[][] dArrayArray2 = new double[2 * n][];
            System.arraycopy(dArrayArray, 0, dArrayArray2, 0, n);
            dArrayArray = dArrayArray2;
        }
        double[][] dArrayArray3 = new double[n][];
        System.arraycopy(dArrayArray, 0, dArrayArray3, 0, n);
        return dArrayArray3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double[][] readDoubleData2D(URL uRL) throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader(uRL.openStream());
        try {
            double[][] dArray = TextDataReader.readDoubleData2D(inputStreamReader);
            return dArray;
        }
        finally {
            ((Reader)inputStreamReader).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double[][] readDoubleData2D(File file) throws IOException {
        FileReader fileReader = new FileReader(file);
        try {
            double[][] dArray = TextDataReader.readDoubleData2D(fileReader);
            return dArray;
        }
        finally {
            fileReader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double[][] readDoubleData2D(String string) throws IOException {
        FileReader fileReader = new FileReader(string);
        try {
            double[][] dArray = TextDataReader.readDoubleData2D(fileReader);
            return dArray;
        }
        finally {
            fileReader.close();
        }
    }

    public static int[][] readIntData2D(Reader reader) throws IOException {
        String string;
        LineNumberReader lineNumberReader = new LineNumberReader(reader);
        int[][] nArrayArray = new int[5][];
        int n = 0;
        while ((string = lineNumberReader.readLine()) != null) {
            if ((string = string.trim()).startsWith("#")) continue;
            if (string.equals(";")) {
                nArrayArray[n++] = new int[0];
            } else {
                int n2 = 0;
                int n3 = 0;
                boolean bl = false;
                int[] nArray = new int[5];
                int n4 = 0;
                while (n2 < string.length() && !bl) {
                    while (n2 < string.length() && (string.charAt(n2) == '+' || string.charAt(n2) == '-' || Character.isDigit(string.charAt(n2)))) {
                        ++n2;
                    }
                    if (n2 >= string.length() || Character.isWhitespace(string.charAt(n2))) {
                        String string2 = string.substring(n3, n2);
                        n3 = ++n2;
                        if (string2.equals("")) continue;
                        try {
                            nArray[n4++] = Integer.parseInt(string2);
                            if (n4 < nArray.length) continue;
                            int[] nArray2 = new int[2 * n4];
                            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
                            nArray = nArray2;
                        }
                        catch (NumberFormatException numberFormatException) {
                            log.warning("Invalid column " + n4 + " at line " + lineNumberReader.getLineNumber() + ": " + string2);
                        }
                        continue;
                    }
                    bl = true;
                }
                if (n4 > 0) {
                    nArrayArray[n] = new int[n4];
                    System.arraycopy(nArray, 0, nArrayArray[n], 0, n4);
                    ++n;
                } else {
                    log.warning("Invalid line " + lineNumberReader.getLineNumber() + ": " + string);
                }
            }
            if (n != nArrayArray.length) continue;
            int[][] nArrayArray2 = new int[2 * n][];
            System.arraycopy(nArrayArray, 0, nArrayArray2, 0, n);
            nArrayArray = nArrayArray2;
        }
        int[][] nArrayArray3 = new int[n][];
        System.arraycopy(nArrayArray, 0, nArrayArray3, 0, n);
        return nArrayArray3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[][] readIntData2D(URL uRL) throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader(uRL.openStream());
        try {
            int[][] nArray = TextDataReader.readIntData2D(inputStreamReader);
            return nArray;
        }
        finally {
            ((Reader)inputStreamReader).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[][] readIntData2D(File file) throws IOException {
        FileReader fileReader = new FileReader(file);
        try {
            int[][] nArray = TextDataReader.readIntData2D(fileReader);
            return nArray;
        }
        finally {
            fileReader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[][] readIntData2D(String string) throws IOException {
        FileReader fileReader = new FileReader(string);
        try {
            int[][] nArray = TextDataReader.readIntData2D(fileReader);
            return nArray;
        }
        finally {
            fileReader.close();
        }
    }

    public static String[][] readCSVData(Reader reader, char c, char c2) throws IOException {
        LineNumberReader lineNumberReader = new LineNumberReader(reader);
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        String[][] stringArray = new String[5][];
        int n = 0;
        int n2 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        int n3 = -1;
        char c3 = ' ';
        boolean bl4 = false;
        while (!bl4) {
            if (n3 == -2) {
                n3 = 0;
            } else {
                n3 = lineNumberReader.read();
                if (n3 == -1) {
                    bl4 = true;
                    bl3 = true;
                    bl2 = true;
                } else {
                    c3 = (char)n3;
                }
            }
            if (n3 != -1) {
                char c4;
                if (bl) {
                    if (c3 == c2) {
                        int n4 = lineNumberReader.read();
                        if (n4 >= 0) {
                            c4 = (char)n4;
                            if (c4 == c2) {
                                stringBuffer.append(c2);
                            } else {
                                bl = false;
                                n3 = -2;
                                c3 = c4;
                            }
                        }
                    } else {
                        stringBuffer.append(c3);
                    }
                } else if (c3 == '\n' || c3 == '\r') {
                    int n5 = lineNumberReader.read();
                    if (n5 >= 0) {
                        c4 = (char)n5;
                        if (c3 == '\r' && c4 == '\n') {
                            n5 = lineNumberReader.read();
                            if (n5 >= 0) {
                                c4 = (char)n5;
                                n3 = -2;
                                c3 = c4;
                                bl2 = true;
                            }
                        } else {
                            n3 = -2;
                            c3 = c4;
                            bl2 = true;
                        }
                    }
                } else if (c3 == c) {
                    bl3 = true;
                } else if (c3 == c2) {
                    bl = true;
                } else {
                    stringBuffer.append(c3);
                }
            }
            if (bl3 || bl2) {
                if (n2 == 0) {
                    ++n;
                    n2 = 1;
                } else {
                    ++n2;
                }
                if (stringArray.length < n) {
                    String[][] stringArrayArray = new String[2 * stringArray.length][];
                    System.arraycopy(stringArray, 0, stringArrayArray, 0, stringArray.length);
                    stringArray = stringArrayArray;
                }
                if (stringArray[n - 1] == null) {
                    stringArray[n - 1] = new String[5];
                } else if (stringArray[n - 1].length < n2) {
                    String[] stringArray2 = new String[2 * stringArray[n - 1].length];
                    System.arraycopy(stringArray[n - 1], 0, stringArray2, 0, stringArray[n - 1].length);
                    stringArray[n - 1] = stringArray2;
                }
                stringArray[n - 1][n2 - 1] = stringBuffer.toString();
                stringBuffer.delete(0, stringBuffer.length());
                bl3 = false;
            }
            if (!bl2) continue;
            if (stringArray[n - 1].length != n2) {
                String[] stringArray3 = new String[n2];
                System.arraycopy(stringArray[n - 1], 0, stringArray3, 0, n2);
                stringArray[n - 1] = stringArray3;
            }
            n2 = 0;
            bl2 = false;
        }
        if (bl) {
            throw new IllegalArgumentException("Too many string delimiters " + c2);
        }
        if (stringArray.length != n) {
            String[][] stringArray4 = new String[n][];
            System.arraycopy(stringArray, 0, stringArray4, 0, n);
            return stringArray4;
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[][] readCSVData(URL uRL, char c, char c2) throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader(uRL.openStream());
        try {
            String[][] stringArray = TextDataReader.readCSVData(inputStreamReader, c, c2);
            return stringArray;
        }
        finally {
            ((Reader)inputStreamReader).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[][] readCSVData(File file, char c, char c2) throws IOException {
        FileReader fileReader = new FileReader(file);
        try {
            String[][] stringArray = TextDataReader.readCSVData(fileReader, c, c2);
            return stringArray;
        }
        finally {
            fileReader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[][] readCSVData(String string, char c, char c2) throws IOException {
        FileReader fileReader = new FileReader(string);
        try {
            String[][] stringArray = TextDataReader.readCSVData(fileReader, c, c2);
            return stringArray;
        }
        finally {
            fileReader.close();
        }
    }
}

