/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tlong;

import cern.colt.function.tlong.LongProcedure;
import cern.colt.list.tint.IntArrayList;
import cern.colt.list.tlong.LongArrayList;
import cern.colt.matrix.tlong.LongMatrix1D;
import cern.colt.matrix.tlong.LongMatrix2D;
import cern.colt.matrix.tlong.LongMatrix2DProcedure;
import cern.colt.matrix.tlong.LongMatrix3D;
import cern.jet.math.tlong.LongFunctions;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.Random;
import junit.framework.TestCase;

public abstract class LongMatrix3DTest
extends TestCase {
    protected LongMatrix3D A;
    protected LongMatrix3D B;
    protected int NSLICES = 5;
    protected int NROWS = 13;
    protected int NCOLUMNS = 17;
    protected Random rand = new Random(0L);

    public LongMatrix3DTest(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        this.createMatrices();
        this.populateMatrices();
    }

    protected abstract void createMatrices() throws Exception;

    protected void populateMatrices() {
        int n;
        int n2;
        int n3;
        ConcurrencyUtils.setThreadsBeginN_3D(1);
        for (n3 = 0; n3 < this.A.slices(); ++n3) {
            for (n2 = 0; n2 < this.A.rows(); ++n2) {
                for (n = 0; n < this.A.columns(); ++n) {
                    this.A.setQuick(n3, n2, n, Math.max(1L, this.rand.nextLong() % (long)this.A.rows()));
                }
            }
        }
        for (n3 = 0; n3 < this.B.slices(); ++n3) {
            for (n2 = 0; n2 < this.B.rows(); ++n2) {
                for (n = 0; n < this.B.columns(); ++n) {
                    this.B.setQuick(n3, n2, n, Math.max(1L, this.rand.nextLong() % (long)this.B.rows()));
                }
            }
        }
    }

    protected void tearDown() throws Exception {
        this.B = null;
        this.A = null;
    }

    public void testAggregateLongLongFunctionLongFunction() {
        long l = 0L;
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    long l2 = this.A.getQuick(i, j, k);
                    l += l2 * l2;
                }
            }
        }
        long l3 = this.A.aggregate(LongFunctions.plus, LongFunctions.square);
        LongMatrix3DTest.assertEquals((long)l, (long)l3);
    }

    public void testAggregateLongLongFunctionLongFunctionLongProcedure() {
        LongProcedure longProcedure = new LongProcedure(){

            public boolean apply(long l) {
                return (double)Math.abs(l) > 0.2;
            }
        };
        long l = 0L;
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    long l2 = this.A.getQuick(i, j, k);
                    if (!((double)Math.abs(l2) > 0.2)) continue;
                    l += l2 * l2;
                }
            }
        }
        long l3 = this.A.aggregate(LongFunctions.plus, LongFunctions.square, longProcedure);
        LongMatrix3DTest.assertEquals((long)l, (long)l3);
    }

    public void testAggregateLongLongFunctionLongFunctionIntArrayListIntArrayListIntArrayList() {
        int n;
        IntArrayList intArrayList = new IntArrayList();
        IntArrayList intArrayList2 = new IntArrayList();
        IntArrayList intArrayList3 = new IntArrayList();
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (n = 0; n < this.A.columns(); ++n) {
                    intArrayList.add(i);
                    intArrayList2.add(j);
                    intArrayList3.add(n);
                }
            }
        }
        long l = 0L;
        for (n = 0; n < this.A.slices(); ++n) {
            for (int i = 0; i < this.A.rows(); ++i) {
                for (int j = 0; j < this.A.columns(); ++j) {
                    long l2 = this.A.getQuick(n, i, j);
                    l += l2 * l2;
                }
            }
        }
        long l3 = this.A.aggregate(LongFunctions.plus, LongFunctions.square, intArrayList, intArrayList2, intArrayList3);
        LongMatrix3DTest.assertEquals((long)l, (long)l3);
    }

    public void testAggregateLongMatrix2DLongLongFunctionLongLongFunction() {
        long l = 0L;
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    long l2 = this.A.getQuick(i, j, k);
                    long l3 = this.B.getQuick(i, j, k);
                    l += l2 * l3;
                }
            }
        }
        long l4 = this.A.aggregate(this.B, LongFunctions.plus, LongFunctions.mult);
        LongMatrix3DTest.assertEquals((long)l, (long)l4);
    }

    public void testAssignLong() {
        long l = this.rand.nextLong();
        this.A.assign(l);
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    LongMatrix3DTest.assertEquals((long)l, (long)this.A.getQuick(i, j, k));
                }
            }
        }
    }

    public void testAssignLongArray() {
        long[] lArray = new long[(int)this.A.size()];
        int n = 0;
        while ((long)n < this.A.size()) {
            lArray[n] = this.rand.nextLong();
            ++n;
        }
        this.A.assign(lArray);
        n = 0;
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    LongMatrix3DTest.assertEquals((long)lArray[n++], (long)this.A.getQuick(i, j, k));
                }
            }
        }
    }

    public void testAssignLongArrayArrayArray() {
        int n;
        int n2;
        int n3;
        long[][][] lArray = new long[this.A.slices()][this.A.rows()][this.A.columns()];
        for (n3 = 0; n3 < this.A.slices(); ++n3) {
            for (n2 = 0; n2 < this.A.rows(); ++n2) {
                for (n = 0; n < this.A.columns(); ++n) {
                    lArray[n3][n2][n] = this.rand.nextLong();
                }
            }
        }
        this.A.assign(lArray);
        for (n3 = 0; n3 < this.A.slices(); ++n3) {
            LongMatrix3DTest.assertTrue((this.A.rows() == lArray[n3].length ? 1 : 0) != 0);
            for (n2 = 0; n2 < this.A.rows(); ++n2) {
                LongMatrix3DTest.assertTrue((this.A.columns() == lArray[n3][n2].length ? 1 : 0) != 0);
                for (n = 0; n < this.A.columns(); ++n) {
                    LongMatrix3DTest.assertEquals((long)lArray[n3][n2][n], (long)this.A.getQuick(n3, n2, n));
                }
            }
        }
    }

    public void testAssignLongFunction() {
        LongMatrix3D longMatrix3D = this.A.copy();
        this.A.assign(LongFunctions.neg);
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    long l = -longMatrix3D.getQuick(i, j, k);
                    LongMatrix3DTest.assertEquals((long)l, (long)this.A.getQuick(i, j, k));
                }
            }
        }
    }

    public void testAssignLongMatrix3D() {
        this.A.assign(this.B);
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    LongMatrix3DTest.assertEquals((long)this.B.getQuick(i, j, k), (long)this.A.getQuick(i, j, k));
                }
            }
        }
    }

    public void testAssignLongMatrix3DLongLongFunction() {
        LongMatrix3D longMatrix3D = this.A.copy();
        this.A.assign(this.B, LongFunctions.plus);
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    LongMatrix3DTest.assertEquals((long)(longMatrix3D.getQuick(i, j, k) + this.B.getQuick(i, j, k)), (long)this.A.getQuick(i, j, k));
                }
            }
        }
    }

    public void testAssignLongMatrix3DLongLongFunctionIntArrayListIntArrayListIntArrayList() {
        int n;
        int n2;
        IntArrayList intArrayList = new IntArrayList();
        IntArrayList intArrayList2 = new IntArrayList();
        IntArrayList intArrayList3 = new IntArrayList();
        for (int i = 0; i < this.A.slices(); ++i) {
            for (n2 = 0; n2 < this.A.rows(); ++n2) {
                for (n = 0; n < this.A.columns(); ++n) {
                    intArrayList.add(i);
                    intArrayList2.add(n2);
                    intArrayList3.add(n);
                }
            }
        }
        LongMatrix3D longMatrix3D = this.A.copy();
        this.A.assign(this.B, LongFunctions.plus, intArrayList, intArrayList2, intArrayList3);
        for (n2 = 0; n2 < this.A.slices(); ++n2) {
            for (n = 0; n < this.A.rows(); ++n) {
                for (int i = 0; i < this.A.columns(); ++i) {
                    LongMatrix3DTest.assertEquals((long)(longMatrix3D.getQuick(n2, n, i) + this.B.getQuick(n2, n, i)), (long)this.A.getQuick(n2, n, i));
                }
            }
        }
    }

    public void testAssignLongProcedureLong() {
        LongProcedure longProcedure = new LongProcedure(){

            public boolean apply(long l) {
                return Math.abs(l) > 1L;
            }
        };
        LongMatrix3D longMatrix3D = this.A.copy();
        this.A.assign(longProcedure, -1L);
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    if (Math.abs(longMatrix3D.getQuick(i, j, k)) > 1L) {
                        LongMatrix3DTest.assertEquals((long)-1L, (long)this.A.getQuick(i, j, k));
                        continue;
                    }
                    LongMatrix3DTest.assertEquals((long)longMatrix3D.getQuick(i, j, k), (long)this.A.getQuick(i, j, k));
                }
            }
        }
    }

    public void testAssignLongProcedureLongFunction() {
        LongProcedure longProcedure = new LongProcedure(){

            public boolean apply(long l) {
                return Math.abs(l) > 1L;
            }
        };
        LongMatrix3D longMatrix3D = this.A.copy();
        this.A.assign(longProcedure, LongFunctions.neg);
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    if (Math.abs(longMatrix3D.getQuick(i, j, k)) > 1L) {
                        LongMatrix3DTest.assertEquals((long)(-longMatrix3D.getQuick(i, j, k)), (long)this.A.getQuick(i, j, k));
                        continue;
                    }
                    LongMatrix3DTest.assertEquals((long)longMatrix3D.getQuick(i, j, k), (long)this.A.getQuick(i, j, k));
                }
            }
        }
    }

    public void testCardinality() {
        int n = this.A.cardinality();
        int n2 = 0;
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    if (this.A.getQuick(i, j, k) == 0L) continue;
                    ++n2;
                }
            }
        }
        LongMatrix3DTest.assertEquals((int)n2, (int)n);
    }

    public void testEqualsLong() {
        long l = 1L;
        this.A.assign(l);
        boolean bl = this.A.equals(l);
        LongMatrix3DTest.assertTrue((boolean)bl);
        bl = this.A.equals(2L);
        LongMatrix3DTest.assertFalse((boolean)bl);
    }

    public void testEqualsObject() {
        boolean bl = this.A.equals(this.A);
        LongMatrix3DTest.assertTrue((boolean)bl);
        bl = this.A.equals(this.B);
        LongMatrix3DTest.assertFalse((boolean)bl);
    }

    public void testMaxLocation() {
        this.A.assign(0L);
        this.A.setQuick(this.A.slices() / 3, this.A.rows() / 3, this.A.columns() / 3, 7L);
        this.A.setQuick(this.A.slices() / 3, this.A.rows() / 2, this.A.columns() / 2, 1L);
        long[] lArray = this.A.getMaxLocation();
        LongMatrix3DTest.assertEquals((long)7L, (long)lArray[0]);
        LongMatrix3DTest.assertEquals((int)(this.A.slices() / 3), (int)((int)lArray[1]));
        LongMatrix3DTest.assertEquals((int)(this.A.rows() / 3), (int)((int)lArray[2]));
        LongMatrix3DTest.assertEquals((int)(this.A.columns() / 3), (int)((int)lArray[3]));
    }

    public void testMinLocation() {
        this.A.assign(0L);
        this.A.setQuick(this.A.slices() / 3, this.A.rows() / 3, this.A.columns() / 3, -7L);
        this.A.setQuick(this.A.slices() / 3, this.A.rows() / 2, this.A.columns() / 2, -1L);
        long[] lArray = this.A.getMinLocation();
        LongMatrix3DTest.assertEquals((long)-7L, (long)lArray[0]);
        LongMatrix3DTest.assertEquals((int)(this.A.slices() / 3), (int)((int)lArray[1]));
        LongMatrix3DTest.assertEquals((int)(this.A.rows() / 3), (int)((int)lArray[2]));
        LongMatrix3DTest.assertEquals((int)(this.A.columns() / 3), (int)((int)lArray[3]));
    }

    public void testGetNegativeValues() {
        this.A.assign(0L);
        this.A.setQuick(this.A.slices() / 3, this.A.rows() / 3, this.A.columns() / 3, -7L);
        this.A.setQuick(this.A.slices() / 2, this.A.rows() / 2, this.A.columns() / 2, -1L);
        IntArrayList intArrayList = new IntArrayList();
        IntArrayList intArrayList2 = new IntArrayList();
        IntArrayList intArrayList3 = new IntArrayList();
        LongArrayList longArrayList = new LongArrayList();
        this.A.getNegativeValues(intArrayList, intArrayList2, intArrayList3, longArrayList);
        LongMatrix3DTest.assertEquals((int)2, (int)intArrayList.size());
        LongMatrix3DTest.assertEquals((int)2, (int)intArrayList2.size());
        LongMatrix3DTest.assertEquals((int)2, (int)intArrayList3.size());
        LongMatrix3DTest.assertEquals((int)2, (int)longArrayList.size());
        LongMatrix3DTest.assertTrue((boolean)intArrayList.contains(this.A.slices() / 3));
        LongMatrix3DTest.assertTrue((boolean)intArrayList.contains(this.A.slices() / 2));
        LongMatrix3DTest.assertTrue((boolean)intArrayList2.contains(this.A.rows() / 3));
        LongMatrix3DTest.assertTrue((boolean)intArrayList2.contains(this.A.rows() / 2));
        LongMatrix3DTest.assertTrue((boolean)intArrayList3.contains(this.A.columns() / 3));
        LongMatrix3DTest.assertTrue((boolean)intArrayList3.contains(this.A.columns() / 2));
        LongMatrix3DTest.assertTrue((boolean)longArrayList.contains(-7L));
        LongMatrix3DTest.assertTrue((boolean)longArrayList.contains(-1L));
    }

    public void testGetNonZeros() {
        this.A.assign(0L);
        this.A.setQuick(this.A.slices() / 3, this.A.rows() / 3, this.A.columns() / 3, 7L);
        this.A.setQuick(this.A.slices() / 2, this.A.rows() / 2, this.A.columns() / 2, 1L);
        IntArrayList intArrayList = new IntArrayList();
        IntArrayList intArrayList2 = new IntArrayList();
        IntArrayList intArrayList3 = new IntArrayList();
        LongArrayList longArrayList = new LongArrayList();
        this.A.getNonZeros(intArrayList, intArrayList2, intArrayList3, longArrayList);
        LongMatrix3DTest.assertEquals((int)2, (int)intArrayList.size());
        LongMatrix3DTest.assertEquals((int)2, (int)intArrayList2.size());
        LongMatrix3DTest.assertEquals((int)2, (int)intArrayList3.size());
        LongMatrix3DTest.assertEquals((int)2, (int)longArrayList.size());
        LongMatrix3DTest.assertTrue((boolean)intArrayList.contains(this.A.slices() / 3));
        LongMatrix3DTest.assertTrue((boolean)intArrayList.contains(this.A.slices() / 2));
        LongMatrix3DTest.assertTrue((boolean)intArrayList2.contains(this.A.rows() / 3));
        LongMatrix3DTest.assertTrue((boolean)intArrayList2.contains(this.A.rows() / 2));
        LongMatrix3DTest.assertTrue((boolean)intArrayList3.contains(this.A.columns() / 3));
        LongMatrix3DTest.assertTrue((boolean)intArrayList3.contains(this.A.columns() / 2));
        LongMatrix3DTest.assertTrue((boolean)longArrayList.contains(7L));
        LongMatrix3DTest.assertTrue((boolean)longArrayList.contains(1L));
    }

    public void testGetPositiveValues() {
        this.A.assign(0L);
        this.A.setQuick(this.A.slices() / 3, this.A.rows() / 3, this.A.columns() / 3, 7L);
        this.A.setQuick(this.A.slices() / 2, this.A.rows() / 2, this.A.columns() / 2, 1L);
        IntArrayList intArrayList = new IntArrayList();
        IntArrayList intArrayList2 = new IntArrayList();
        IntArrayList intArrayList3 = new IntArrayList();
        LongArrayList longArrayList = new LongArrayList();
        this.A.getPositiveValues(intArrayList, intArrayList2, intArrayList3, longArrayList);
        LongMatrix3DTest.assertEquals((int)2, (int)intArrayList.size());
        LongMatrix3DTest.assertEquals((int)2, (int)intArrayList2.size());
        LongMatrix3DTest.assertEquals((int)2, (int)intArrayList3.size());
        LongMatrix3DTest.assertEquals((int)2, (int)longArrayList.size());
        LongMatrix3DTest.assertTrue((boolean)intArrayList.contains(this.A.slices() / 3));
        LongMatrix3DTest.assertTrue((boolean)intArrayList.contains(this.A.slices() / 2));
        LongMatrix3DTest.assertTrue((boolean)intArrayList2.contains(this.A.rows() / 3));
        LongMatrix3DTest.assertTrue((boolean)intArrayList2.contains(this.A.rows() / 2));
        LongMatrix3DTest.assertTrue((boolean)intArrayList3.contains(this.A.columns() / 3));
        LongMatrix3DTest.assertTrue((boolean)intArrayList3.contains(this.A.columns() / 2));
        LongMatrix3DTest.assertTrue((boolean)longArrayList.contains(7L));
        LongMatrix3DTest.assertTrue((boolean)longArrayList.contains(1L));
    }

    public void testToArray() {
        long[][][] lArray = this.A.toArray();
        for (int i = 0; i < this.A.slices(); ++i) {
            LongMatrix3DTest.assertTrue((this.A.rows() == lArray[i].length ? 1 : 0) != 0);
            for (int j = 0; j < this.A.rows(); ++j) {
                LongMatrix3DTest.assertTrue((this.A.columns() == lArray[i][j].length ? 1 : 0) != 0);
                for (int k = 0; k < this.A.columns(); ++k) {
                    LongMatrix3DTest.assertEquals((long)0L, (long)Math.abs(lArray[i][j][k] - this.A.getQuick(i, j, k)));
                }
            }
        }
    }

    public void testVectorize() {
        LongMatrix1D longMatrix1D = this.A.vectorize();
        int n = 0;
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                for (int k = 0; k < this.A.rows(); ++k) {
                    LongMatrix3DTest.assertEquals((long)this.A.getQuick(i, k, j), (long)longMatrix1D.getQuick(n++));
                }
            }
        }
    }

    public void testViewColumn() {
        LongMatrix2D longMatrix2D = this.A.viewColumn(this.A.columns() / 2);
        LongMatrix3DTest.assertEquals((int)this.A.slices(), (int)longMatrix2D.rows());
        LongMatrix3DTest.assertEquals((int)this.A.rows(), (int)longMatrix2D.columns());
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                LongMatrix3DTest.assertEquals((long)this.A.getQuick(i, j, this.A.columns() / 2), (long)longMatrix2D.getQuick(i, j));
            }
        }
    }

    public void testViewColumnFlip() {
        LongMatrix3D longMatrix3D = this.A.viewColumnFlip();
        LongMatrix3DTest.assertEquals((long)this.A.size(), (long)longMatrix3D.size());
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    LongMatrix3DTest.assertEquals((long)this.A.getQuick(i, j, this.A.columns() - 1 - k), (long)longMatrix3D.getQuick(i, j, k));
                }
            }
        }
    }

    public void testViewDice() {
        LongMatrix3D longMatrix3D = this.A.viewDice(2, 1, 0);
        LongMatrix3DTest.assertEquals((int)this.A.slices(), (int)longMatrix3D.columns());
        LongMatrix3DTest.assertEquals((int)this.A.rows(), (int)longMatrix3D.rows());
        LongMatrix3DTest.assertEquals((int)this.A.columns(), (int)longMatrix3D.slices());
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    LongMatrix3DTest.assertEquals((long)this.A.getQuick(i, j, k), (long)longMatrix3D.getQuick(k, j, i));
                }
            }
        }
    }

    public void testViewPart() {
        LongMatrix3D longMatrix3D = this.A.viewPart(this.A.slices() / 2, this.A.rows() / 2, this.A.columns() / 2, this.A.slices() / 3, this.A.rows() / 3, this.A.columns() / 3);
        for (int i = 0; i < this.A.slices() / 3; ++i) {
            for (int j = 0; j < this.A.rows() / 3; ++j) {
                for (int k = 0; k < this.A.columns() / 3; ++k) {
                    LongMatrix3DTest.assertEquals((long)this.A.getQuick(this.A.slices() / 2 + i, this.A.rows() / 2 + j, this.A.columns() / 2 + k), (long)longMatrix3D.getQuick(i, j, k));
                }
            }
        }
    }

    public void testViewRow() {
        LongMatrix2D longMatrix2D = this.A.viewRow(this.A.rows() / 2);
        LongMatrix3DTest.assertEquals((int)this.A.slices(), (int)longMatrix2D.rows());
        LongMatrix3DTest.assertEquals((int)this.A.columns(), (int)longMatrix2D.columns());
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                LongMatrix3DTest.assertEquals((long)this.A.getQuick(i, this.A.rows() / 2, j), (long)longMatrix2D.getQuick(i, j));
            }
        }
    }

    public void testViewRowFlip() {
        LongMatrix3D longMatrix3D = this.A.viewRowFlip();
        LongMatrix3DTest.assertEquals((long)this.A.size(), (long)longMatrix3D.size());
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    LongMatrix3DTest.assertEquals((long)this.A.getQuick(i, this.A.rows() - 1 - j, k), (long)longMatrix3D.getQuick(i, j, k));
                }
            }
        }
    }

    public void testViewSelectionLongMatrix2DProcedure() {
        this.A.assign(0L);
        this.A.setQuick(this.A.slices() / 2, this.A.rows() / 4, 0, 2L);
        LongMatrix3D longMatrix3D = this.A.viewSelection(new LongMatrix2DProcedure(){

            public boolean apply(LongMatrix2D longMatrix2D) {
                return Math.abs(longMatrix2D.getQuick(LongMatrix3DTest.this.A.rows() / 4, 0) - 2L) == 0L;
            }
        });
        LongMatrix3DTest.assertEquals((int)1, (int)longMatrix3D.slices());
        LongMatrix3DTest.assertEquals((int)this.A.rows(), (int)longMatrix3D.rows());
        LongMatrix3DTest.assertEquals((int)this.A.columns(), (int)longMatrix3D.columns());
        LongMatrix3DTest.assertEquals((long)this.A.getQuick(this.A.slices() / 2, this.A.rows() / 4, 0), (long)longMatrix3D.getQuick(0, this.A.rows() / 4, 0));
    }

    public void testViewSelectionIntArrayIntArrayIntArray() {
        int[] nArray = new int[]{this.A.slices() / 2, this.A.slices() / 3};
        int[] nArray2 = new int[]{this.A.rows() / 6, this.A.rows() / 5, this.A.rows() / 4, this.A.rows() / 3, this.A.rows() / 2};
        int[] nArray3 = new int[]{this.A.columns() / 6, this.A.columns() / 5, this.A.columns() / 4, this.A.columns() / 3, this.A.columns() / 2, this.A.columns() - 1};
        LongMatrix3D longMatrix3D = this.A.viewSelection(nArray, nArray2, nArray3);
        LongMatrix3DTest.assertEquals((int)nArray.length, (int)longMatrix3D.slices());
        LongMatrix3DTest.assertEquals((int)nArray2.length, (int)longMatrix3D.rows());
        LongMatrix3DTest.assertEquals((int)nArray3.length, (int)longMatrix3D.columns());
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray2.length; ++j) {
                for (int k = 0; k < nArray3.length; ++k) {
                    LongMatrix3DTest.assertEquals((long)this.A.getQuick(nArray[i], nArray2[j], nArray3[k]), (long)longMatrix3D.getQuick(i, j, k));
                }
            }
        }
    }

    public void testViewSlice() {
        LongMatrix2D longMatrix2D = this.A.viewSlice(this.A.slices() / 2);
        LongMatrix3DTest.assertEquals((int)this.A.rows(), (int)longMatrix2D.rows());
        LongMatrix3DTest.assertEquals((int)this.A.columns(), (int)longMatrix2D.columns());
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                LongMatrix3DTest.assertEquals((long)this.A.getQuick(this.A.slices() / 2, i, j), (long)longMatrix2D.getQuick(i, j));
            }
        }
    }

    public void testViewSliceFlip() {
        LongMatrix3D longMatrix3D = this.A.viewSliceFlip();
        LongMatrix3DTest.assertEquals((long)this.A.size(), (long)longMatrix3D.size());
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    LongMatrix3DTest.assertEquals((long)this.A.getQuick(this.A.slices() - 1 - i, j, k), (long)longMatrix3D.getQuick(i, j, k));
                }
            }
        }
    }

    public void testViewSorted() {
        LongMatrix3D longMatrix3D = this.A.viewSorted(1, 1);
        for (int i = 0; i < this.A.slices() - 1; ++i) {
            LongMatrix3DTest.assertTrue((longMatrix3D.getQuick(i + 1, 1, 1) >= longMatrix3D.getQuick(i, 1, 1) ? 1 : 0) != 0);
        }
    }

    public void testViewStrides() {
        int n = 2;
        int n2 = 2;
        int n3 = 2;
        LongMatrix3D longMatrix3D = this.A.viewStrides(n, n2, n3);
        for (int i = 0; i < longMatrix3D.slices(); ++i) {
            for (int j = 0; j < longMatrix3D.rows(); ++j) {
                for (int k = 0; k < longMatrix3D.columns(); ++k) {
                    LongMatrix3DTest.assertEquals((long)this.A.getQuick(i * n, j * n2, k * n3), (long)longMatrix3D.getQuick(i, j, k));
                }
            }
        }
    }

    public void testZSum() {
        long l = this.A.zSum();
        long l2 = 0L;
        for (int i = 0; i < this.A.slices(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                for (int k = 0; k < this.A.columns(); ++k) {
                    l2 += this.A.getQuick(i, j, k);
                }
            }
        }
        LongMatrix3DTest.assertEquals((long)l2, (long)l);
    }
}

