/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdcomplex;

import cern.colt.function.tdcomplex.DComplexDComplexDComplexFunction;
import cern.colt.function.tdcomplex.DComplexDComplexFunction;
import cern.colt.function.tdcomplex.DComplexProcedure;
import cern.colt.function.tdcomplex.DComplexRealFunction;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.AbstractMatrix3D;
import cern.colt.matrix.tdcomplex.DComplexMatrix1D;
import cern.colt.matrix.tdcomplex.DComplexMatrix2D;
import cern.colt.matrix.tdcomplex.DComplexMatrix2DProcedure;
import cern.colt.matrix.tdcomplex.algo.DComplexProperty;
import cern.colt.matrix.tdouble.DoubleMatrix3D;
import cern.jet.math.tdcomplex.DComplexFunctions;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DComplexMatrix3D
extends AbstractMatrix3D {
    private static final long serialVersionUID = 1L;

    protected DComplexMatrix3D() {
    }

    public double[] aggregate(final DComplexDComplexDComplexFunction dComplexDComplexDComplexFunction, final DComplexDComplexFunction dComplexDComplexFunction) {
        double[] dArray = new double[2];
        if (this.size() == 0L) {
            dArray[0] = Double.NaN;
            dArray[1] = Double.NaN;
            return dArray;
        }
        double[] dArray2 = null;
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            n = Math.min(n, this.slices);
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<double[]>(){

                    @Override
                    public double[] call() throws Exception {
                        double[] dArray = dComplexDComplexFunction.apply(DComplexMatrix3D.this.getQuick(n3, 0, 0));
                        int n = 1;
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < DComplexMatrix3D.this.rows; ++j) {
                                for (int k = n; k < DComplexMatrix3D.this.columns; ++k) {
                                    dArray = dComplexDComplexDComplexFunction.apply(dArray, dComplexDComplexFunction.apply(DComplexMatrix3D.this.getQuick(i, j, k)));
                                }
                                n = 0;
                            }
                        }
                        return dArray;
                    }
                });
            }
            dArray2 = ConcurrencyUtils.waitForCompletion(futureArray, dComplexDComplexDComplexFunction);
        } else {
            dArray2 = dComplexDComplexFunction.apply(this.getQuick(0, 0, 0));
            int n5 = 1;
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = n5; k < this.columns; ++k) {
                        dArray2 = dComplexDComplexDComplexFunction.apply(dArray2, dComplexDComplexFunction.apply(this.getQuick(i, j, k)));
                    }
                    n5 = 0;
                }
            }
        }
        return dArray2;
    }

    public double[] aggregate(final DComplexMatrix3D dComplexMatrix3D, final DComplexDComplexDComplexFunction dComplexDComplexDComplexFunction, final DComplexDComplexDComplexFunction dComplexDComplexDComplexFunction2) {
        this.checkShape(dComplexMatrix3D);
        double[] dArray = new double[2];
        if (this.size() == 0L) {
            dArray[0] = Double.NaN;
            dArray[1] = Double.NaN;
            return dArray;
        }
        double[] dArray2 = null;
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            n = Math.min(n, this.slices);
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<double[]>(){

                    @Override
                    public double[] call() throws Exception {
                        double[] dArray = dComplexDComplexDComplexFunction2.apply(DComplexMatrix3D.this.getQuick(n3, 0, 0), dComplexMatrix3D.getQuick(n3, 0, 0));
                        int n = 1;
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < DComplexMatrix3D.this.rows; ++j) {
                                for (int k = n; k < DComplexMatrix3D.this.columns; ++k) {
                                    dArray = dComplexDComplexDComplexFunction.apply(dArray, dComplexDComplexDComplexFunction2.apply(DComplexMatrix3D.this.getQuick(i, j, k), dComplexMatrix3D.getQuick(i, j, k)));
                                }
                                n = 0;
                            }
                        }
                        return dArray;
                    }
                });
            }
            dArray2 = ConcurrencyUtils.waitForCompletion(futureArray, dComplexDComplexDComplexFunction);
        } else {
            dArray2 = dComplexDComplexDComplexFunction2.apply(this.getQuick(0, 0, 0), dComplexMatrix3D.getQuick(0, 0, 0));
            int n5 = 1;
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = n5; k < this.columns; ++k) {
                        dArray2 = dComplexDComplexDComplexFunction.apply(dArray2, dComplexDComplexDComplexFunction2.apply(this.getQuick(i, j, k), dComplexMatrix3D.getQuick(i, j, k)));
                    }
                    n5 = 0;
                }
            }
        }
        return dArray2;
    }

    public DComplexMatrix3D assign(final DComplexDComplexFunction dComplexDComplexFunction) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            n = Math.min(n, this.slices);
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < DComplexMatrix3D.this.rows; ++j) {
                                for (int k = 0; k < DComplexMatrix3D.this.columns; ++k) {
                                    DComplexMatrix3D.this.setQuick(i, j, k, dComplexDComplexFunction.apply(DComplexMatrix3D.this.getQuick(i, j, k)));
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = 0; k < this.columns; ++k) {
                        this.setQuick(i, j, k, dComplexDComplexFunction.apply(this.getQuick(i, j, k)));
                    }
                }
            }
        }
        return this;
    }

    public DComplexMatrix3D assign(final DComplexRealFunction dComplexRealFunction) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            n = Math.min(n, this.slices);
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        double[] dArray = new double[2];
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < DComplexMatrix3D.this.rows; ++j) {
                                for (int k = 0; k < DComplexMatrix3D.this.columns; ++k) {
                                    dArray[0] = dComplexRealFunction.apply(DComplexMatrix3D.this.getQuick(i, j, k));
                                    DComplexMatrix3D.this.setQuick(i, j, k, dArray);
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            double[] dArray = new double[2];
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = 0; k < this.columns; ++k) {
                        dArray[0] = dComplexRealFunction.apply(this.getQuick(i, j, k));
                        this.setQuick(i, j, k, dArray);
                    }
                }
            }
        }
        return this;
    }

    public DComplexMatrix3D assign(final DComplexProcedure dComplexProcedure, final DComplexDComplexFunction dComplexDComplexFunction) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            n = Math.min(n, this.slices);
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < DComplexMatrix3D.this.rows; ++j) {
                                for (int k = 0; k < DComplexMatrix3D.this.columns; ++k) {
                                    double[] dArray = DComplexMatrix3D.this.getQuick(i, j, k);
                                    if (!dComplexProcedure.apply(dArray)) continue;
                                    DComplexMatrix3D.this.setQuick(i, j, k, dComplexDComplexFunction.apply(dArray));
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = 0; k < this.columns; ++k) {
                        double[] dArray = this.getQuick(i, j, k);
                        if (!dComplexProcedure.apply(dArray)) continue;
                        this.setQuick(i, j, k, dComplexDComplexFunction.apply(dArray));
                    }
                }
            }
        }
        return this;
    }

    public DComplexMatrix3D assign(final DComplexProcedure dComplexProcedure, final double[] dArray) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            n = Math.min(n, this.slices);
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < DComplexMatrix3D.this.rows; ++j) {
                                for (int k = 0; k < DComplexMatrix3D.this.columns; ++k) {
                                    double[] dArray2 = DComplexMatrix3D.this.getQuick(i, j, k);
                                    if (!dComplexProcedure.apply(dArray2)) continue;
                                    DComplexMatrix3D.this.setQuick(i, j, k, dArray);
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = 0; k < this.columns; ++k) {
                        double[] dArray2 = this.getQuick(i, j, k);
                        if (!dComplexProcedure.apply(dArray2)) continue;
                        this.setQuick(i, j, k, dArray);
                    }
                }
            }
        }
        return this;
    }

    public DComplexMatrix3D assign(DComplexMatrix3D dComplexMatrix3D) {
        if (dComplexMatrix3D == this) {
            return this;
        }
        this.checkShape(dComplexMatrix3D);
        final DComplexMatrix3D dComplexMatrix3D2 = this.haveSharedCells(dComplexMatrix3D) ? dComplexMatrix3D.copy() : dComplexMatrix3D;
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            n = Math.min(n, this.slices);
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < DComplexMatrix3D.this.rows; ++j) {
                                for (int k = 0; k < DComplexMatrix3D.this.columns; ++k) {
                                    DComplexMatrix3D.this.setQuick(i, j, k, dComplexMatrix3D2.getQuick(i, j, k));
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = 0; k < this.columns; ++k) {
                        this.setQuick(i, j, k, dComplexMatrix3D2.getQuick(i, j, k));
                    }
                }
            }
        }
        return this;
    }

    public DComplexMatrix3D assign(final DComplexMatrix3D dComplexMatrix3D, final DComplexDComplexDComplexFunction dComplexDComplexDComplexFunction) {
        this.checkShape(dComplexMatrix3D);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            n = Math.min(n, this.slices);
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < DComplexMatrix3D.this.rows; ++j) {
                                for (int k = 0; k < DComplexMatrix3D.this.columns; ++k) {
                                    DComplexMatrix3D.this.setQuick(i, j, k, dComplexDComplexDComplexFunction.apply(DComplexMatrix3D.this.getQuick(i, j, k), dComplexMatrix3D.getQuick(i, j, k)));
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = 0; k < this.columns; ++k) {
                        this.setQuick(i, j, k, dComplexDComplexDComplexFunction.apply(this.getQuick(i, j, k), dComplexMatrix3D.getQuick(i, j, k)));
                    }
                }
            }
        }
        return this;
    }

    public DComplexMatrix3D assign(final double d, final double d2) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            n = Math.min(n, this.slices);
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < DComplexMatrix3D.this.rows; ++j) {
                                for (int k = 0; k < DComplexMatrix3D.this.columns; ++k) {
                                    DComplexMatrix3D.this.setQuick(i, j, k, d, d2);
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = 0; k < this.columns; ++k) {
                        this.setQuick(i, j, k, d, d2);
                    }
                }
            }
        }
        return this;
    }

    public DComplexMatrix3D assign(final double[] dArray) {
        if (dArray.length != this.slices * this.rows * 2 * this.columns) {
            throw new IllegalArgumentException("Must have same length: length=" + dArray.length + "slices()*rows()*2*columns()=" + this.slices() * this.rows() * 2 * this.columns());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            n = Math.min(n, this.slices);
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n3 * DComplexMatrix3D.this.rows * DComplexMatrix3D.this.columns * 2;
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < DComplexMatrix3D.this.rows; ++j) {
                                for (int k = 0; k < DComplexMatrix3D.this.columns; ++k) {
                                    DComplexMatrix3D.this.setQuick(i, j, k, dArray[n], dArray[n + 1]);
                                    n += 2;
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n5 = 0;
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = 0; k < this.columns; ++k) {
                        this.setQuick(i, j, k, dArray[n5], dArray[n5 + 1]);
                        n5 += 2;
                    }
                }
            }
        }
        return this;
    }

    public DComplexMatrix3D assign(final double[][][] dArray) {
        if (dArray.length != this.slices) {
            throw new IllegalArgumentException("Must have same number of slices: slices=" + dArray.length + "slices()=" + this.slices());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.slices * this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_3D()) {
            n = Math.min(n, this.slices);
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            double[][] dArray3 = dArray[i];
                            if (dArray3.length != DComplexMatrix3D.this.rows) {
                                throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + dArray3.length + "rows()=" + DComplexMatrix3D.this.rows());
                            }
                            for (int j = 0; j < DComplexMatrix3D.this.rows; ++j) {
                                double[] dArray2 = dArray3[j];
                                if (dArray2.length != 2 * DComplexMatrix3D.this.columns) {
                                    throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + dArray2.length + "2*columns()=" + 2 * DComplexMatrix3D.this.columns());
                                }
                                for (int k = 0; k < DComplexMatrix3D.this.columns; ++k) {
                                    DComplexMatrix3D.this.setQuick(i, j, k, dArray2[2 * k], dArray2[2 * k + 1]);
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                double[][] dArray2 = dArray[i];
                if (dArray2.length != this.rows) {
                    throw new IllegalArgumentException("Must have same number of rows in every slice: rows=" + dArray2.length + "rows()=" + this.rows());
                }
                for (int j = 0; j < this.rows; ++j) {
                    double[] dArray3 = dArray2[j];
                    if (dArray3.length != 2 * this.columns) {
                        throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + dArray3.length + "2*columns()=" + 2 * this.columns());
                    }
                    for (int k = 0; k < this.columns; ++k) {
                        this.setQuick(i, j, k, dArray3[2 * k], dArray3[2 * k + 1]);
                    }
                }
            }
        }
        return this;
    }

    public DComplexMatrix3D assignImaginary(final DoubleMatrix3D doubleMatrix3D) {
        this.checkShape(doubleMatrix3D);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            n = Math.min(n, this.slices);
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < DComplexMatrix3D.this.rows; ++j) {
                                for (int k = 0; k < DComplexMatrix3D.this.columns; ++k) {
                                    double d = DComplexMatrix3D.this.getQuick(i, j, k)[0];
                                    double d2 = doubleMatrix3D.getQuick(i, j, k);
                                    DComplexMatrix3D.this.setQuick(i, j, k, d, d2);
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = 0; k < this.columns; ++k) {
                        double d = this.getQuick(i, j, k)[0];
                        double d2 = doubleMatrix3D.getQuick(i, j, k);
                        this.setQuick(i, j, k, d, d2);
                    }
                }
            }
        }
        return this;
    }

    public DComplexMatrix3D assignReal(final DoubleMatrix3D doubleMatrix3D) {
        this.checkShape(doubleMatrix3D);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            n = Math.min(n, this.slices);
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < DComplexMatrix3D.this.rows; ++j) {
                                for (int k = 0; k < DComplexMatrix3D.this.columns; ++k) {
                                    double d = doubleMatrix3D.getQuick(i, j, k);
                                    double d2 = DComplexMatrix3D.this.getQuick(i, j, k)[1];
                                    DComplexMatrix3D.this.setQuick(i, j, k, d, d2);
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = 0; k < this.columns; ++k) {
                        double d = doubleMatrix3D.getQuick(i, j, k);
                        double d2 = this.getQuick(i, j, k)[1];
                        this.setQuick(i, j, k, d, d2);
                    }
                }
            }
        }
        return this;
    }

    public int cardinality() {
        int n = 0;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            int n3;
            n2 = Math.min(n2, this.slices);
            Future[] futureArray = new Future[n2];
            Integer[] integerArray = new Integer[n2];
            int n4 = this.slices / n2;
            for (n3 = 0; n3 < n2; ++n3) {
                final int n5 = n3 * n4;
                final int n6 = n3 == n2 - 1 ? this.slices : n5 + n4;
                futureArray[n3] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int n = 0;
                        double[] dArray = new double[2];
                        for (int i = n5; i < n6; ++i) {
                            for (int j = 0; j < DComplexMatrix3D.this.rows; ++j) {
                                for (int k = 0; k < DComplexMatrix3D.this.columns; ++k) {
                                    dArray = DComplexMatrix3D.this.getQuick(i, j, k);
                                    if (dArray[0] == 0.0 && dArray[1] == 0.0) continue;
                                    ++n;
                                }
                            }
                        }
                        return n;
                    }
                });
            }
            try {
                for (n3 = 0; n3 < n2; ++n3) {
                    integerArray[n3] = (Integer)futureArray[n3].get();
                }
                n = integerArray[0];
                for (n3 = 1; n3 < n2; ++n3) {
                    n += integerArray[n3].intValue();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            double[] dArray = new double[2];
            for (int i = 0; i < this.slices; ++i) {
                for (int j = 0; j < this.rows; ++j) {
                    for (int k = 0; k < this.columns; ++k) {
                        dArray = this.getQuick(i, j, k);
                        if (dArray[0] == 0.0 && dArray[1] == 0.0) continue;
                        ++n;
                    }
                }
            }
        }
        return n;
    }

    public DComplexMatrix3D copy() {
        return this.like().assign(this);
    }

    public boolean equals(double[] dArray) {
        return DComplexProperty.DEFAULT.equals(this, dArray);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof DComplexMatrix3D)) {
            return false;
        }
        return DComplexProperty.DEFAULT.equals(this, (DComplexMatrix3D)object);
    }

    public double[] get(int n, int n2, int n3) {
        if (n < 0 || n >= this.slices || n2 < 0 || n2 >= this.rows || n3 < 0 || n3 >= this.columns) {
            throw new IndexOutOfBoundsException("slice:" + n + ", row:" + n2 + ", column:" + n3);
        }
        return this.getQuick(n, n2, n3);
    }

    public abstract Object elements();

    public abstract DoubleMatrix3D getImaginaryPart();

    public void getNonZeros(IntArrayList intArrayList, IntArrayList intArrayList2, IntArrayList intArrayList3, ArrayList<double[]> arrayList) {
        intArrayList.clear();
        intArrayList2.clear();
        intArrayList3.clear();
        arrayList.clear();
        for (int i = 0; i < this.slices; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                for (int k = 0; k < this.columns; ++k) {
                    double[] dArray = this.getQuick(i, j, k);
                    if (dArray[0] == 0.0 && dArray[1] == 0.0) continue;
                    intArrayList.add(i);
                    intArrayList2.add(j);
                    intArrayList3.add(k);
                    arrayList.add(dArray);
                }
            }
        }
    }

    public abstract double[] getQuick(int var1, int var2, int var3);

    public abstract DoubleMatrix3D getRealPart();

    public DComplexMatrix3D like() {
        return this.like(this.slices, this.rows, this.columns);
    }

    public abstract DComplexMatrix3D like(int var1, int var2, int var3);

    public void set(int n, int n2, int n3, double[] dArray) {
        if (n < 0 || n >= this.slices || n2 < 0 || n2 >= this.rows || n3 < 0 || n3 >= this.columns) {
            throw new IndexOutOfBoundsException("slice:" + n + ", row:" + n2 + ", column:" + n3);
        }
        this.setQuick(n, n2, n3, dArray);
    }

    public void set(int n, int n2, int n3, double d, double d2) {
        if (n < 0 || n >= this.slices || n2 < 0 || n2 >= this.rows || n3 < 0 || n3 >= this.columns) {
            throw new IndexOutOfBoundsException("slice:" + n + ", row:" + n2 + ", column:" + n3);
        }
        this.setQuick(n, n2, n3, d, d2);
    }

    public abstract void setQuick(int var1, int var2, int var3, double var4, double var6);

    public abstract void setQuick(int var1, int var2, int var3, double[] var4);

    public double[][][] toArray() {
        final double[][][] dArray = new double[this.slices][this.rows][2 * this.columns];
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            n = Math.min(n, this.slices);
            Future[] futureArray = new Future[n];
            int n2 = this.slices / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.slices : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        double[] dArray4 = new double[2];
                        for (int i = n3; i < n4; ++i) {
                            double[][] dArray2 = dArray[i];
                            for (int j = 0; j < DComplexMatrix3D.this.rows; ++j) {
                                double[] dArray3 = dArray2[j];
                                for (int k = 0; k < DComplexMatrix3D.this.columns; ++k) {
                                    dArray4 = DComplexMatrix3D.this.getQuick(i, j, k);
                                    dArray3[2 * k] = dArray4[0];
                                    dArray3[2 * k + 1] = dArray4[1];
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            double[] dArray2 = new double[2];
            for (int i = 0; i < this.slices; ++i) {
                double[][] dArray3 = dArray[i];
                for (int j = 0; j < this.rows; ++j) {
                    double[] dArray4 = dArray3[j];
                    for (int k = 0; k < this.columns; ++k) {
                        dArray2 = this.getQuick(i, j, k);
                        dArray4[2 * k] = dArray2[0];
                        dArray4[2 * k + 1] = dArray2[1];
                    }
                }
            }
        }
        return dArray;
    }

    public String toString() {
        return this.toString("%.4f");
    }

    public String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer(String.format("ComplexMatrix3D: %d slices, %d rows, %d columns\n\n", this.slices, this.rows, this.columns));
        double[] dArray = new double[2];
        for (int i = 0; i < this.slices; ++i) {
            stringBuffer.append(String.format("(:,:,%d)=\n", i));
            for (int j = 0; j < this.rows; ++j) {
                for (int k = 0; k < this.columns; ++k) {
                    dArray = this.getQuick(i, j, k);
                    if (dArray[1] == 0.0) {
                        stringBuffer.append(String.format(string + "\t", dArray[0]));
                        continue;
                    }
                    if (dArray[0] == 0.0) {
                        stringBuffer.append(String.format(string + "i\t", dArray[1]));
                        continue;
                    }
                    if (dArray[1] < 0.0) {
                        stringBuffer.append(String.format(string + " - " + string + "i\t", dArray[0], -dArray[1]));
                        continue;
                    }
                    stringBuffer.append(String.format(string + " + " + string + "i\t", dArray[0], dArray[1]));
                }
                stringBuffer.append("\n");
            }
        }
        return stringBuffer.toString();
    }

    public abstract DComplexMatrix1D vectorize();

    public DComplexMatrix2D viewColumn(int n) {
        this.checkColumn(n);
        int n2 = this.slices;
        int n3 = this.rows;
        int n4 = this.sliceZero;
        int n5 = this.rowZero + this._columnOffset(this._columnRank(n));
        int n6 = this.sliceStride;
        int n7 = this.rowStride;
        return this.like2D(n2, n3, n4, n5, n6, n7);
    }

    public DComplexMatrix3D viewColumnFlip() {
        return (DComplexMatrix3D)this.view().vColumnFlip();
    }

    public DComplexMatrix3D viewDice(int n, int n2, int n3) {
        return (DComplexMatrix3D)this.view().vDice(n, n2, n3);
    }

    public DComplexMatrix3D viewPart(int n, int n2, int n3, int n4, int n5, int n6) {
        return (DComplexMatrix3D)this.view().vPart(n, n2, n3, n4, n5, n6);
    }

    public DComplexMatrix2D viewRow(int n) {
        this.checkRow(n);
        int n2 = this.slices;
        int n3 = this.columns;
        int n4 = this.sliceZero;
        int n5 = this.columnZero + this._rowOffset(this._rowRank(n));
        int n6 = this.sliceStride;
        int n7 = this.columnStride;
        return this.like2D(n2, n3, n4, n5, n6, n7);
    }

    public DComplexMatrix3D viewRowFlip() {
        return (DComplexMatrix3D)this.view().vRowFlip();
    }

    public DComplexMatrix3D viewSelection(DComplexMatrix2DProcedure dComplexMatrix2DProcedure) {
        IntArrayList intArrayList = new IntArrayList();
        for (int i = 0; i < this.slices; ++i) {
            if (!dComplexMatrix2DProcedure.apply(this.viewSlice(i))) continue;
            intArrayList.add(i);
        }
        intArrayList.trimToSize();
        return this.viewSelection(intArrayList.elements(), null, null);
    }

    public DComplexMatrix3D viewSelection(int[] nArray, int[] nArray2, int[] nArray3) {
        int n;
        int n2;
        if (nArray == null) {
            nArray = new int[this.slices];
            n2 = this.slices;
            while (--n2 >= 0) {
                nArray[n2] = n2;
            }
        }
        if (nArray2 == null) {
            nArray2 = new int[this.rows];
            n2 = this.rows;
            while (--n2 >= 0) {
                nArray2[n2] = n2;
            }
        }
        if (nArray3 == null) {
            nArray3 = new int[this.columns];
            n2 = this.columns;
            while (--n2 >= 0) {
                nArray3[n2] = n2;
            }
        }
        this.checkSliceIndexes(nArray);
        this.checkRowIndexes(nArray2);
        this.checkColumnIndexes(nArray3);
        int[] nArray4 = new int[nArray.length];
        int[] nArray5 = new int[nArray2.length];
        int[] nArray6 = new int[nArray3.length];
        for (n = 0; n < nArray.length; ++n) {
            nArray4[n] = this._sliceOffset(this._sliceRank(nArray[n]));
        }
        for (n = 0; n < nArray2.length; ++n) {
            nArray5[n] = this._rowOffset(this._rowRank(nArray2[n]));
        }
        for (n = 0; n < nArray3.length; ++n) {
            nArray6[n] = this._columnOffset(this._columnRank(nArray3[n]));
        }
        return this.viewSelectionLike(nArray4, nArray5, nArray6);
    }

    public DComplexMatrix2D viewSlice(int n) {
        this.checkSlice(n);
        int n2 = this.rows;
        int n3 = this.columns;
        int n4 = this.rowZero;
        int n5 = this.columnZero + this._sliceOffset(this._sliceRank(n));
        int n6 = this.rowStride;
        int n7 = this.columnStride;
        return this.like2D(n2, n3, n4, n5, n6, n7);
    }

    public DComplexMatrix3D viewSliceFlip() {
        return (DComplexMatrix3D)this.view().vSliceFlip();
    }

    public DComplexMatrix3D viewStrides(int n, int n2, int n3) {
        return (DComplexMatrix3D)this.view().vStrides(n, n2, n3);
    }

    public double[] zSum() {
        if (this.size() == 0L) {
            return new double[2];
        }
        return this.aggregate(DComplexFunctions.plus, DComplexFunctions.identity);
    }

    protected DComplexMatrix3D getContent() {
        return this;
    }

    protected boolean haveSharedCells(DComplexMatrix3D dComplexMatrix3D) {
        if (dComplexMatrix3D == null) {
            return false;
        }
        if (this == dComplexMatrix3D) {
            return true;
        }
        return this.getContent().haveSharedCellsRaw(dComplexMatrix3D.getContent());
    }

    protected boolean haveSharedCellsRaw(DComplexMatrix3D dComplexMatrix3D) {
        return false;
    }

    protected abstract DComplexMatrix2D like2D(int var1, int var2, int var3, int var4, int var5, int var6);

    protected DComplexMatrix3D view() {
        return (DComplexMatrix3D)this.clone();
    }

    protected abstract DComplexMatrix3D viewSelectionLike(int[] var1, int[] var2, int[] var3);

    public abstract DComplexMatrix2D like2D(int var1, int var2);
}

