## ----setup-db, include=FALSE--------------------------------------------------
knitr::opts_chunk$set(collapse = TRUE, comment = "#>", message = FALSE, warning = FALSE)

## ----db-all, echo=TRUE, message=FALSE, warning=FALSE--------------------------
ok <- TRUE; msg <- NULL
out <- tryCatch({
  if (!requireNamespace("DBI", quietly = TRUE) ||
      !requireNamespace("RSQLite", quietly = TRUE)) {
    stop("DBI/RSQLite not installed")
  }
  library(DBI); library(RSQLite); library(FakeDataR)

  dbfile <- file.path(tempdir(), "employees.sqlite")
  con <- DBI::dbConnect(RSQLite::SQLite(), dbfile)
  on.exit(try(DBI::dbDisconnect(con), silent = TRUE), add = TRUE)

  DBI::dbExecute(con, "
    CREATE TABLE IF NOT EXISTS employees (
      id INTEGER,
      email TEXT,
      phone TEXT,
      is_active BOOLEAN,
      hired_at TIMESTAMP,
      salary NUMERIC,
      dept TEXT
    )
  ")

  sch  <- schema_from_db(con, "employees")
  fake <- generate_fake_from_schema(sch, n = 20, seed = 14)  # smaller

  b2 <- llm_bundle_from_db(
    conn = con, table = "employees",
    n = 40, seed = 15, level = "high",
    formats = "csv", path = tempdir(), filename = "employees_fake",
    write_prompt = TRUE, sensitive_strategy = "fake"
  )

  list(sch = sch, fake = fake, bundle = b2)
}, error = function(e) { ok <<- FALSE; msg <<- conditionMessage(e); NULL })

if (!ok) {
  cat("DB example skipped during vignette build:", msg, "\n")
} else {
  str(out$fake$hired_at)
  out$bundle$schema_path
  out$bundle$data_paths$csv
}


