/*
 * Decompiled with CFR 0.152.
 */
package moa.gui.experimentertab;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;

public class ImageChart {
    private String name;
    private JFreeChart chart;
    private int width;
    private int height;

    public ImageChart() {
    }

    public ImageChart(String name, JFreeChart chart, int width, int height) {
        this.name = name;
        this.chart = chart;
        this.width = width;
        this.height = height;
    }

    public ImageChart(String name, JFreeChart chart) {
        this.name = name;
        this.chart = chart;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setChart(JFreeChart chart) {
        this.chart = chart;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public JFreeChart getChart() {
        return this.chart;
    }

    public String getName() {
        return this.name;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public String toString() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportIMG(String path, String type) throws IOException {
        switch (type) {
            case "JPG": {
                try {
                    ChartUtilities.saveChartAsJPEG((File)new File(path + File.separator + this.name + ".jpg"), (JFreeChart)this.chart, (int)this.width, (int)this.height);
                }
                catch (IOException iOException) {}
                break;
            }
            case "PNG": {
                try {
                    ChartUtilities.saveChartAsPNG((File)new File(path + File.separator + this.name + ".png"), (JFreeChart)this.chart, (int)this.width, (int)this.height);
                }
                catch (IOException iOException) {}
                break;
            }
            case "SVG": {
                String svg = this.generateSVG(this.width, this.height);
                BufferedWriter writer = null;
                try {
                    writer = new BufferedWriter(new FileWriter(new File(path + File.separator + this.name + ".svg")));
                    writer.write("<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1//EN\" \"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\">\n");
                    writer.write(svg + "\n");
                    writer.flush();
                }
                catch (Throwable throwable) {
                    try {
                        if (writer != null) {
                            writer.close();
                        }
                    }
                    catch (IOException ex) {
                        throw new RuntimeException(ex);
                    }
                    throw throwable;
                }
                try {
                    if (writer == null) break;
                    writer.close();
                    break;
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
    }

    private String generateSVG(int width, int height) {
        Graphics2D g2 = this.createSVGGraphics2D(width, height);
        if (g2 == null) {
            throw new IllegalStateException("JFreeSVG library is not present.");
        }
        g2.setRenderingHint(JFreeChart.KEY_SUPPRESS_SHADOW_GENERATION, true);
        String svg = null;
        Rectangle2D.Double drawArea = new Rectangle2D.Double(0.0, 0.0, width, height);
        this.chart.draw(g2, (Rectangle2D)drawArea);
        try {
            Method m = g2.getClass().getMethod("getSVGElement", new Class[0]);
            svg = (String)m.invoke((Object)g2, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            // empty catch block
        }
        return svg;
    }

    private Graphics2D createSVGGraphics2D(int w, int h) {
        try {
            Class<?> svgGraphics2d = Class.forName("org.jfree.graphics2d.svg.SVGGraphics2D");
            Constructor<?> ctor = svgGraphics2d.getConstructor(Integer.TYPE, Integer.TYPE);
            return (Graphics2D)ctor.newInstance(w, h);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            return null;
        }
    }
}

