/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.expression.continuous.arithmetic;

import java.util.List;
import java.util.TreeSet;
import org.chocosolver.memory.IStateDouble;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.expression.continuous.arithmetic.CArExpression;
import org.chocosolver.solver.expression.continuous.arithmetic.RealIntervalConstant;
import org.chocosolver.solver.variables.RealVar;
import org.chocosolver.util.objects.RealInterval;
import org.chocosolver.util.tools.RealUtils;
import org.chocosolver.util.tools.VariableUtils;

public class BiCArExpression
implements CArExpression {
    Model model;
    RealVar me = null;
    CArExpression.Operator op;
    private final CArExpression e1;
    private final CArExpression e2;
    IStateDouble l;
    IStateDouble u;

    public BiCArExpression(CArExpression.Operator op, CArExpression e1, CArExpression e2) {
        this.op = op;
        this.e1 = e1;
        this.e2 = e2;
        this.model = e1.getModel();
    }

    @Override
    public Model getModel() {
        return this.model;
    }

    @Override
    public RealVar realVar(double p) {
        if (this.me == null) {
            RealVar v1 = this.e1.realVar(p);
            RealVar v2 = this.e2.realVar(p);
            switch (this.op) {
                case ADD: {
                    double[] bounds = VariableUtils.boundsForAddition(v1, v2);
                    this.me = this.model.realVar(bounds[0], bounds[1], p);
                    this.model.realIbexGenericConstraint("{0}={1}+{2}", this.me, v1, v2).post();
                    break;
                }
                case SUB: {
                    double[] bounds = VariableUtils.boundsForSubstraction(v1, v2);
                    this.me = this.model.realVar(bounds[0], bounds[1], p);
                    this.model.realIbexGenericConstraint("{0}={1}-{2}", this.me, v1, v2).post();
                    break;
                }
                case MUL: {
                    double[] bounds = VariableUtils.boundsForMultiplication(v1, v2);
                    this.me = this.model.realVar(bounds[0], bounds[1], p);
                    this.model.realIbexGenericConstraint("{0}={1}*{2}", this.me, v1, v2).post();
                    break;
                }
                case DIV: {
                    double[] bounds = VariableUtils.boundsForDivision(v1, v2);
                    this.me = this.model.realVar(bounds[0], bounds[1], p);
                    this.model.realIbexGenericConstraint("{0}={1}/{2}", this.me, v1, v2).post();
                    break;
                }
                case POW: {
                    if (this.isIntegerConstant(v2)) {
                        int exponent = (int)v2.getLB();
                        double[] bounds = VariableUtils.boundsForPow(v1, exponent);
                        this.me = this.model.realVar(bounds[0], bounds[1], p);
                        this.model.realIbexGenericConstraint("{0}={1}^" + exponent, this.me, v1).post();
                        break;
                    }
                    double[] bounds = VariableUtils.boundsForPow(v1, v2);
                    this.me = this.model.realVar(bounds[0], bounds[1], p);
                    this.model.realIbexGenericConstraint("{0}={1}^{2}", this.me, v1, v2).post();
                    break;
                }
                case MIN: {
                    double[] bounds = VariableUtils.boundsForMinimum(v1, v2);
                    this.me = this.model.realVar(bounds[0], bounds[1], p);
                    this.model.realIbexGenericConstraint("{0}=min({1},{2})", this.me, v1, v2).post();
                    break;
                }
                case MAX: {
                    double[] bounds = VariableUtils.boundsForMaximum(v1, v2);
                    this.me = this.model.realVar(bounds[0], bounds[1], p);
                    this.model.realIbexGenericConstraint("{0}=max({1},{2})", this.me, v1, v2).post();
                    break;
                }
                case ATAN2: {
                    double[] bounds = VariableUtils.boundsForAtan2(v1, v2);
                    this.me = this.model.realVar(bounds[0], bounds[1], p);
                    this.model.realIbexGenericConstraint("{0}=atan2({1},{2})", this.me, v1, v2).post();
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Binary arithmetic expressions does not support " + this.op.name());
                }
            }
        }
        return this.me;
    }

    @Override
    public void tighten() {
        RealInterval res;
        switch (this.op) {
            case ADD: {
                res = RealUtils.add(this.e1, this.e2);
                break;
            }
            case SUB: {
                res = RealUtils.sub(this.e1, this.e2);
                break;
            }
            case MUL: {
                res = RealUtils.mul(this.e1, this.e2);
                break;
            }
            case DIV: {
                res = RealUtils.odiv(this.e1, this.e2);
                break;
            }
            case MIN: {
                res = new RealIntervalConstant(Math.min(this.e1.getLB(), this.e2.getLB()), Math.min(this.e1.getUB(), this.e2.getUB()));
                break;
            }
            case MAX: {
                res = new RealIntervalConstant(Math.max(this.e1.getLB(), this.e2.getLB()), Math.max(this.e1.getUB(), this.e2.getUB()));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Equation does not support " + this.op.name() + ". Consider using Ibex instead.");
            }
        }
        this.l.set(res.getLB());
        this.u.set(res.getUB());
    }

    @Override
    public void project(ICause cause) throws ContradictionException {
        switch (this.op) {
            case ADD: {
                this.e1.intersect(RealUtils.sub(this, this.e2), cause);
                this.e2.intersect(RealUtils.sub(this, this.e1), cause);
                break;
            }
            case SUB: {
                this.e1.intersect(RealUtils.add(this, this.e2), cause);
                this.e2.intersect(RealUtils.sub(this.e1, this), cause);
                break;
            }
            case MUL: {
                this.e1.intersect(RealUtils.odiv_wrt(this, this.e2, this.e1), cause);
                this.e2.intersect(RealUtils.odiv_wrt(this, this.e1, this.e2), cause);
                break;
            }
            case DIV: {
                this.e1.intersect(RealUtils.mul(this, this.e2), cause);
                this.e2.intersect(RealUtils.odiv_wrt(this.e1, this, this.e2), cause);
                break;
            }
            case MIN: {
                this.e1.intersect(this.getLB(), RealUtils.nextFloat(this.e1.getUB()), cause);
                this.e2.intersect(this.getLB(), RealUtils.nextFloat(this.e2.getUB()), cause);
                if (this.e2.getLB() > this.getUB()) {
                    this.e1.intersect(RealUtils.prevFloat(this.e1.getLB()), this.getUB(), cause);
                }
                if (!(this.e1.getLB() > this.getUB())) break;
                this.e2.intersect(RealUtils.prevFloat(this.e2.getLB()), this.getUB(), cause);
                break;
            }
            case MAX: {
                this.e1.intersect(RealUtils.prevFloat(this.e1.getLB()), this.getUB(), cause);
                this.e2.intersect(RealUtils.prevFloat(this.e2.getLB()), this.getUB(), cause);
                if (this.e2.getUB() < this.getLB()) {
                    this.e1.intersect(this.getLB(), RealUtils.nextFloat(this.e1.getUB()), cause);
                }
                if (!(this.e1.getUB() < this.getLB())) break;
                this.e2.intersect(this.getLB(), RealUtils.nextFloat(this.e2.getUB()), cause);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Equation does not support " + this.op.name() + ". Consider using Ibex instead.");
            }
        }
    }

    @Override
    public void collectVariables(TreeSet<RealVar> set) {
        this.e1.collectVariables(set);
        this.e2.collectVariables(set);
    }

    @Override
    public void subExps(List<CArExpression> list) {
        this.e1.subExps(list);
        this.e2.subExps(list);
        list.add(this);
    }

    @Override
    public boolean isolate(RealVar var, List<CArExpression> wx, List<CArExpression> wox) {
        boolean dependsOnX = this.e1.isolate(var, wx, wox) | this.e2.isolate(var, wx, wox);
        if (dependsOnX) {
            wx.add(this);
        } else {
            wox.add(this);
        }
        return dependsOnX;
    }

    @Override
    public void init() {
        if (this.l == null && this.u == null) {
            this.l = this.model.getEnvironment().makeFloat(Double.NEGATIVE_INFINITY);
            this.u = this.model.getEnvironment().makeFloat(Double.POSITIVE_INFINITY);
        }
        this.e1.init();
        this.e2.init();
    }

    @Override
    public double getLB() {
        return this.l.get();
    }

    @Override
    public double getUB() {
        return this.u.get();
    }

    @Override
    public void intersect(double lb, double ub, ICause cause) throws ContradictionException {
        if (lb > this.getLB()) {
            this.l.set(lb);
        }
        if (ub < this.getUB()) {
            this.u.set(ub);
        }
        if (this.getLB() > this.getUB()) {
            this.model.getSolver().throwsException(cause, null, "");
        }
    }

    public String toString() {
        return this.op.name() + "(" + this.e1.toString() + "," + this.e2.toString() + ")";
    }

    private boolean isIntegerConstant(RealVar realVar) {
        return realVar.isAConstant() && Math.rint(realVar.getLB()) == realVar.getLB();
    }
}

