library(ggplot2)
library(gridExtra)
library(colourpicker)
library(shiny)
library(shinythemes)
library(emojifont)
library(shiny)
library(rintrojs)

#Choice list
choices <- c("envira"="fa-envira",
             "none" = "none",
             "adjust"="fa-adjust",
             "adn"="fa-adn",
             "align-center"="fa-align-center",
             "align-justify"="fa-align-justify",
             "align-left"="fa-align-left",
             "align-right"="fa-align-right",
             "ambulance"="fa-ambulance",
             "anchor"="fa-anchor",
             "android"="fa-android",
             "angellist"="fa-angellist",
             "angle-double-down"="fa-angle-double-down",
             "angle-double-left"="fa-angle-double-left",
             "angle-double-right"="fa-angle-double-right",
             "angle-double-up"="fa-angle-double-up",
             "angle-down"="fa-angle-down",
             "angle-left"="fa-angle-left",
             "angle-right"="fa-angle-right",
             "angle-up"="fa-angle-up",
             "apple"="fa-apple",
             "archive"="fa-archive",
             "area-chart"="fa-area-chart",
             "arrow-circle-down"="fa-arrow-circle-down",
             "arrow-circle-left"="fa-arrow-circle-left",
             "arrow-circle-o-down"="fa-arrow-circle-o-down",
             "arrow-circle-o-left"="fa-arrow-circle-o-left",
             "arrow-circle-o-right"="fa-arrow-circle-o-right",
             "arrow-circle-o-up"="fa-arrow-circle-o-up",
             "arrow-circle-right"="fa-arrow-circle-right",
             "arrow-circle-up"="fa-arrow-circle-up",
             "arrow-down"="fa-arrow-down",
             "arrow-left"="fa-arrow-left",
             "arrow-right"="fa-arrow-right",
             "arrows"="fa-arrows",
             "arrows-alt"="fa-arrows-alt",
             "arrows-h"="fa-arrows-h",
             "arrows-v"="fa-arrows-v",
             "arrow-up"="fa-arrow-up",
             "asterisk"="fa-asterisk",
             "at"="fa-at",
             "automobile"="fa-automobile",
             "backward"="fa-backward",
             "ban"="fa-ban",
             "bank"="fa-bank",
             "bar-chart"="fa-bar-chart",
             "bar-chart-o"="fa-bar-chart-o",
             "barcode"="fa-barcode",
             "bars"="fa-bars",
             "bed"="fa-bed",
             "beer"="fa-beer",
             "behance"="fa-behance",
             "behance-square"="fa-behance-square",
             "bell"="fa-bell",
             "bell-o"="fa-bell-o",
             "bell-slash"="fa-bell-slash",
             "bell-slash-o"="fa-bell-slash-o",
             "bicycle"="fa-bicycle",
             "binoculars"="fa-binoculars",
             "birthday-cake"="fa-birthday-cake",
             "bitbucket"="fa-bitbucket",
             "bitbucket-square"="fa-bitbucket-square",
             "bitcoin"="fa-bitcoin",
             "bold"="fa-bold",
             "bolt"="fa-bolt",
             "bomb"="fa-bomb",
             "book"="fa-book",
             "bookmark"="fa-bookmark",
             "bookmark-o"="fa-bookmark-o",
             "briefcase"="fa-briefcase",
             "btc"="fa-btc",
             "bug"="fa-bug",
             "building"="fa-building",
             "building-o"="fa-building-o",
             "bullhorn"="fa-bullhorn",
             "bullseye"="fa-bullseye",
             "bus"="fa-bus",
             "buysellads"="fa-buysellads",
             "cab"="fa-cab",
             "calculator"="fa-calculator",
             "calendar"="fa-calendar",
             "calendar-o"="fa-calendar-o",
             "camera"="fa-camera",
             "camera-retro"="fa-camera-retro",
             "car"="fa-car",
             "caret-down"="fa-caret-down",
             "caret-left"="fa-caret-left",
             "caret-right"="fa-caret-right",
             "caret-square-o-down"="fa-caret-square-o-down",
             "caret-square-o-left"="fa-caret-square-o-left",
             "caret-square-o-right"="fa-caret-square-o-right",
             "caret-square-o-up"="fa-caret-square-o-up",
             "caret-up"="fa-caret-up",
             "cart-arrow-down"="fa-cart-arrow-down",
             "cart-plus"="fa-cart-plus",
             "cc"="fa-cc",
             "cc-amex"="fa-cc-amex",
             "cc-discover"="fa-cc-discover",
             "cc-mastercard"="fa-cc-mastercard",
             "cc-paypal"="fa-cc-paypal",
             "cc-stripe"="fa-cc-stripe",
             "cc-visa"="fa-cc-visa",
             "certificate"="fa-certificate",
             "chain"="fa-chain",
             "chain-broken"="fa-chain-broken",
             "check"="fa-check",
             "check-circle"="fa-check-circle",
             "check-circle-o"="fa-check-circle-o",
             "check-square"="fa-check-square",
             "check-square-o"="fa-check-square-o",
             "chevron-circle-down"="fa-chevron-circle-down",
             "chevron-circle-left"="fa-chevron-circle-left",
             "chevron-circle-right"="fa-chevron-circle-right",
             "chevron-circle-up"="fa-chevron-circle-up",
             "chevron-down"="fa-chevron-down",
             "chevron-left"="fa-chevron-left",
             "chevron-right"="fa-chevron-right",
             "chevron-up"="fa-chevron-up",
             "child"="fa-child",
             "circle"="fa-circle",
             "circle-o"="fa-circle-o",
             "circle-o-notch"="fa-circle-o-notch",
             "circle-thin"="fa-circle-thin",
             "clipboard"="fa-clipboard",
             "clock-o"="fa-clock-o",
             "close"="fa-close",
             "cloud"="fa-cloud",
             "cloud-download"="fa-cloud-download",
             "cloud-upload"="fa-cloud-upload",
             "cny"="fa-cny",
             "code"="fa-code",
             "code-fork"="fa-code-fork",
             "codepen"="fa-codepen",
             "coffee"="fa-coffee",
             "cog"="fa-cog",
             "cogs"="fa-cogs",
             "columns"="fa-columns",
             "comment"="fa-comment",
             "comment-o"="fa-comment-o",
             "comments"="fa-comments",
             "comments-o"="fa-comments-o",
             "compass"="fa-compass",
             "compress"="fa-compress",
             "connectdevelop"="fa-connectdevelop",
             "copy"="fa-copy",
             "copyright"="fa-copyright",
             "credit-card"="fa-credit-card",
             "crop"="fa-crop",
             "crosshairs"="fa-crosshairs",
             "css3"="fa-css3",
             "cube"="fa-cube",
             "cubes"="fa-cubes",
             "cut"="fa-cut",
             "cutlery"="fa-cutlery",
             "dashboard"="fa-dashboard",
             "dashcube"="fa-dashcube",
             "database"="fa-database",
             "dedent"="fa-dedent",
             "delicious"="fa-delicious",
             "desktop"="fa-desktop",
             "deviantart"="fa-deviantart",
             "diamond"="fa-diamond",
             "digg"="fa-digg",
             "dollar"="fa-dollar",
             "dot-circle-o"="fa-dot-circle-o",
             "download"="fa-download",
             "dribbble"="fa-dribbble",
             "dropbox"="fa-dropbox",
             "drupal"="fa-drupal",
             "edit"="fa-edit",
             "eject"="fa-eject",
             "ellipsis-h"="fa-ellipsis-h",
             "ellipsis-v"="fa-ellipsis-v",
             "empire"="fa-empire",
             "envelope"="fa-envelope",
             "envelope-o"="fa-envelope-o",
             "envelope-square"="fa-envelope-square",
             "eraser"="fa-eraser",
             "eur"="fa-eur",
             "euro"="fa-euro",
             "exchange"="fa-exchange",
             "exclamation"="fa-exclamation",
             "exclamation-circle"="fa-exclamation-circle",
             "exclamation-triangle"="fa-exclamation-triangle",
             "expand"="fa-expand",
             "external-link"="fa-external-link",
             "external-link-square"="fa-external-link-square",
             "eye"="fa-eye",
             "eyedropper"="fa-eyedropper",
             "eye-slash"="fa-eye-slash",
             "facebook"="fa-facebook",
             "facebook-f"="fa-facebook-f",
             "facebook-official"="fa-facebook-official",
             "facebook-square"="fa-facebook-square",
             "fast-backward"="fa-fast-backward",
             "fast-forward"="fa-fast-forward",
             "fax"="fa-fax",
             "female"="fa-female",
             "fighter-jet"="fa-fighter-jet",
             "file"="fa-file",
             "file-archive-o"="fa-file-archive-o",
             "file-audio-o"="fa-file-audio-o",
             "file-code-o"="fa-file-code-o",
             "file-excel-o"="fa-file-excel-o",
             "file-image-o"="fa-file-image-o",
             "file-movie-o"="fa-file-movie-o",
             "file-o"="fa-file-o",
             "file-pdf-o"="fa-file-pdf-o",
             "file-photo-o"="fa-file-photo-o",
             "file-picture-o"="fa-file-picture-o",
             "file-powerpoint-o"="fa-file-powerpoint-o",
             "files-o"="fa-files-o",
             "file-sound-o"="fa-file-sound-o",
             "file-text"="fa-file-text",
             "file-text-o"="fa-file-text-o",
             "file-video-o"="fa-file-video-o",
             "file-word-o"="fa-file-word-o",
             "file-zip-o"="fa-file-zip-o",
             "film"="fa-film",
             "filter"="fa-filter",
             "fire"="fa-fire",
             "fire-extinguisher"="fa-fire-extinguisher",
             "flag"="fa-flag",
             "flag-checkered"="fa-flag-checkered",
             "flag-o"="fa-flag-o",
             "flash"="fa-flash",
             "flask"="fa-flask",
             "flickr"="fa-flickr",
             "floppy-o"="fa-floppy-o",
             "folder"="fa-folder",
             "folder-o"="fa-folder-o",
             "folder-open"="fa-folder-open",
             "folder-open-o"="fa-folder-open-o",
             "font"="fa-font",
             "forumbee"="fa-forumbee",
             "forward"="fa-forward",
             "foursquare"="fa-foursquare",
             "frown-o"="fa-frown-o",
             "futbol-o"="fa-futbol-o",
             "gamepad"="fa-gamepad",
             "gavel"="fa-gavel",
             "gbp"="fa-gbp",
             "ge"="fa-ge",
             "gear"="fa-gear",
             "gears"="fa-gears",
             "genderless"="fa-genderless",
             "gift"="fa-gift",
             "git"="fa-git",
             "github"="fa-github",
             "github-alt"="fa-github-alt",
             "github-square"="fa-github-square",
             "git-square"="fa-git-square",
             "gittip"="fa-gittip",
             "glass"="fa-glass",
             "globe"="fa-globe",
             "google"="fa-google",
             "google-plus"="fa-google-plus",
             "google-plus-square"="fa-google-plus-square",
             "google-wallet"="fa-google-wallet",
             "graduation-cap"="fa-graduation-cap",
             "gratipay"="fa-gratipay",
             "group"="fa-group",
             "hacker-news"="fa-hacker-news",
             "hand-o-down"="fa-hand-o-down",
             "hand-o-left"="fa-hand-o-left",
             "hand-o-right"="fa-hand-o-right",
             "hand-o-up"="fa-hand-o-up",
             "hdd-o"="fa-hdd-o",
             "header"="fa-header",
             "headphones"="fa-headphones",
             "heart"="fa-heart",
             "heartbeat"="fa-heartbeat",
             "heart-o"="fa-heart-o",
             "history"="fa-history",
             "home"="fa-home",
             "hospital-o"="fa-hospital-o",
             "hotel"="fa-hotel",
             "h-square"="fa-h-square",
             "html5"="fa-html5",
             "ils"="fa-ils",
             "image"="fa-image",
             "inbox"="fa-inbox",
             "indent"="fa-indent",
             "info"="fa-info",
             "info-circle"="fa-info-circle",
             "inr"="fa-inr",
             "instagram"="fa-instagram",
             "institution"="fa-institution",
             "ioxhost"="fa-ioxhost",
             "italic"="fa-italic",
             "joomla"="fa-joomla",
             "jpy"="fa-jpy",
             "jsfiddle"="fa-jsfiddle",
             "key"="fa-key",
             "keyboard-o"="fa-keyboard-o",
             "krw"="fa-krw",
             "language"="fa-language",
             "laptop"="fa-laptop",
             "lastfm"="fa-lastfm",
             "lastfm-square"="fa-lastfm-square",
             "leaf"="fa-leaf",
             "leanpub"="fa-leanpub",
             "legal"="fa-legal",
             "lemon-o"="fa-lemon-o",
             "level-down"="fa-level-down",
             "level-up"="fa-level-up",
             "life-bouy"="fa-life-bouy",
             "life-buoy"="fa-life-buoy",
             "life-ring"="fa-life-ring",
             "life-saver"="fa-life-saver",
             "lightbulb-o"="fa-lightbulb-o",
             "line-chart"="fa-line-chart",
             "link"="fa-link",
             "linkedin"="fa-linkedin",
             "linkedin-square"="fa-linkedin-square",
             "linux"="fa-linux",
             "list"="fa-list",
             "list-alt"="fa-list-alt",
             "list-ol"="fa-list-ol",
             "list-ul"="fa-list-ul",
             "location-arrow"="fa-location-arrow",
             "lock"="fa-lock",
             "long-arrow-down"="fa-long-arrow-down",
             "long-arrow-left"="fa-long-arrow-left",
             "long-arrow-right"="fa-long-arrow-right",
             "long-arrow-up"="fa-long-arrow-up",
             "magic"="fa-magic",
             "magnet"="fa-magnet",
             "mail-forward"="fa-mail-forward",
             "mail-reply"="fa-mail-reply",
             "mail-reply-all"="fa-mail-reply-all",
             "male"="fa-male",
             "map-marker"="fa-map-marker",
             "mars"="fa-mars",
             "mars-double"="fa-mars-double",
             "mars-stroke"="fa-mars-stroke",
             "mars-stroke-h"="fa-mars-stroke-h",
             "mars-stroke-v"="fa-mars-stroke-v",
             "maxcdn"="fa-maxcdn",
             "meanpath"="fa-meanpath",
             "medium"="fa-medium",
             "medkit"="fa-medkit",
             "meh-o"="fa-meh-o",
             "mercury"="fa-mercury",
             "microphone"="fa-microphone",
             "microphone-slash"="fa-microphone-slash",
             "minus"="fa-minus",
             "minus-circle"="fa-minus-circle",
             "minus-square"="fa-minus-square",
             "minus-square-o"="fa-minus-square-o",
             "mobile"="fa-mobile",
             "mobile-phone"="fa-mobile-phone",
             "money"="fa-money",
             "moon-o"="fa-moon-o",
             "mortar-board"="fa-mortar-board",
             "motorcycle"="fa-motorcycle",
             "music"="fa-music",
             "navicon"="fa-navicon",
             "neuter"="fa-neuter",
             "newspaper-o"="fa-newspaper-o",
             "openid"="fa-openid",
             "outdent"="fa-outdent",
             "pagelines"="fa-pagelines",
             "paint-brush"="fa-paint-brush",
             "paperclip"="fa-paperclip",
             "paper-plane"="fa-paper-plane",
             "paper-plane-o"="fa-paper-plane-o",
             "paragraph"="fa-paragraph",
             "paste"="fa-paste",
             "pause"="fa-pause",
             "paw"="fa-paw",
             "paypal"="fa-paypal",
             "pencil"="fa-pencil",
             "pencil-square"="fa-pencil-square",
             "pencil-square-o"="fa-pencil-square-o",
             "phone"="fa-phone",
             "phone-square"="fa-phone-square",
             "photo"="fa-photo",
             "picture-o"="fa-picture-o",
             "pie-chart"="fa-pie-chart",
             "pied-piper"="fa-pied-piper",
             "pied-piper-alt"="fa-pied-piper-alt",
             "pinterest"="fa-pinterest",
             "pinterest-p"="fa-pinterest-p",
             "pinterest-square"="fa-pinterest-square",
             "plane"="fa-plane",
             "play"="fa-play",
             "play-circle"="fa-play-circle",
             "play-circle-o"="fa-play-circle-o",
             "plug"="fa-plug",
             "plus"="fa-plus",
             "plus-circle"="fa-plus-circle",
             "plus-square"="fa-plus-square",
             "plus-square-o"="fa-plus-square-o",
             "power-off"="fa-power-off",
             "print"="fa-print",
             "puzzle-piece"="fa-puzzle-piece",
             "qq"="fa-qq",
             "qrcode"="fa-qrcode",
             "question"="fa-question",
             "question-circle"="fa-question-circle",
             "quote-left"="fa-quote-left",
             "quote-right"="fa-quote-right",
             "ra"="fa-ra",
             "random"="fa-random",
             "rebel"="fa-rebel",
             "recycle"="fa-recycle",
             "reddit"="fa-reddit",
             "reddit-square"="fa-reddit-square",
             "refresh"="fa-refresh",
             "remove"="fa-remove",
             "renren"="fa-renren",
             "reorder"="fa-reorder",
             "repeat"="fa-repeat",
             "reply"="fa-reply",
             "reply-all"="fa-reply-all",
             "retweet"="fa-retweet",
             "rmb"="fa-rmb",
             "road"="fa-road",
             "rocket"="fa-rocket",
             "rotate-left"="fa-rotate-left",
             "rotate-right"="fa-rotate-right",
             "rouble"="fa-rouble",
             "rss"="fa-rss",
             "rss-square"="fa-rss-square",
             "rub"="fa-rub",
             "ruble"="fa-ruble",
             "rupee"="fa-rupee",
             "save"="fa-save",
             "scissors"="fa-scissors",
             "search"="fa-search",
             "search-minus"="fa-search-minus",
             "search-plus"="fa-search-plus",
             "sellsy"="fa-sellsy",
             "send"="fa-send",
             "send-o"="fa-send-o",
             "server"="fa-server",
             "share"="fa-share",
             "share-alt"="fa-share-alt",
             "share-alt-square"="fa-share-alt-square",
             "share-square"="fa-share-square",
             "share-square-o"="fa-share-square-o",
             "shekel"="fa-shekel",
             "sheqel"="fa-sheqel",
             "shield"="fa-shield",
             "ship"="fa-ship",
             "shirtsinbulk"="fa-shirtsinbulk",
             "shopping-cart"="fa-shopping-cart",
             "signal"="fa-signal",
             "sign-in"="fa-sign-in",
             "sign-out"="fa-sign-out",
             "simplybuilt"="fa-simplybuilt",
             "sitemap"="fa-sitemap",
             "skyatlas"="fa-skyatlas",
             "skype"="fa-skype",
             "slack"="fa-slack",
             "sliders"="fa-sliders",
             "slideshare"="fa-slideshare",
             "smile-o"="fa-smile-o",
             "soccer-ball-o"="fa-soccer-ball-o",
             "sort"="fa-sort",
             "sort-alpha-asc"="fa-sort-alpha-asc",
             "sort-alpha-desc"="fa-sort-alpha-desc",
             "sort-amount-asc"="fa-sort-amount-asc",
             "sort-amount-desc"="fa-sort-amount-desc",
             "sort-asc"="fa-sort-asc",
             "sort-desc"="fa-sort-desc",
             "sort-down"="fa-sort-down",
             "sort-numeric-asc"="fa-sort-numeric-asc",
             "sort-numeric-desc"="fa-sort-numeric-desc",
             "sort-up"="fa-sort-up",
             "soundcloud"="fa-soundcloud",
             "space-shuttle"="fa-space-shuttle",
             "spinner"="fa-spinner",
             "spoon"="fa-spoon",
             "spotify"="fa-spotify",
             "square"="fa-square",
             "square-o"="fa-square-o",
             "stack-exchange"="fa-stack-exchange",
             "stack-overflow"="fa-stack-overflow",
             "star"="fa-star",
             "star-half"="fa-star-half",
             "star-half-empty"="fa-star-half-empty",
             "star-half-full"="fa-star-half-full",
             "star-half-o"="fa-star-half-o",
             "star-o"="fa-star-o",
             "steam"="fa-steam",
             "steam-square"="fa-steam-square",
             "step-backward"="fa-step-backward",
             "step-forward"="fa-step-forward",
             "stethoscope"="fa-stethoscope",
             "stop"="fa-stop",
             "street-view"="fa-street-view",
             "strikethrough"="fa-strikethrough",
             "stumbleupon"="fa-stumbleupon",
             "stumbleupon-circle"="fa-stumbleupon-circle",
             "subscript"="fa-subscript",
             "subway"="fa-subway",
             "suitcase"="fa-suitcase",
             "sun-o"="fa-sun-o",
             "superscript"="fa-superscript",
             "support"="fa-support",
             "table"="fa-table",
             "tablet"="fa-tablet",
             "tachometer"="fa-tachometer",
             "tag"="fa-tag",
             "tags"="fa-tags",
             "tasks"="fa-tasks",
             "taxi"="fa-taxi",
             "tencent-weibo"="fa-tencent-weibo",
             "terminal"="fa-terminal",
             "text-height"="fa-text-height",
             "text-width"="fa-text-width",
             "th"="fa-th",
             "th-large"="fa-th-large",
             "th-list"="fa-th-list",
             "thumbs-down"="fa-thumbs-down",
             "thumbs-o-down"="fa-thumbs-o-down",
             "thumbs-o-up"="fa-thumbs-o-up",
             "thumbs-up"="fa-thumbs-up",
             "thumb-tack"="fa-thumb-tack",
             "ticket"="fa-ticket",
             "times"="fa-times",
             "times-circle"="fa-times-circle",
             "times-circle-o"="fa-times-circle-o",
             "tint"="fa-tint",
             "toggle-down"="fa-toggle-down",
             "toggle-left"="fa-toggle-left",
             "toggle-off"="fa-toggle-off",
             "toggle-on"="fa-toggle-on",
             "toggle-right"="fa-toggle-right",
             "toggle-up"="fa-toggle-up",
             "train"="fa-train",
             "transgender"="fa-transgender",
             "transgender-alt"="fa-transgender-alt",
             "trash"="fa-trash",
             "trash-o"="fa-trash-o",
             "tree"="fa-tree",
             "trello"="fa-trello",
             "trophy"="fa-trophy",
             "truck"="fa-truck",
             "try"="fa-try",
             "tty"="fa-tty",
             "tumblr"="fa-tumblr",
             "tumblr-square"="fa-tumblr-square",
             "turkish-lira"="fa-turkish-lira",
             "twitch"="fa-twitch",
             "twitter"="fa-twitter",
             "twitter-square"="fa-twitter-square",
             "umbrella"="fa-umbrella",
             "underline"="fa-underline",
             "undo"="fa-undo",
             "university"="fa-university",
             "unlink"="fa-unlink",
             "unlock"="fa-unlock",
             "unlock-alt"="fa-unlock-alt",
             "unsorted"="fa-unsorted",
             "upload"="fa-upload",
             "usd"="fa-usd",
             "user"="fa-user",
             "user-md"="fa-user-md",
             "user-plus"="fa-user-plus",
             "users"="fa-users",
             "user-secret"="fa-user-secret",
             "user-times"="fa-user-times",
             "venus"="fa-venus",
             "venus-double"="fa-venus-double",
             "venus-mars"="fa-venus-mars",
             "viacoin"="fa-viacoin",
             "video-camera"="fa-video-camera",
             "vimeo-square"="fa-vimeo-square",
             "vine"="fa-vine",
             "vk"="fa-vk",
             "volume-down"="fa-volume-down",
             "volume-off"="fa-volume-off",
             "volume-up"="fa-volume-up",
             "warning"="fa-warning",
             "wechat"="fa-wechat",
             "weibo"="fa-weibo",
             "weixin"="fa-weixin",
             "whatsapp"="fa-whatsapp",
             "wheelchair"="fa-wheelchair",
             "wifi"="fa-wifi",
             "windows"="fa-windows",
             "won"="fa-won",
             "wordpress"="fa-wordpress",
             "wrench"="fa-wrench",
             "xing"="fa-xing",
             "xing-square"="fa-xing-square",
             "yahoo"="fa-yahoo",
             "yelp"="fa-yelp",
             "yen"="fa-yen",
             "youtube"="fa-youtube",
             "youtube-play"="fa-youtube-play",
             "youtube-square"="fa-youtube-square")


#UI
ui = fluidPage(introjsUI(),
               theme = shinytheme("united"),
               headerPanel('Visual AbstractR'),
               sidebarPanel(
                             br(),
                             p("Use this app to build",  tags$a(href="https://www.surgeryredesign.com/resources/", "Visual Abstracts."),"Click the button below to see how it works."),
                             actionButton("tour","Start Tour", class = "btn btn-primary btn-lg"),
                             hr(),
                             introBox(
                                      numericInput("nTabs", 'No. of Panels', 4),
                                      data.step = 1,
                                      data.intro = "Enter the number of panels for your abstract. A set of controls for each panel is automatically generated."
                                     ),
                             introBox(
                                      uiOutput('mytabs'),
                                      data.step = 2,
                                      data.intro = "Use these controls to edit the content and features of each panel."
                                      )
                            ),
                            mainPanel(
                            introBox(
                                  plotOutput("pl",width = "1200px", height = "900px"),
                                  data.step = 3,
                                  data.intro = "You can preview your visual abstract here. When you are finished, simply right click the image and save it to your computer."
                                )
                        )
               )

#Server
server = function(input, output, session){

  #Tour
  observeEvent(input$tour,
               introjs(session, options = list("nextLabel"="Next",
                                               "prevLabel"="Back"
                                               )))

  #Start Tabset
  output$mytabs <- renderUI({
    nTabs = input$nTabs
    colours <- heat.colors(nTabs)
    myTabs = lapply(1:nTabs, function(i) {
      tabPanel(paste0("Panel ",i),
               hr(),
               h3("Panel"),
               fluidRow(column(12,colourInput(paste0("col",i), "Panel colour", colours[i]))),
               hr(),
               h3("Text"),
               #Primary Text
               fluidRow(column(4,textInput(paste0("ptxt",i), "Primary Title", paste("Outcome",i))),
                        column(4,numericInput(paste0("psize",i), "Font Size", 8)),
                        column(4,colourInput(paste0("pcol",i), "Font colour", "black"))),
               #Secondary Text
               fluidRow(column(4,textInput(paste0("stxt",i), "Secondary Title", "...continued...")),
                        column(4,numericInput(paste0("ssize",i), "Font Size", 8)),
                        column(4,colourInput(paste0("scol",i), "Font colour", "black"))),
               #Stat
               fluidRow(column(4,textInput(paste0("sttxt",i), "Statistic", paste("Statistic", i))),
                        column(4,numericInput(paste0("stsize",i), "Font Size", 6)),
                        column(4,colourInput(paste0("stcol",i), "Font colour", "black"))),
               #Unit
               fluidRow(column(4,textInput(paste0("utxt",i), "Unit", paste("Unit",i))),
                        column(4,numericInput(paste0("usize",i), "Font Size", 6)),
                        column(4,colourInput(paste0("ucol",i), "Font colour", "black"))),
               hr(),
               h3("Icons"),
               fluidRow(column(4,selectInput(paste0("icon",i), "Icon ", choices)),
                        column(4,numericInput(paste0("isize",i), "Icon Size", 60)),
                        column(4,colourInput(paste0("icol",i), "Icon colour", "black")))


      )})

    #Border Tab inserted manually
    myTabs[[nTabs + 1]] <-  tabPanel("Borders",
                                     hr(),
                                     colourInput("colmajor", "Select Minor colour", "#407da6"),
                                     colourInput("colminor", "Select Major colour", '#002647'),
                                     textInput("headt", "Header Primary", 'Main Title of the Study'),
                                     textInput("headt2", "Header Secondary", "...continued..."),
                                     textInput("ref", "Study Citation", "Study Citation (year) Journal Name"),
                                     selectInput("logo", "Logo", choices),
                                     colourInput("lcol", "Logo colour", "white"),
                                     numericInput("lsize", "Logo Size", 15))

    do.call(tabsetPanel,myTabs)
  })
  #End Tabset

  output$pl <- renderPlot({
    req(input$col1)
    nTabs = input$nTabs



    #Create sub-graphs
    subs <- list()

      for (i in 1:nTabs) {
      eval(parse(text=paste("subs[[",i,"]] <-

                            ggplot(data=data.frame(x=1:10, y=1:10), aes(x=x, y=y))   +
                            scale_y_continuous(limits=c(1,10), breaks=seq(1,10,0.5)) +
                            scale_x_continuous(limits=c(1,10), breaks=seq(1,10,0.5)) +
                            theme_void() +
                            theme(panel.background = element_rect(fill = ", parse(text=(paste0("input$col",i))),")) +
                            annotate('text',  x=5.5, y = 2.5, label = ", parse(text=(paste0("input$sttxt",i))),",  size= ", parse(text=(paste0("input$stsize",i))),", color = ", parse(text=(paste0("input$stcol",i))), ",  fontface=2) +
                            annotate('text',  x=5.5, y = 1.5, label = ", parse(text=(paste0("input$utxt",i))),",  size= ", parse(text=(paste0("input$usize",i))),", color = ", parse(text=(paste0("input$ucol",i))), ",  fontface=2) +
                            annotate('text',  x=5.5, y = 8, label = ", parse(text=(paste0("input$stxt",i))),",  size= ", parse(text=(paste0("input$ssize",i))),", color = ", parse(text=(paste0("input$scol",i))), ",  fontface=2) +
                            annotate('text',  x=5.5, y = 9, label = ", parse(text=(paste0("input$ptxt",i))),",  size= ", parse(text=(paste0("input$psize",i))),", color = ", parse(text=(paste0("input$pcol",i))), ",  fontface=2) +
                            geom_text(label=fontawesome(",parse(text=(paste0("input$icon",i))),"), family='fontawesome-webfont', y=5.5, x=5.5, color=",parse(text=(paste0("input$icol",i))),", size=", parse(text=(paste0("input$isize",i))),")")))

                          }


    #Create headers+footers
    myplot<-ggplot(data=data.frame(a=c(1,2,3,4,5), b=c(1,2,3,4,5)), aes(x=a, y=b))

    #Major Border Strip
    head <-  myplot +
      theme_void() +
      theme(panel.background = element_rect(fill = input$colmajor, colour = input$colmajor))

    #Minor Border Strip + Head Text
    head2 <- myplot +
      theme_void() +
      theme(panel.background = element_rect(fill = input$colminor, colour = input$colminor)) +
      annotate("text",  x=2, y = 2, label = paste("\n",input$headt, "\n", input$headt2, "\n"), colour="white", size=12, fontface=2)

    #Minor Border Strip + Foot Text
    head3 <- myplot +
      theme_void() +
      theme(panel.background = element_rect(fill = input$colminor, colour = input$colminor)) +
      annotate("text",  x=-0, y = 2 , label = input$ref, colour="white", size=10,   fontface=2)  +
      geom_text(label=fontawesome(input$logo), family='fontawesome-webfont', y=2,x=0.045, size=input$lsize, colour=input$lcol)

    #Put it all together
    grid.arrange(arrangeGrob(head2,head, nrow=2, heights=c(0.8,0.2)),
                 grid.arrange(grobs=subs, ncol=nTabs),
                 arrangeGrob(head,head3, nrow=2, heights=c(0.2,0.8)),
                 nrow=3,
                 heights=c(0.25,1.2,0.25)
    )

  })
}

#Run
shinyApp(ui=ui, server=server)



























