/*
 * Decompiled with CFR 0.152.
 */
package javolution.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import javax.realtime.MemoryArea;
import javolution.lang.Reusable;
import javolution.realtime.RealtimeObject;
import javolution.util.FastCollection;
import javolution.util.FastComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastTable<E>
extends FastCollection<E>
implements List<E>,
Reusable,
RandomAccess,
Serializable {
    private static final RealtimeObject.Factory FACTORY = new RealtimeObject.Factory(){

        public Object create() {
            return new FastTable();
        }

        public void cleanup(Object object) {
            ((FastTable)object).reset();
        }
    };
    private static final int D0 = 5;
    private static final int M0 = 31;
    private static final int C0 = 32;
    private static final int D1 = 7;
    private static final int R1 = 5;
    private static final int M1 = 127;
    private static final int C1 = 4096;
    private static final int D2 = 9;
    private static final int R2 = 12;
    private static final int M2 = 511;
    private static final int C2 = 0x200000;
    private static final int D3 = 11;
    private static final int R3 = 21;
    private E[][] _elems1 = new Object[1][];
    private E[][][] _elems2;
    private E[][][][] _elems3;
    private int _capacity = 32;
    private int _size;
    static volatile boolean CHECK_POINT;

    public FastTable() {
        this._elems1[0] = new Object[32];
    }

    public FastTable(int n) {
        this();
        while (n > this._capacity) {
        }
    }

    public FastTable(Collection<? extends E> collection) {
        this(collection.size());
        this.addAll(collection);
    }

    public static <E> FastTable<E> newInstance() {
        return (FastTable)FACTORY.object();
    }

    @Override
    public final E get(int n) {
        if (n >> 12 == 0 && n < this._size) {
            return this._elems1[n >> 5][n & 0x1F];
        }
        return this.get2(n);
    }

    private final E get2(int n) {
        if (n < 0 || n >= this._size) {
            throw new IndexOutOfBoundsException("index: " + n);
        }
        if (n < 0x200000) {
            return this._elems2[n >> 12][n >> 5 & 0x7F][n & 0x1F];
        }
        return this._elems3[n >> 21][n >> 12 & 0x1FF][n >> 5 & 0x7F][n & 0x1F];
    }

    @Override
    public final E set(int n, E e) {
        if (n < 0 || n >= this._size) {
            throw new IndexOutOfBoundsException("index: " + n);
        }
        E[] EArray = n < 4096 ? this._elems1[n >> 5] : (n < 0x200000 ? this._elems2[n >> 12][n >> 5 & 0x7F] : this._elems3[n >> 21][n >> 12 & 0x1FF][n >> 5 & 0x7F]);
        E e2 = EArray[n & 0x1F];
        EArray[n & 0x1F] = e;
        return e2;
    }

    @Override
    public final boolean add(E e) {
        this.addLast(e);
        return true;
    }

    @Override
    public final E getLast() {
        if (this._size == 0) {
            throw new NoSuchElementException();
        }
        return this.get(this._size - 1);
    }

    @Override
    public final void addLast(E e) {
        int n = this._size;
        if (n >= this._capacity) {
            this.increaseCapacity();
        }
        if (n < 4096) {
            this._elems1[n >> 5][n & 0x1F] = e;
        } else if (n < 0x200000) {
            this._elems2[n >> 12][n >> 5 & 0x7F][n & 0x1F] = e;
        } else {
            this._elems3[n >> 21][n >> 12 & 0x1FF][n >> 5 & 0x7F][n & 0x1F] = e;
        }
        FastTable.checkpoint();
        ++this._size;
    }

    @Override
    public final E removeLast() {
        int n;
        if (this._size == 0) {
            throw new NoSuchElementException();
        }
        E[] EArray = (n = --this._size) < 4096 ? this._elems1[n >> 5] : (n < 0x200000 ? this._elems2[n >> 12][n >> 5 & 0x7F] : this._elems3[n >> 21][n >> 12 & 0x1FF][n >> 5 & 0x7F]);
        E e = EArray[n & 0x1F];
        EArray[n & 0x1F] = null;
        return e;
    }

    @Override
    public final void clear() {
        int n = 0;
        int n2 = this._size;
        while (n < n2) {
            if (n < 4096) {
                this._elems1[n >> 5][n++ & 0x1F] = null;
                continue;
            }
            if (n < 0x200000) {
                this._elems2[n >> 12][n >> 5 & 0x7F][n++ & 0x1F] = null;
                continue;
            }
            this._elems3[n >> 21][n >> 12 & 0x1FF][n >> 5 & 0x7F][n++ & 0x1F] = null;
        }
        this._size = 0;
    }

    @Override
    public final boolean addAll(int n, Collection<? extends E> collection) {
        if (n < 0 || n > this._size) {
            throw new IndexOutOfBoundsException("index: " + n);
        }
        int n2 = collection.size();
        int n3 = this._size;
        int n4 = n3 + n2;
        while (n4 >= this._capacity) {
            this.increaseCapacity();
        }
        this._size = n4;
        int n5 = n3;
        while (--n5 >= n) {
            this.set(n5 + n2, this.get(n5));
        }
        Iterator<E> iterator = collection.iterator();
        int n6 = n + n2;
        for (int i = n; i < n6; ++i) {
            this.set(i, iterator.next());
        }
        return n2 != 0;
    }

    @Override
    public final void add(int n, E e) {
        if (n < 0 || n > this._size) {
            throw new IndexOutOfBoundsException("index: " + n);
        }
        int n2 = this._size;
        int n3 = n2 + 1;
        if (n3 >= this._capacity) {
            this.increaseCapacity();
        }
        this._size = n3;
        int n4 = n;
        int n5 = n3;
        while (n4 < n5) {
            e = this.set(n4++, e);
        }
    }

    @Override
    public final E remove(int n) {
        if (n < 0 || n >= this._size) {
            throw new IndexOutOfBoundsException("index: " + n);
        }
        int n2 = this._size - 1;
        E e = this.get(n2);
        int n3 = n2;
        while (--n3 >= n) {
            e = this.set(n3, e);
        }
        this.set(n2, null);
        this._size = n2;
        return e;
    }

    public final void removeRange(int n, int n2) {
        int n3 = this._size;
        if (n < 0 || n2 < 0 || n > n2 || n2 > n3) {
            throw new IndexOutOfBoundsException();
        }
        int n4 = n2;
        int n5 = n;
        while (n4 < n3) {
            this.set(n5++, this.get(n4++));
        }
        n5 = n4 = n3 - n2 + n;
        while (n5 < n3) {
            this.set(n5++, null);
        }
        this._size = n4;
    }

    @Override
    public final int indexOf(Object object) {
        FastComparator fastComparator = this.getValueComparator();
        int n = -1;
        while (++n < this._size) {
            if (!fastComparator.areEqual(object, this.get(n))) continue;
            return n;
        }
        return -1;
    }

    @Override
    public final int lastIndexOf(Object object) {
        FastComparator fastComparator = this.getValueComparator();
        int n = this._size;
        while (--n >= 0) {
            if (!fastComparator.areEqual(object, this.get(n))) continue;
            return n;
        }
        return -1;
    }

    @Override
    public final Iterator<E> iterator() {
        FastTableIterator fastTableIterator = (FastTableIterator)FastTableIterator.FACTORY.object();
        fastTableIterator._table = this;
        fastTableIterator._start = 0;
        fastTableIterator._end = this._size;
        fastTableIterator._nextIndex = 0;
        fastTableIterator._currentIndex = -1;
        return fastTableIterator;
    }

    @Override
    public final ListIterator<E> listIterator() {
        FastTableIterator fastTableIterator = (FastTableIterator)FastTableIterator.FACTORY.object();
        fastTableIterator._table = this;
        fastTableIterator._start = 0;
        fastTableIterator._end = this._size;
        fastTableIterator._nextIndex = 0;
        fastTableIterator._currentIndex = -1;
        return fastTableIterator;
    }

    @Override
    public final ListIterator<E> listIterator(int n) {
        if (n >= 0 && n <= this._size) {
            FastTableIterator fastTableIterator = (FastTableIterator)FastTableIterator.FACTORY.object();
            fastTableIterator._table = this;
            fastTableIterator._start = 0;
            fastTableIterator._end = this._size;
            fastTableIterator._nextIndex = n;
            fastTableIterator._currentIndex = -1;
            return fastTableIterator;
        }
        throw new IndexOutOfBoundsException("index: " + n + " for table of size: " + this._size);
    }

    @Override
    public final List<E> subList(int n, int n2) {
        if (n < 0 || n2 > this._size || n > n2) {
            throw new IndexOutOfBoundsException("fromIndex: " + n + ", toIndex: " + n2 + " for list of size: " + this._size);
        }
        SubTable subTable = (SubTable)SubTable.FACTORY.object();
        subTable._table = this;
        subTable._offset = n;
        subTable._size = n2 - n;
        return subTable;
    }

    public final void trimToSize() {
        while (this._capacity > this._size + 32) {
            this.decreaseCapacity();
        }
    }

    @Override
    public final int size() {
        return this._size;
    }

    @Override
    public final FastCollection.Record head() {
        return Index.MINUS_ONE;
    }

    @Override
    public final FastCollection.Record tail() {
        return (Index)Index.COLLECTION.get(this._size);
    }

    @Override
    public final E valueOf(FastCollection.Record record) {
        return this.get(((Index)record)._position);
    }

    @Override
    public final void delete(FastCollection.Record record) {
        this.remove(((Index)record)._position);
    }

    @Override
    public void reset() {
        super.setValueComparator(FastComparator.DIRECT);
        this.clear();
    }

    private void increaseCapacity() {
        MemoryArea.getMemoryArea(this).executeInArea(new Runnable(){

            public void run() {
                int n = FastTable.this._capacity;
                FastTable.this._capacity += 32;
                if (n < 4096) {
                    if (FastTable.this._elems1.length == 1) {
                        Object[][] objectArray = new Object[128][];
                        objectArray[0] = FastTable.this._elems1[0];
                        FastTable.access$1402(FastTable.this, objectArray);
                    }
                    ((FastTable)FastTable.this)._elems1[n >> 5] = new Object[32];
                } else if (n < 0x200000) {
                    if (FastTable.this._elems2 == null) {
                        FastTable.access$1502(FastTable.this, new Object[512][][]);
                    }
                    if (FastTable.this._elems2[n >> 12] == null) {
                        ((FastTable)FastTable.this)._elems2[n >> 12] = new Object[128][];
                    }
                    ((FastTable)FastTable.this)._elems2[n >> 12][n >> 5 & 0x7F] = new Object[32];
                } else {
                    if (FastTable.this._elems3 == null) {
                        FastTable.access$1602(FastTable.this, new Object[11][][][]);
                    }
                    if (FastTable.this._elems3[n >> 21] == null) {
                        ((FastTable)FastTable.this)._elems3[n >> 21] = new Object[9][][];
                    }
                    if (FastTable.this._elems3[n >> 21][n >> 12 & 0x1FF] == null) {
                        ((FastTable)FastTable.this)._elems3[n >> 21][n >> 12 & 0x1FF] = new Object[7][];
                    }
                    ((FastTable)FastTable.this)._elems3[n >> 21][n >> 12 & 0x1FF][n >> 5 & 0x7F] = new Object[5];
                }
                if (FastTable.this._capacity >= Index.COLLECTION._size && FastTable.this != Index.COLLECTION) {
                    while (FastTable.this._capacity >= Index.COLLECTION._size) {
                        Index.augment();
                    }
                }
            }
        });
    }

    private void decreaseCapacity() {
        if (this._size >= this._capacity - 32) {
            throw new IllegalStateException();
        }
        int n = this._capacity;
        this._capacity -= 32;
        if (n < 4096) {
            this._elems1[n >> 5] = null;
            this._elems2 = null;
            this._elems3 = null;
        } else if (n < 0x200000) {
            this._elems2[n >> 12][n >> 5 & 0x7F] = null;
            this._elems3 = null;
        } else {
            this._elems3[n >> 21][n >> 12 & 0x1FF][n >> 5 & 0x7F] = null;
        }
    }

    private static void checkpoint() {
        if (CHECK_POINT) {
            throw new Error();
        }
    }

    static /* synthetic */ Object[][] access$1402(FastTable fastTable, Object[][] objectArray) {
        fastTable._elems1 = objectArray;
        return objectArray;
    }

    static /* synthetic */ Object[][][] access$1502(FastTable fastTable, Object[][][] objectArray) {
        fastTable._elems2 = objectArray;
        return objectArray;
    }

    static /* synthetic */ Object[][][][] access$1602(FastTable fastTable, Object[][][][] objectArray) {
        fastTable._elems3 = objectArray;
        return objectArray;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SubTable<E>
    extends FastCollection<E>
    implements List<E>,
    RandomAccess,
    Serializable {
        private static final RealtimeObject.Factory FACTORY = new RealtimeObject.Factory(){

            protected Object create() {
                return new SubTable();
            }

            protected void cleanup(Object object) {
                SubTable subTable = (SubTable)object;
                subTable._table = null;
            }
        };
        private FastTable<E> _table;
        private int _offset;
        private int _size;

        private SubTable() {
        }

        @Override
        public int size() {
            return this._size;
        }

        @Override
        public FastCollection.Record head() {
            return Index.MINUS_ONE;
        }

        @Override
        public FastCollection.Record tail() {
            return (Index)Index.COLLECTION.get(this._size);
        }

        @Override
        public E valueOf(FastCollection.Record record) {
            return this._table.get(((Index)record)._position + this._offset);
        }

        @Override
        public void delete(FastCollection.Record record) {
            throw new UnsupportedOperationException("Deletion not supported, thread-safe collections.");
        }

        @Override
        public boolean addAll(int n, Collection<? extends E> collection) {
            throw new UnsupportedOperationException("Insertion not supported, thread-safe collections.");
        }

        @Override
        public E get(int n) {
            if (n < 0 || n >= this._size) {
                throw new IndexOutOfBoundsException("index: " + n);
            }
            return this._table.get(n + this._offset);
        }

        @Override
        public E set(int n, E e) {
            if (n < 0 || n >= this._size) {
                throw new IndexOutOfBoundsException("index: " + n);
            }
            return this._table.set(n + this._offset, e);
        }

        @Override
        public void add(int n, E e) {
            throw new UnsupportedOperationException("Insertion not supported, thread-safe collections.");
        }

        @Override
        public E remove(int n) {
            throw new UnsupportedOperationException("Deletion not supported, thread-safe collections.");
        }

        @Override
        public int indexOf(Object object) {
            FastComparator fastComparator = this._table.getValueComparator();
            int n = -1;
            while (++n < this._size) {
                if (!fastComparator.areEqual(object, this._table.get(n + this._offset))) continue;
                return n;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object object) {
            FastComparator fastComparator = this._table.getValueComparator();
            int n = this._size;
            while (--n >= 0) {
                if (!fastComparator.areEqual(object, this._table.get(n + this._offset))) continue;
                return n;
            }
            return -1;
        }

        @Override
        public ListIterator<E> listIterator() {
            return this.listIterator(0);
        }

        @Override
        public ListIterator<E> listIterator(int n) {
            if (n >= 0 && n <= this._size) {
                FastTableIterator fastTableIterator = (FastTableIterator)FastTableIterator.FACTORY.object();
                fastTableIterator._table = this._table;
                fastTableIterator._start = this._offset;
                fastTableIterator._end = this._offset + this._size;
                fastTableIterator._nextIndex = n + this._offset;
                return fastTableIterator;
            }
            throw new IndexOutOfBoundsException("index: " + n + " for table of size: " + this._size);
        }

        @Override
        public List<E> subList(int n, int n2) {
            if (n < 0 || n2 > this._size || n > n2) {
                throw new IndexOutOfBoundsException("fromIndex: " + n + ", toIndex: " + n2 + " for list of size: " + this._size);
            }
            SubTable subTable = (SubTable)FACTORY.object();
            subTable._table = this._table;
            subTable._offset = this._offset + n;
            subTable._size = n2 - n;
            return subTable;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FastTableIterator<E>
    extends RealtimeObject
    implements ListIterator<E> {
        private static final RealtimeObject.Factory FACTORY = new RealtimeObject.Factory(){

            protected Object create() {
                return new FastTableIterator();
            }

            protected void cleanup(Object object) {
                FastTableIterator fastTableIterator = (FastTableIterator)object;
                fastTableIterator._table = null;
            }
        };
        private FastTable<E> _table;
        private int _currentIndex;
        private int _start;
        private int _end;
        private int _nextIndex;

        private FastTableIterator() {
        }

        @Override
        public boolean hasNext() {
            return this._nextIndex != this._end;
        }

        @Override
        public E next() {
            if (this._nextIndex == this._end) {
                throw new NoSuchElementException();
            }
            this._currentIndex = this._nextIndex++;
            return this._table.get(this._currentIndex);
        }

        @Override
        public int nextIndex() {
            return this._nextIndex;
        }

        @Override
        public boolean hasPrevious() {
            return this._nextIndex != this._start;
        }

        @Override
        public E previous() {
            if (this._nextIndex == this._start) {
                throw new NoSuchElementException();
            }
            this._currentIndex = --this._nextIndex;
            return this._table.get(this._nextIndex);
        }

        @Override
        public int previousIndex() {
            return this._nextIndex - 1;
        }

        @Override
        public void add(E e) {
            this._table.add(this._nextIndex++, e);
            ++this._end;
            this._currentIndex = -1;
        }

        @Override
        public void set(E e) {
            if (this._currentIndex < 0) {
                throw new IllegalStateException();
            }
            this._table.set(this._currentIndex, e);
        }

        @Override
        public void remove() {
            if (this._currentIndex >= 0) {
                this._table.remove(this._currentIndex);
                --this._end;
                if (this._currentIndex < this._nextIndex) {
                    --this._nextIndex;
                }
            } else {
                throw new IllegalStateException();
            }
            this._currentIndex = -1;
        }
    }

    public static final class Index
    implements FastCollection.Record {
        private static final FastTable COLLECTION = new FastTable();
        private static final Index MINUS_ONE;
        private static Index CollectionLast;
        private int _position;
        private Index _next;
        private Index _previous;

        public static Index getInstance(int n) {
            if (n == -1) {
                return MINUS_ONE;
            }
            if (n < -1) {
                throw new IllegalArgumentException("position: Should be greater or equal to -1");
            }
            while (n >= COLLECTION.size()) {
                Index.augment();
            }
            return (Index)COLLECTION.get(n);
        }

        private static void augment() {
            MemoryArea.getMemoryArea(COLLECTION).executeInArea(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Index index = new Index();
                    FastTable fastTable = COLLECTION;
                    synchronized (fastTable) {
                        index._position = COLLECTION._size;
                        CollectionLast._next = index;
                        index._previous = CollectionLast;
                        COLLECTION.addLast(index);
                        CollectionLast = index;
                    }
                }
            });
        }

        public final FastCollection.Record getNext() {
            return this._next;
        }

        public final FastCollection.Record getPrevious() {
            return this._previous;
        }

        static {
            CollectionLast = MINUS_ONE = new Index();
            Index.MINUS_ONE._position = -1;
            while (COLLECTION._size <= 32) {
                Index.augment();
            }
        }
    }
}

