/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.UnsupervisedLearning.AssociationRules.FuzzyRuleLearning.FuzzyApriori;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.FuzzyRuleLearning.FuzzyApriori.AssociationRule;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.FuzzyRuleLearning.FuzzyApriori.FuzzyAprioriProcess;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.FuzzyRuleLearning.FuzzyApriori.FuzzyRegion;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.FuzzyRuleLearning.FuzzyApriori.Item;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.FuzzyRuleLearning.FuzzyApriori.Itemset;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.FuzzyRuleLearning.FuzzyApriori.myDataset;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.FuzzyRuleLearning.FuzzyApriori.parseParameters;

public class FuzzyApriori {
    private myDataset trans;
    private String rulesFilename;
    private String valuesFilename;
    private String fuzzyAttributesFilename;
    private FuzzyAprioriProcess proc;
    private ArrayList<AssociationRule> associationRulesSet;
    private int nFuzzyRegionsForNumericAttributes;
    private double minSupport;
    private double minConfidence;
    private boolean useMaxForOneFrequentItemsets;
    private boolean somethingWrong = false;

    public FuzzyApriori() {
    }

    public FuzzyApriori(parseParameters parameters) {
        this.rulesFilename = parameters.getAssociationRulesFile();
        this.fuzzyAttributesFilename = parameters.getOutputFile(0);
        this.valuesFilename = parameters.getOutputFile(1);
        this.nFuzzyRegionsForNumericAttributes = Integer.parseInt(parameters.getParameter(0));
        try {
            System.out.println("\nReading the transaction set: " + parameters.getTransactionsInputFile());
            this.trans = new myDataset(this.nFuzzyRegionsForNumericAttributes);
            this.trans.readDataSet(parameters.getTransactionsInputFile());
        }
        catch (IOException e) {
            System.err.println("There was a problem while reading the input transaction set: " + e);
            this.somethingWrong = true;
        }
        this.useMaxForOneFrequentItemsets = Boolean.parseBoolean(parameters.getParameter(1));
        this.minSupport = Double.parseDouble(parameters.getParameter(2));
        this.minConfidence = Double.parseDouble(parameters.getParameter(3));
    }

    public void execute() {
        if (this.somethingWrong) {
            System.err.println("An error was found");
            System.err.println("Aborting the program");
        } else {
            this.proc = new FuzzyAprioriProcess(this.trans, this.useMaxForOneFrequentItemsets, this.minSupport, this.minConfidence);
            this.proc.run();
            this.associationRulesSet = this.proc.getRulesSet();
            this.proc.printReport(this.associationRulesSet);
            try {
                this.saveFuzzyAttributes(this.fuzzyAttributesFilename);
                PrintWriter rules_writer = new PrintWriter(this.rulesFilename);
                PrintWriter values_writer = new PrintWriter(this.valuesFilename);
                rules_writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                rules_writer.println("<rules>");
                values_writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                values_writer.print("<values ");
                values_writer.println("n_one_frequent_itemsets=\"" + this.proc.getNumberOfOneFrequentItemsets() + "\" n_rules=\"" + this.associationRulesSet.size() + "\">");
                for (int r = 0; r < this.associationRulesSet.size(); ++r) {
                    int i;
                    AssociationRule ar = this.associationRulesSet.get(r);
                    rules_writer.println("<rule id = \"" + r + "\">");
                    values_writer.println("<rule id=\"" + r + "\" rule_support=\"" + ar.getRuleSupport() + "\" antecedent_support=\"" + ar.getAntecedentSupport() + "\" consequent_support=\"" + ar.getConsequentSupport() + "\" confidence=\"" + ar.getConfidence() + "\"/>");
                    rules_writer.println("<antecedents>");
                    Itemset itemset = ar.getAntecedent();
                    for (i = 0; i < itemset.size(); ++i) {
                        this.createRule(itemset.get(i), rules_writer);
                    }
                    rules_writer.println("</antecedents>");
                    rules_writer.println("<consequents>");
                    itemset = ar.getConsequent();
                    for (i = 0; i < itemset.size(); ++i) {
                        this.createRule(itemset.get(i), rules_writer);
                    }
                    rules_writer.println("</consequents>");
                    rules_writer.println("</rule>");
                }
                rules_writer.println("</rules>");
                values_writer.println("</values>");
                rules_writer.close();
                values_writer.close();
                System.out.println("\nAlgorithm Finished");
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    private void createRule(Item item, PrintWriter w) {
        int id_attr = item.getIDAttribute();
        int id_label = item.getIDLabel();
        w.print("<attribute name = \"" + this.trans.getAttributeName(id_attr) + "\" value = \"");
        w.print(this.trans.getFuzzyAttribute(id_attr)[id_label].getLabel());
        w.println("\" />");
    }

    private void saveFuzzyAttributes(String fuzzy_attrs_fname) throws FileNotFoundException {
        PrintWriter fuzzy_attrs_writer = new PrintWriter(fuzzy_attrs_fname);
        fuzzy_attrs_writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        fuzzy_attrs_writer.println("<data_base>");
        for (int id_attr = 0; id_attr < this.trans.getnVars(); ++id_attr) {
            int id_label;
            FuzzyRegion[] fuzzy_attr = this.trans.getFuzzyAttribute(id_attr);
            fuzzy_attrs_writer.println("<attribute name = \"" + this.trans.getAttributeName(id_attr) + "\" nValues = \"" + fuzzy_attr.length + "\" Type = \"" + this.trans.getAttributeTypeString(id_attr) + "\" >");
            if (this.trans.isNominal(id_attr)) {
                for (id_label = 0; id_label < fuzzy_attr.length; ++id_label) {
                    fuzzy_attrs_writer.println("<value x=\"" + fuzzy_attr[id_label].getLabel() + "\" />");
                }
            } else {
                for (id_label = 0; id_label < fuzzy_attr.length; ++id_label) {
                    fuzzy_attrs_writer.print("<value labelname=\"" + fuzzy_attr[id_label].getLabel() + "\" ");
                    fuzzy_attrs_writer.print("x1=\"" + fuzzy_attr[id_label].getX0() + "\" ");
                    fuzzy_attrs_writer.print("x2=\"" + fuzzy_attr[id_label].getX1() + "\" ");
                    fuzzy_attrs_writer.println("x3=\"" + fuzzy_attr[id_label].getX3() + "\" />");
                }
            }
            fuzzy_attrs_writer.println("</attribute>");
        }
        fuzzy_attrs_writer.println("</data_base>");
        fuzzy_attrs_writer.close();
    }
}

