/*
 * Decompiled with CFR 0.152.
 */
package dr.util;

import java.io.Serializable;
import java.text.DecimalFormat;

public class NumberFormatter
implements Serializable {
    private int sf;
    private double upperCutoff;
    private double[] cutoffTable;
    private final DecimalFormat decimalFormat = new DecimalFormat();
    private DecimalFormat scientificFormat = null;
    private boolean isPadding = false;
    private int fieldWidth;

    public NumberFormatter(int n) {
        this.setSignificantFigures(n);
    }

    public NumberFormatter(int n, int n2) {
        this.setSignificantFigures(n);
        this.setPadding(true);
        this.setFieldWidth(n2);
    }

    public void setSignificantFigures(int n) {
        this.sf = n;
        this.upperCutoff = Math.pow(10.0, Math.max(n - 1, 0));
        this.cutoffTable = new double[n];
        long l = 10L;
        for (int i = 0; i < this.cutoffTable.length; ++i) {
            this.cutoffTable[i] = l;
            l *= 10L;
        }
        this.decimalFormat.setMinimumIntegerDigits(1);
        this.decimalFormat.setMaximumFractionDigits(Math.max(n - 1, 0));
        this.decimalFormat.setMinimumFractionDigits(Math.max(n - 1, 0));
        this.decimalFormat.setGroupingUsed(false);
        this.scientificFormat = new DecimalFormat(this.getScientificPattern(n));
        this.fieldWidth = n;
    }

    public void setPadding(boolean bl) {
        this.isPadding = bl;
    }

    public void setFieldWidth(int n) {
        if (n < this.sf + 4) {
            throw new IllegalArgumentException();
        }
        this.fieldWidth = n;
    }

    public int getFieldWidth() {
        return this.fieldWidth;
    }

    public String formatToFieldWidth(String string, int n) {
        int n2 = n - string.length();
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    public String formatDecimal(double d, int n) {
        this.decimalFormat.setMaximumFractionDigits(n);
        this.decimalFormat.setMinimumFractionDigits(Math.min(n, 1));
        return this.decimalFormat.format(d);
    }

    public String format(double d) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        double d2 = Math.abs(d);
        if (this.sf > 0 && d2 > this.upperCutoff || d2 < 1.0 / this.upperCutoff && d2 != 0.0) {
            stringBuffer.append(this.scientificFormat.format(d));
        } else {
            n = 0;
            if (d != (double)((int)d)) {
                n = this.getNumFractionDigits(d);
            }
            stringBuffer.append(this.formatDecimal(d, n));
        }
        if (this.isPadding) {
            n = this.fieldWidth - stringBuffer.length();
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(' ');
            }
        }
        return stringBuffer.toString();
    }

    private int getNumFractionDigits(double d) {
        d = Math.abs(d);
        for (int i = 0; i < this.cutoffTable.length; ++i) {
            if (!(d < this.cutoffTable[i])) continue;
            return this.sf - i - 1;
        }
        return this.sf - 1;
    }

    private String getScientificPattern(int n) {
        String string = "0.";
        for (int i = 0; i < n - 1; ++i) {
            string = string + "#";
        }
        string = string + "E0";
        return string;
    }
}

