/*
 * Decompiled with CFR 0.152.
 */
package dr.oldevomodel.substmodel;

import dr.evolution.datatype.Microsatellite;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.oldevomodel.substmodel.LinearBiasModel;
import dr.oldevomodel.substmodel.MicrosatelliteModel;
import dr.oldevomodel.substmodel.TwoPhaseModel;
import java.util.ArrayList;
import java.util.Map;

public class MsatBMA
extends MicrosatelliteModel {
    private boolean logit;
    public static final int PROP_INDEX = 0;
    public static final int QUAD_INDEX = 1;
    public static final int BIAS_CONST_INDEX = 2;
    public static final int BIAS_LIN_INDEX = 3;
    public static final int GEO_INDEX = 4;
    public static final int PHASE_PROB_INDEX = 5;
    public static final double DEFAULT_VALUE = 0.0;
    public static final int PARAMETER_PRESENT = 1;
    public Parameter[][] paramModelMap;
    public Map<Integer, Integer> modelMap;
    public Parameter modelChoose;
    public Parameter modelIndicator;
    public ArrayList<Parameter> propRates = new ArrayList();
    public ArrayList<Parameter> quadRates = new ArrayList();
    public ArrayList<Parameter> biasConsts = new ArrayList();
    public ArrayList<Parameter> biasLins = new ArrayList();
    public ArrayList<Parameter> geos = new ArrayList();
    public ArrayList<Parameter> phaseProb = new ArrayList();

    public MsatBMA(Microsatellite microsatellite, boolean bl, ArrayList<Parameter> arrayList, ArrayList<Parameter> arrayList2, ArrayList<Parameter> arrayList3, ArrayList<Parameter> arrayList4, ArrayList<Parameter> arrayList5, ArrayList<Parameter> arrayList6, Parameter[][] parameterArray, Parameter parameter, Parameter parameter2, Map<Integer, Integer> map) {
        super("MsatAveragingModel", microsatellite, null, null);
        int n;
        for (n = 0; n < arrayList.size(); ++n) {
            this.addVariable(arrayList.get(n));
        }
        for (n = 0; n < arrayList2.size(); ++n) {
            this.addVariable(arrayList2.get(n));
        }
        for (n = 0; n < arrayList3.size(); ++n) {
            this.addVariable(arrayList3.get(n));
        }
        for (n = 0; n < arrayList4.size(); ++n) {
            this.addVariable(arrayList4.get(n));
        }
        for (n = 0; n < arrayList5.size(); ++n) {
            this.addVariable(arrayList5.get(n));
        }
        for (n = 0; n < arrayList6.size(); ++n) {
            this.addVariable(arrayList6.get(n));
        }
        this.addVariable(parameter);
        this.addVariable(parameter2);
        this.propRates = arrayList;
        this.biasConsts = arrayList3;
        this.biasLins = arrayList4;
        this.geos = arrayList5;
        this.logit = bl;
        this.modelChoose = parameter;
        this.modelIndicator = parameter2;
        this.paramModelMap = parameterArray;
        this.modelMap = map;
        this.setupInfinitesimalRates();
        this.setupMatrix();
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.modelUpdate = false;
        int n2 = -1;
        if (this.propRates.contains(variable)) {
            n2 = 0;
        } else if (this.quadRates.contains(variable)) {
            n2 = 1;
        } else if (this.biasConsts.contains(variable)) {
            n2 = 2;
        } else if (this.biasLins.contains(variable)) {
            n2 = 3;
        } else if (this.geos.contains(variable)) {
            n2 = 4;
        } else if (this.phaseProb.contains(variable)) {
            n2 = 5;
        }
        if (n2 > -1) {
            if (this.paramModelMap[n2][this.modelMap.get(this.getBitVectorValue())] != null) {
                this.updateMatrix = true;
                this.modelUpdate = true;
            }
        } else if (variable == this.modelChoose) {
            this.updateMatrix = true;
            this.indicateModel();
            this.modelUpdate = true;
        }
    }

    public void indicateModel() {
        this.modelIndicator.setParameterValueQuietly(0, this.modelMap.get(this.getBitVectorValue()).intValue());
    }

    @Override
    public void setupInfinitesimalRates() {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        this.infinitesimalRateMatrix = new double[this.stateCount][this.stateCount];
        if ((int)this.modelChoose.getParameterValue(0) == 1) {
            d = this.getModelParameterValue(0);
            if ((int)this.modelChoose.getParameterValue(1) == 1) {
                d2 = this.getModelParameterValue(1);
            }
        }
        for (int i = 0; i < this.stateCount; ++i) {
            double d7 = 0.0;
            if (i - 1 > -1) {
                this.infinitesimalRateMatrix[i][i - 1] = 1.0 + d * (double)i;
                d7 += this.infinitesimalRateMatrix[i][i - 1];
            }
            if (i + 1 < this.stateCount) {
                this.infinitesimalRateMatrix[i][i + 1] = 1.0 + d * (double)i;
                d7 += this.infinitesimalRateMatrix[i][i + 1];
            }
            this.infinitesimalRateMatrix[i][i] = -d7;
        }
        if ((int)this.modelChoose.getParameterValue(2) == 1) {
            d3 = this.getModelParameterValue(2);
            if ((int)this.modelChoose.getParameterValue(3) == 1) {
                d4 = this.getModelParameterValue(3);
            }
            double[][] dArray = this.infinitesimalRateMatrix;
            this.infinitesimalRateMatrix = new double[this.stateCount][this.stateCount];
            LinearBiasModel.setupInfinitesimalRates(this.infinitesimalRateMatrix, dArray, d3, d4, this.stateCount, this.logit);
        }
        if ((int)this.modelChoose.getParameterValue(4) == 1) {
            d5 = this.getModelParameterValue(4);
            if ((int)this.modelChoose.getParameterValue(5) == 1) {
                d6 = this.getModelParameterValue(5);
            }
            double[][] dArray = this.infinitesimalRateMatrix;
            this.infinitesimalRateMatrix = new double[this.stateCount][this.stateCount];
            TwoPhaseModel.setupInfinitesimalRates(this.stateCount, d5, d6, this.infinitesimalRateMatrix, dArray);
        }
    }

    private double getModelParameterValue(int n) {
        int n2 = this.modelMap.get(this.getBitVectorValue());
        return this.paramModelMap[n][n2].getParameterValue(0);
    }

    private int getBitVectorValue() {
        String string = "";
        for (int i = 0; i < this.modelChoose.getDimension(); ++i) {
            string = string + (int)this.modelChoose.getParameterValue(i);
        }
        return Integer.parseInt(string, 2);
    }

    @Override
    public void computeStationaryDistribution() {
        if ((int)this.modelChoose.getParameterValue(4) == 1) {
            this.computeTwoPhaseStationaryDistribution();
        } else {
            this.computeOnePhaseStationaryDistribution();
        }
        super.computeStationaryDistribution();
    }
}

