/*
 * Decompiled with CFR 0.152.
 */
package dr.math;

import org.apache.commons.math.linear.Array2DRowRealMatrix;
import org.apache.commons.math.linear.RealMatrix;
import org.apache.commons.math.linear.SingularValueDecompositionImpl;

public class Procrustes {
    private final RealMatrix R;
    private final RealMatrix T;
    private final double s;
    private final int rowDimension;
    private final int columnDimension;

    public Procrustes(RealMatrix realMatrix, RealMatrix realMatrix2, boolean bl, boolean bl2) {
        RealMatrix realMatrix3;
        RealMatrix realMatrix4;
        int n;
        this.rowDimension = realMatrix.getRowDimension();
        this.columnDimension = realMatrix.getColumnDimension();
        if (realMatrix2.getRowDimension() != this.rowDimension) {
            throw new IllegalArgumentException("X and Xstar do not have the same number of rows");
        }
        if (realMatrix2.getColumnDimension() != this.columnDimension) {
            throw new IllegalArgumentException("X and Xstar do not have the same number of columns");
        }
        Array2DRowRealMatrix array2DRowRealMatrix = new Array2DRowRealMatrix(this.rowDimension, this.rowDimension);
        if (bl) {
            for (n = 0; n < this.rowDimension; ++n) {
                array2DRowRealMatrix.setEntry(n, n, 1.0 - 1.0 / (double)this.rowDimension);
                for (int i = n + 1; i < this.rowDimension; ++i) {
                    array2DRowRealMatrix.setEntry(n, i, -1.0 / (double)this.rowDimension);
                    array2DRowRealMatrix.setEntry(i, n, -1.0 / (double)this.rowDimension);
                }
            }
        } else {
            for (n = 0; n < this.rowDimension; ++n) {
                array2DRowRealMatrix.setEntry(n, n, 1.0);
            }
        }
        RealMatrix realMatrix5 = realMatrix2.transpose().multiply(array2DRowRealMatrix.multiply(realMatrix));
        SingularValueDecompositionImpl singularValueDecompositionImpl = new SingularValueDecompositionImpl(realMatrix5);
        this.R = singularValueDecompositionImpl.getV().multiply(singularValueDecompositionImpl.getUT());
        double d = 1.0;
        if (bl2) {
            realMatrix4 = realMatrix2.transpose().multiply(array2DRowRealMatrix.multiply(realMatrix.multiply(this.R)));
            realMatrix3 = realMatrix.transpose().multiply(array2DRowRealMatrix.multiply(realMatrix));
            double d2 = 0.0;
            double d3 = 0.0;
            for (int i = 0; i < this.columnDimension; ++i) {
                d2 += realMatrix4.getEntry(i, i);
                d3 += realMatrix3.getEntry(i, i);
            }
            d = d2 / d3;
        }
        this.s = d;
        realMatrix4 = new Array2DRowRealMatrix(this.columnDimension, 1);
        if (bl) {
            realMatrix3 = new Array2DRowRealMatrix(this.rowDimension, 1);
            for (int i = 0; i < this.rowDimension; ++i) {
                realMatrix3.setEntry(i, 0, 1.0);
            }
            realMatrix4 = realMatrix2.subtract(realMatrix.multiply(this.R).scalarMultiply(d)).transpose().scalarMultiply(1.0 / (double)this.rowDimension).multiply(realMatrix3);
        }
        this.T = realMatrix4;
    }

    public final RealMatrix getTranslation() {
        return this.T.copy();
    }

    public final double getDilation() {
        return this.s;
    }

    public final RealMatrix getR() {
        return this.R.copy();
    }

    public final RealMatrix procrustinate(RealMatrix realMatrix) {
        if (realMatrix.getRowDimension() != this.rowDimension) {
            throw new IllegalArgumentException("X does not have the expected number of rows");
        }
        if (realMatrix.getColumnDimension() != this.columnDimension) {
            throw new IllegalArgumentException("X does not have the expected number of columns");
        }
        Array2DRowRealMatrix array2DRowRealMatrix = new Array2DRowRealMatrix(this.rowDimension, this.columnDimension);
        for (int i = 0; i < this.rowDimension; ++i) {
            array2DRowRealMatrix.setRowMatrix(i, this.T.transpose());
        }
        return realMatrix.multiply(this.R).scalarMultiply(this.s).add(array2DRowRealMatrix);
    }

    public double[] procrustinate(double[] dArray) {
        if (dArray.length != this.columnDimension) {
            throw new IllegalArgumentException("X does not have the expected number of elements");
        }
        Array2DRowRealMatrix array2DRowRealMatrix = new Array2DRowRealMatrix(dArray);
        RealMatrix realMatrix = array2DRowRealMatrix.multiply(this.R).scalarMultiply(this.s).add(this.T);
        return realMatrix.getRow(0);
    }

    public static final RealMatrix procrustinate(RealMatrix realMatrix, RealMatrix realMatrix2, boolean bl, boolean bl2) {
        return new Procrustes(realMatrix, realMatrix2, bl, bl2).procrustinate(realMatrix);
    }
}

