/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.loggers.LogColumn;
import dr.inference.model.AbstractModelLikelihood;
import dr.inference.model.CompoundModel;
import dr.inference.model.Likelihood;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.math.LogTricks;
import dr.util.Citable;
import dr.util.Citation;
import dr.util.CommonCitations;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;

public class WeightedMixtureModel
extends AbstractModelLikelihood
implements Citable {
    public static final String MIXTURE_MODEL = "mixtureModel";
    public static final String NORMALIZE = "normalize";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newBooleanRule("normalize", true), new ElementRule(Likelihood.class, 2, Integer.MAX_VALUE), new ElementRule(Parameter.class)};

        @Override
        public String getParserName() {
            return WeightedMixtureModel.MIXTURE_MODEL;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            Parameter parameter = (Parameter)xMLObject.getChild(Parameter.class);
            ArrayList<AbstractModelLikelihood> arrayList = new ArrayList<AbstractModelLikelihood>();
            for (int i = 0; i < xMLObject.getChildCount(); ++i) {
                if (!(xMLObject.getChild(i) instanceof Likelihood)) continue;
                arrayList.add((AbstractModelLikelihood)xMLObject.getChild(i));
            }
            if (parameter.getDimension() != arrayList.size()) {
                throw new XMLParseException("Dim of " + parameter.getId() + " does not match the number of likelihoods");
            }
            if (xMLObject.hasAttribute(WeightedMixtureModel.NORMALIZE) && xMLObject.getBooleanAttribute(WeightedMixtureModel.NORMALIZE)) {
                int n;
                double d = 0.0;
                for (n = 0; n < parameter.getDimension(); ++n) {
                    d += parameter.getParameterValue(n);
                }
                for (n = 0; n < parameter.getDimension(); ++n) {
                    parameter.setParameterValue(n, parameter.getParameterValue(n) / d);
                }
            }
            if (!this.normalized(parameter)) {
                throw new XMLParseException("Parameter +" + parameter.getId() + " must lie on the simplex");
            }
            return new WeightedMixtureModel(arrayList, parameter);
        }

        private boolean normalized(Parameter parameter) {
            double d = 0.0;
            for (int i = 0; i < parameter.getDimension(); ++i) {
                d += parameter.getParameterValue(i);
            }
            return d == 1.0;
        }

        @Override
        public String getParserDescription() {
            return "This element represents a finite mixture of likelihood models.";
        }

        @Override
        public Class getReturnType() {
            return CompoundModel.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };
    private final Parameter mixtureWeights;
    List<AbstractModelLikelihood> likelihoodList;

    public WeightedMixtureModel(List<AbstractModelLikelihood> list, Parameter parameter) {
        super(MIXTURE_MODEL);
        this.likelihoodList = list;
        this.mixtureWeights = parameter;
        for (AbstractModelLikelihood object : list) {
            this.addModel(object);
        }
        this.addVariable(parameter);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Constructing a finite mixture model\n");
        stringBuilder.append("\tComponents:\n");
        for (AbstractModelLikelihood abstractModelLikelihood : list) {
            stringBuilder.append("\t\t\t").append(abstractModelLikelihood.getId()).append("\n");
        }
        stringBuilder.append("\tMixing parameter: ").append(parameter.getId()).append("\n");
        stringBuilder.append("\tPlease cite:\n");
        stringBuilder.append(Citable.Utils.getCitationString(this));
        Logger.getLogger("dr.inference.model").info(stringBuilder.toString());
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    protected final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public Model getModel() {
        return this;
    }

    @Override
    public double getLogLikelihood() {
        double d = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.likelihoodList.size(); ++i) {
            double d2 = this.mixtureWeights.getParameterValue(i);
            if (!(d2 > 0.0)) continue;
            d = LogTricks.logSum(d, Math.log(d2) + this.likelihoodList.get(i).getLogLikelihood());
        }
        return d;
    }

    @Override
    public void makeDirty() {
    }

    @Override
    public LogColumn[] getColumns() {
        return new LogColumn[0];
    }

    public static void main(String[] stringArray) {
        AbstractModelLikelihood abstractModelLikelihood = new AbstractModelLikelihood("dummy"){

            @Override
            public Model getModel() {
                return null;
            }

            @Override
            public double getLogLikelihood() {
                return -10.0;
            }

            @Override
            public void makeDirty() {
            }

            @Override
            public String prettyName() {
                return null;
            }

            @Override
            public boolean isUsed() {
                return false;
            }

            @Override
            protected void handleModelChangedEvent(Model model, Object object, int n) {
            }

            @Override
            protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
            }

            @Override
            protected void storeState() {
            }

            @Override
            protected void restoreState() {
            }

            @Override
            protected void acceptState() {
            }

            @Override
            public void setUsed() {
            }

            @Override
            public LogColumn[] getColumns() {
                return new LogColumn[0];
            }

            @Override
            public String getId() {
                return null;
            }

            @Override
            public void setId(String string) {
            }
        };
        AbstractModelLikelihood abstractModelLikelihood2 = new AbstractModelLikelihood("dummy"){

            @Override
            public Model getModel() {
                return null;
            }

            @Override
            public double getLogLikelihood() {
                return -2.0;
            }

            @Override
            public void makeDirty() {
            }

            @Override
            public String prettyName() {
                return null;
            }

            @Override
            public boolean isUsed() {
                return false;
            }

            @Override
            protected void handleModelChangedEvent(Model model, Object object, int n) {
            }

            @Override
            protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
            }

            @Override
            protected void storeState() {
            }

            @Override
            protected void restoreState() {
            }

            @Override
            protected void acceptState() {
            }

            @Override
            public void setUsed() {
            }

            @Override
            public LogColumn[] getColumns() {
                return new LogColumn[0];
            }

            @Override
            public String getId() {
                return null;
            }

            @Override
            public void setId(String string) {
            }
        };
        ArrayList<AbstractModelLikelihood> arrayList = new ArrayList<AbstractModelLikelihood>();
        arrayList.add(abstractModelLikelihood);
        arrayList.add(abstractModelLikelihood2);
        Parameter.Default default_ = new Parameter.Default(2);
        double d = 0.05;
        default_.setParameterValue(0, d);
        default_.setParameterValue(1, 1.0 - d);
        WeightedMixtureModel weightedMixtureModel = new WeightedMixtureModel(arrayList, default_);
        System.err.println("getLogLikelihood() = " + weightedMixtureModel.getLogLikelihood());
        double d2 = Math.log(d * Math.exp(-10.0) + (1.0 - d) * Math.exp(-2.0));
        System.err.println("correct            = " + d2);
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.MISC;
    }

    @Override
    public String getDescription() {
        return "Weighted mixture model";
    }

    @Override
    public List<Citation> getCitations() {
        return Collections.singletonList(CommonCitations.LEMEY_MIXTURE_2012);
    }
}

