/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.loggers.LogColumn;
import dr.inference.loggers.NumberColumn;
import dr.inference.model.FastMatrixParameter;
import dr.inference.model.Variable;

public class AdaptableSizeFastMatrixParameter
extends FastMatrixParameter {
    int rowDimension;
    int columnDimension;
    int storedRowDimension;
    int storedColumnDimension;
    int maxRow;
    int maxCol;
    boolean lowerTriangle;

    public AdaptableSizeFastMatrixParameter(String string, int n, int n2, int n3, int n4, double d, boolean bl) {
        super(string, n3, n4, d);
        if (n3 < n) {
            throw new RuntimeException("Row Dimension: " + n + ", is greater than Max Row Dimension: " + n3 + " in " + this.getParameterName());
        }
        if (n4 < n2) {
            throw new RuntimeException("Column Dimension: " + n2 + ", is greater than Max Column Dimension: " + this.columnDimension + " in " + this.getParameterName());
        }
        this.rowDimension = n;
        this.columnDimension = n2;
        this.maxRow = n3;
        this.maxCol = n4;
        this.storedColumnDimension = n;
        this.storedColumnDimension = this.columnDimension;
        this.lowerTriangle = bl;
    }

    public void setRowDimension(int n) {
        int n2 = this.rowDimension;
        this.rowDimension = n;
        if (n > this.maxRow) {
            throw new RuntimeException("Row Dimension Larger Than Maximum");
        }
        if (n > n2) {
            this.fireParameterChangedEvent(-1, Variable.ChangeType.ADDED);
        } else {
            this.fireParameterChangedEvent(-1, Variable.ChangeType.REMOVED);
        }
    }

    public void setColumnDimension(int n) {
        int n2 = this.columnDimension;
        if (n > this.maxCol) {
            throw new RuntimeException("Column Dimension Larger Than Maximum");
        }
        this.columnDimension = n;
        if (n > n2) {
            this.fireParameterChangedEvent(-1, Variable.ChangeType.ADDED);
        } else {
            this.fireParameterChangedEvent(-1, Variable.ChangeType.REMOVED);
        }
    }

    @Override
    protected void storeValues() {
        super.storeValues();
        this.storedRowDimension = this.rowDimension;
        this.storedColumnDimension = this.columnDimension;
    }

    @Override
    protected void restoreValues() {
        super.restoreValues();
        this.rowDimension = this.storedRowDimension;
        this.columnDimension = this.storedColumnDimension;
    }

    @Override
    public int getRowDimension() {
        return this.rowDimension;
    }

    @Override
    public int getColumnDimension() {
        return this.columnDimension;
    }

    @Override
    public int getDimension() {
        return this.rowDimension * this.columnDimension;
    }

    public int getMaxRowDimension() {
        return this.maxRow;
    }

    public int getMaxColumnDimension() {
        return this.maxCol;
    }

    @Override
    public void setParameterValue(int n, double d) {
        int n2 = n % this.rowDimension;
        int n3 = n / this.rowDimension;
        if (n2 >= n3 || !this.lowerTriangle) {
            super.setParameterValueQuietly(n2, n3, d);
            this.fireParameterChangedEvent(n, Variable.ChangeType.VALUE_CHANGED);
        }
    }

    @Override
    public void setParameterValue(int n, int n2, double d) {
        if (n >= n2 || !this.lowerTriangle) {
            super.setParameterValueQuietly(n, n2, d);
            this.fireParameterChangedEvent(this.getRowDimension() * n2 + n, Variable.ChangeType.VALUE_CHANGED);
        }
    }

    @Override
    public void setParameterValueQuietly(int n, double d) {
        int n2 = n % this.rowDimension;
        int n3 = n / this.rowDimension;
        if (n2 >= n3 || !this.lowerTriangle) {
            super.setParameterValueQuietly(n2, n3, d);
        }
    }

    @Override
    public void setParameterValueQuietly(int n, int n2, double d) {
        if (n >= n2 || !this.lowerTriangle) {
            super.setParameterValueQuietly(n, n2, d);
        }
    }

    @Override
    public double getParameterValue(int n) {
        int n2 = n % this.rowDimension;
        int n3 = n / this.rowDimension;
        if (n2 >= n3 || !this.lowerTriangle) {
            return super.getParameterValue(n2, n3);
        }
        return 0.0;
    }

    @Override
    public double getParameterValue(int n, int n2) {
        if (n >= n2 || !this.lowerTriangle) {
            return super.getParameterValue(n, n2);
        }
        return 0.0;
    }

    @Override
    public double[] getParameterValues() {
        double[] dArray = new double[this.getDimension()];
        for (int i = 0; i < this.getDimension(); ++i) {
            dArray[i] = this.getParameterValue(i);
        }
        return dArray;
    }

    @Override
    public LogColumn[] getColumns() {
        LogColumn[] logColumnArray = new ASFMPColumn[]{new ASFMPColumn(this.getParameterName())};
        return logColumnArray;
    }

    private class ASFMPColumn
    extends NumberColumn {
        public ASFMPColumn(String string) {
            super(string);
        }

        @Override
        protected String getFormattedValue() {
            String string = "{";
            for (int i = 0; i < AdaptableSizeFastMatrixParameter.this.getRowDimension(); ++i) {
                string = string + " { ";
                for (int j = 0; j < AdaptableSizeFastMatrixParameter.this.getColumnDimension(); ++j) {
                    string = string + this.formatValue(AdaptableSizeFastMatrixParameter.this.getParameterValue(i, j));
                    if (j == AdaptableSizeFastMatrixParameter.this.getColumnDimension() - 1) continue;
                    string = string + ", ";
                }
                string = i == AdaptableSizeFastMatrixParameter.this.getRowDimension() - 1 ? string + " } " : string + " },";
            }
            string = string + "}";
            return string;
        }

        @Override
        public double getDoubleValue() {
            return 0.0;
        }
    }
}

