/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.loggers;

import java.io.Serializable;

public interface LogColumn
extends Serializable {
    public void setLabel(String var1);

    public String getLabel();

    public void setMinimumWidth(int var1);

    public int getMinimumWidth();

    public String getFormatted();

    public static class Default
    extends Abstract {
        private Object object;

        public Default(String string, Object object) {
            super(string);
            this.object = object;
        }

        @Override
        protected String getFormattedValue() {
            return this.object.toString();
        }
    }

    public static abstract class Abstract
    implements LogColumn {
        private String label;
        private int minimumWidth;

        public Abstract(String string) {
            this.setLabel(string);
            this.minimumWidth = -1;
        }

        @Override
        public void setLabel(String string) {
            if (string == null) {
                throw new IllegalArgumentException("column label is null");
            }
            this.label = string;
        }

        @Override
        public String getLabel() {
            StringBuffer stringBuffer = new StringBuffer(this.label);
            if (this.minimumWidth > 0) {
                while (stringBuffer.length() < this.minimumWidth) {
                    stringBuffer.append(' ');
                }
            }
            return stringBuffer.toString();
        }

        @Override
        public void setMinimumWidth(int n) {
            this.minimumWidth = n;
        }

        @Override
        public int getMinimumWidth() {
            return this.minimumWidth;
        }

        @Override
        public final String getFormatted() {
            StringBuffer stringBuffer = new StringBuffer(this.getFormattedValue());
            if (this.minimumWidth > 0) {
                while (stringBuffer.length() < this.minimumWidth) {
                    stringBuffer.append(' ');
                }
            }
            return stringBuffer.toString();
        }

        protected abstract String getFormattedValue();
    }
}

