/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.tree;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evomodel.tree.TreeTransform;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;

public class OuScalarTreeTransform
extends TreeTransform {
    private final Parameter alpha;

    public OuScalarTreeTransform(Parameter parameter) {
        super("OuScalarTreeTransform");
        parameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, 1));
        this.alpha = parameter;
        this.addVariable(parameter);
    }

    @Override
    public double transform(Tree tree, NodeRef nodeRef, double d) {
        if (this.getScaleForNode(tree, nodeRef) == 0.0) {
            return d;
        }
        if (tree.isExternal(nodeRef)) {
            return d;
        }
        double d2 = (1.0 - Math.exp(-2.0 * this.getScaleForNode(tree, nodeRef) * d)) / (2.0 * this.getScaleForNode(tree, nodeRef));
        double d3 = tree.getNodeHeight(tree.getRoot());
        double d4 = (1.0 - Math.exp(-2.0 * this.getScaleForNode(tree, nodeRef) * d3)) / (2.0 * this.getScaleForNode(tree, nodeRef));
        return d2 * (d3 / d4);
    }

    @Override
    protected double getScaleForNode(Tree tree, NodeRef nodeRef) {
        return this.alpha.getParameterValue(0);
    }

    @Override
    public String getInfo() {
        return "OU transform by " + this.alpha.getId();
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.fireModelChanged(this.alpha);
    }
}

