/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.speciation;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.util.Taxon;
import dr.evolution.util.Units;
import dr.evomodel.speciation.MaskableSpeciationModel;
import dr.evomodel.speciation.SpeciationModel;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.util.Author;
import dr.util.Citable;
import dr.util.Citation;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class BirthDeathSerialSamplingModel
extends MaskableSpeciationModel
implements Citable {
    Variable<Double> R0;
    Variable<Double> recoveryRate;
    Variable<Double> samplingProbability;
    Variable<Double> lambda;
    Variable<Double> mu;
    Variable<Double> psi;
    Variable<Double> p;
    boolean relativeDeath = false;
    Variable<Double> r;
    boolean hasFinalSample = false;
    Variable<Double> origin;
    BirthDeathSerialSamplingModel mask = null;

    public BirthDeathSerialSamplingModel(Variable<Double> variable, Variable<Double> variable2, Variable<Double> variable3, Variable<Double> variable4, boolean bl, Variable<Double> variable5, boolean bl2, Variable<Double> variable6, Units.Type type) {
        this("birthDeathSerialSamplingModel", variable, variable2, variable3, variable4, bl, variable5, bl2, variable6, type);
    }

    public BirthDeathSerialSamplingModel(String string, Variable<Double> variable, Variable<Double> variable2, Variable<Double> variable3, Variable<Double> variable4, boolean bl, Variable<Double> variable5, boolean bl2, Variable<Double> variable6, Units.Type type) {
        super(string, type);
        this.relativeDeath = bl;
        this.lambda = variable;
        this.addVariable(variable);
        variable.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        this.mu = variable2;
        this.addVariable(variable2);
        variable2.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        this.psi = variable3;
        this.addVariable(variable3);
        variable3.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        this.p = variable4;
        this.addVariable(variable4);
        variable4.addBounds(new Parameter.DefaultBounds(1.0, 0.0, 1));
        this.hasFinalSample = bl2;
        this.r = variable5;
        this.addVariable(variable5);
        variable5.addBounds(new Parameter.DefaultBounds(1.0, 0.0, 1));
        this.origin = variable6;
        if (variable6 != null) {
            this.addVariable(variable6);
            variable6.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        }
    }

    public BirthDeathSerialSamplingModel(String string, Variable<Double> variable, Variable<Double> variable2, Variable<Double> variable3, Variable<Double> variable4, Units.Type type) {
        super(string, type);
        this.relativeDeath = false;
        this.hasFinalSample = false;
        this.R0 = variable;
        this.addVariable(variable);
        variable.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        this.recoveryRate = variable2;
        this.addVariable(variable2);
        variable2.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        this.samplingProbability = variable3;
        this.addVariable(variable3);
        variable3.addBounds(new Parameter.DefaultBounds(1.0, 0.0, 1));
        this.origin = variable4;
        if (variable4 != null) {
            this.addVariable(variable4);
            variable4.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        }
    }

    public static double p0(double d, double d2, double d3, double d4, double d5) {
        double d6 = BirthDeathSerialSamplingModel.c1(d, d2, d4);
        double d7 = BirthDeathSerialSamplingModel.c2(d, d2, d3, d4);
        double d8 = Math.exp(-d6 * d5) * (1.0 - d7);
        return (d + d2 + d4 + d6 * ((d8 - (1.0 + d7)) / (d8 + (1.0 + d7)))) / (2.0 * d);
    }

    public static double q(double d, double d2, double d3, double d4, double d5) {
        double d6 = BirthDeathSerialSamplingModel.c1(d, d2, d4);
        double d7 = BirthDeathSerialSamplingModel.c2(d, d2, d3, d4);
        double d8 = d6 * d5 + 2.0 * Math.log(Math.exp(-d6 * d5) * (1.0 - d7) + (1.0 + d7));
        return d8;
    }

    private static double c1(double d, double d2, double d3) {
        return Math.abs(Math.sqrt(Math.pow(d - d2 - d3, 2.0) + 4.0 * d * d3));
    }

    private static double c2(double d, double d2, double d3, double d4) {
        return -(d - d2 - 2.0 * d * d3 - d4) / BirthDeathSerialSamplingModel.c1(d, d2, d4);
    }

    public double p0(double d) {
        return BirthDeathSerialSamplingModel.p0(this.birth(), this.death(), this.p(), this.psi(), d);
    }

    public double q(double d) {
        return BirthDeathSerialSamplingModel.q(this.birth(), this.death(), this.p(), this.psi(), d);
    }

    private double c1() {
        return BirthDeathSerialSamplingModel.c1(this.birth(), this.death(), this.psi());
    }

    private double c2() {
        return BirthDeathSerialSamplingModel.c2(this.birth(), this.death(), this.p(), this.psi());
    }

    public double birth() {
        if (this.mask != null) {
            return this.mask.birth();
        }
        if (this.lambda != null) {
            return this.lambda.getValue(0);
        }
        double d = this.R0.getValue(0);
        double d2 = this.recoveryRate.getValue(0);
        return d * d2;
    }

    public double death() {
        if (this.mask != null) {
            return this.mask.death();
        }
        if (this.mu != null) {
            return this.relativeDeath ? this.mu.getValue(0) * this.birth() : this.mu.getValue(0);
        }
        double d = this.recoveryRate.getValue(0);
        double d2 = this.samplingProbability.getValue(0);
        return d * (1.0 - d2);
    }

    public double psi() {
        if (this.mask != null) {
            return this.mask.psi();
        }
        if (this.psi != null) {
            return this.psi.getValue(0);
        }
        double d = this.recoveryRate.getValue(0);
        double d2 = this.samplingProbability.getValue(0);
        return d * d2;
    }

    public double p() {
        if (this.mask != null) {
            return this.mask.p.getValue(0);
        }
        return this.hasFinalSample ? this.p.getValue(0) : 0.0;
    }

    public boolean isSamplingOrigin() {
        return this.origin != null;
    }

    public double x0() {
        return this.origin.getValue(0);
    }

    @Override
    public final double calculateTreeLogLikelihood(Tree tree) {
        double d;
        int n;
        if (this.isSamplingOrigin() && this.x0() < tree.getNodeHeight(tree.getRoot())) {
            return Double.NEGATIVE_INFINITY;
        }
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < tree.getExternalNodeCount(); ++i) {
            NodeRef nodeRef = tree.getExternalNode(i);
            if (tree.getNodeHeight(nodeRef) == 0.0) {
                ++n2;
                continue;
            }
            ++n3;
        }
        if (!this.hasFinalSample && n2 < 1) {
            throw new RuntimeException("For sampling-through-time model there must be at least one tip at time zero.");
        }
        double d2 = this.birth();
        double d3 = this.p();
        if (!this.isSamplingOrigin()) {
            throw new RuntimeException("The origin must be sampled, as integrating it out is not implemented!");
        }
        double d4 = -this.q(this.x0());
        if (this.hasFinalSample) {
            d4 += (double)n2 * Math.log(4.0 * d3);
        }
        for (n = 0; n < tree.getInternalNodeCount(); ++n) {
            d = tree.getNodeHeight(tree.getInternalNode(n));
            d4 += Math.log(d2) - this.q(d);
        }
        for (n = 0; n < tree.getExternalNodeCount(); ++n) {
            d = tree.getNodeHeight(tree.getExternalNode(n));
            if (d > 0.0) {
                d4 += Math.log(this.psi()) + this.q(d);
                continue;
            }
            if (this.hasFinalSample) continue;
            d4 += Math.log(this.psi()) + this.q(d);
        }
        return d4;
    }

    @Override
    public double calculateTreeLogLikelihood(Tree tree, Set<Taxon> set) {
        if (set.size() == 0) {
            return this.calculateTreeLogLikelihood(tree);
        }
        throw new RuntimeException("Not implemented!");
    }

    @Override
    public void mask(SpeciationModel speciationModel) {
        if (!(speciationModel instanceof BirthDeathSerialSamplingModel)) {
            throw new IllegalArgumentException();
        }
        this.mask = (BirthDeathSerialSamplingModel)speciationModel;
    }

    @Override
    public void unmask() {
        this.mask = null;
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.TREE_PRIORS;
    }

    @Override
    public String getDescription() {
        return "Gernhard 2008 Birth Death Tree Model";
    }

    @Override
    public List<Citation> getCitations() {
        return Collections.singletonList(new Citation(new Author[]{new Author("T", "Gernhard")}, "The conditioned reconstructed process", 2008, "Journal of Theoretical Biology", 253, 769, 778, "10.1016/j.jtbi.2008.04.005"));
    }
}

