/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.operators;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeUtils;
import dr.evomodel.bigfasttree.thorney.ConstrainableTreeOperator;
import dr.evomodel.operators.AbstractTreeOperator;
import dr.evomodel.tree.TreeModel;
import dr.inference.operators.AdaptationMode;
import dr.math.MathUtils;
import dr.math.distributions.TDistribution;
import java.util.ArrayList;
import java.util.List;

public class SubtreeJumpOperator
extends AbstractTreeOperator
implements ConstrainableTreeOperator {
    private double size = 1.0;
    private double accP = 0.234;
    private boolean uniform = false;
    private final TreeModel tree;
    private final AdaptationMode mode;

    public SubtreeJumpOperator(TreeModel treeModel, double d, double d2, double d3, boolean bl, AdaptationMode adaptationMode) {
        this.tree = treeModel;
        this.setWeight(d);
        this.size = d2;
        this.accP = d3;
        this.uniform = bl;
        this.mode = adaptationMode;
    }

    @Override
    public double doOperation(TreeModel treeModel) {
        double d;
        Object object;
        double d2;
        int n;
        NodeRef nodeRef;
        NodeRef nodeRef2 = treeModel.getRoot();
        NodeRef nodeRef3 = null;
        NodeRef nodeRef4 = null;
        NodeRef nodeRef5 = null;
        List<NodeRef> list = null;
        while (nodeRef2 == (nodeRef = treeModel.getNode(MathUtils.nextInt(treeModel.getNodeCount()))) || treeModel.getParent(nodeRef) == nodeRef2) {
        }
        nodeRef3 = treeModel.getParent(nodeRef);
        nodeRef4 = this.getOtherChild(treeModel, nodeRef3, nodeRef);
        nodeRef5 = treeModel.getParent(nodeRef3);
        double d3 = treeModel.getNodeHeight(nodeRef3);
        list = this.getIntersectingEdges(treeModel, d3);
        if (list.size() == 0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (this.uniform) {
            n = MathUtils.nextInt(list.size());
            d2 = 1.0;
        } else {
            object = this.getDestinationProbabilities(treeModel, nodeRef3, d3, list, this.size);
            n = MathUtils.randomChoicePDF(object);
            d2 = object[n];
        }
        list.remove(nodeRef);
        list.remove(nodeRef4);
        object = list.get(n);
        NodeRef nodeRef6 = treeModel.getParent((NodeRef)object);
        treeModel.beginTreeEdit();
        treeModel.removeChild(nodeRef3, nodeRef4);
        treeModel.removeChild(nodeRef5, nodeRef3);
        treeModel.addChild(nodeRef5, nodeRef4);
        treeModel.removeChild(nodeRef6, (NodeRef)object);
        treeModel.addChild(nodeRef3, (NodeRef)object);
        treeModel.addChild(nodeRef6, nodeRef3);
        treeModel.endTreeEdit();
        if (this.uniform) {
            d = 0.0;
        } else {
            List<NodeRef> list2 = this.getIntersectingEdges(treeModel, d3);
            double d4 = this.getReverseProbability(treeModel, nodeRef4, (NodeRef)object, d3, list2, this.size);
            d = Math.log(d4) - Math.log(d2);
        }
        return d;
    }

    @Override
    public double doOperation() {
        return this.doOperation(this.tree);
    }

    private List<NodeRef> getIntersectingEdges(Tree tree, double d) {
        ArrayList<NodeRef> arrayList = new ArrayList<NodeRef>();
        for (int i = 0; i < tree.getNodeCount(); ++i) {
            NodeRef nodeRef = tree.getNode(i);
            NodeRef nodeRef2 = tree.getParent(nodeRef);
            if (nodeRef2 == null || !(tree.getNodeHeight(nodeRef) < d) || !(tree.getNodeHeight(nodeRef2) > d)) continue;
            arrayList.add(nodeRef);
        }
        return arrayList;
    }

    private double[] getDestinationProbabilities(Tree tree, NodeRef nodeRef, double d, List<NodeRef> list, double d2) {
        double[] dArray = new double[list.size()];
        this.getNormalizedProbabilities(tree, nodeRef, d, null, list, d2, dArray);
        return dArray;
    }

    private double getReverseProbability(Tree tree, NodeRef nodeRef, NodeRef nodeRef2, double d, List<NodeRef> list, double d2) {
        double[] dArray = new double[list.size()];
        int n = this.getNormalizedProbabilities(tree, nodeRef2, d, nodeRef, list, d2, dArray);
        return dArray[n];
    }

    private int getNormalizedProbabilities(Tree tree, NodeRef nodeRef, double d, NodeRef nodeRef2, List<NodeRef> list, double d2, double[] dArray) {
        double[] dArray2 = new double[list.size()];
        double[] dArray3 = new double[list.size()];
        int n = -1;
        int n2 = 0;
        for (NodeRef nodeRef3 : list) {
            assert (nodeRef3 != nodeRef);
            NodeRef nodeRef4 = TreeUtils.getCommonAncestor(tree, nodeRef, nodeRef3);
            dArray2[n2] = tree.getNodeHeight(nodeRef4) - d;
            dArray3[n2] = TDistribution.logPDF(dArray2[n2], 0.0, d2, 1.0);
            if (nodeRef3 == nodeRef2) {
                n = n2;
            }
            ++n2;
        }
        Object object = SubtreeJumpOperator.normLog(dArray, 1.0E-20);
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = (double)object[i];
        }
        return n;
    }

    public static double[] normLog(double[] dArray, double d) {
        double d22;
        double d3 = Double.NEGATIVE_INFINITY;
        for (double d22 : dArray) {
            d3 = Math.max(d22, d3);
        }
        double[] dArray2 = new double[dArray.length];
        double d4 = 0.0;
        d22 = Math.log(d) - Math.log(dArray.length);
        for (int i = 0; i < dArray2.length; ++i) {
            dArray2[i] = dArray[i] - d3 >= d22 ? Math.exp(dArray[i] - d3) : 0.0;
            d4 += dArray2[i];
        }
        double[] dArray3 = new double[dArray2.length];
        for (int i = 0; i < dArray3.length; ++i) {
            dArray3[i] = dArray2[i] / d4;
        }
        return dArray3;
    }

    public double getSize() {
        return this.size;
    }

    public void setSize(double d) {
        this.size = d;
    }

    public double getAdaptableParameter() {
        return Math.log(this.getSize());
    }

    public void setAdaptableParameter(double d) {
        this.setSize(Math.exp(d));
    }

    public double getRawParameter() {
        return this.getSize();
    }

    public AdaptationMode getMode() {
        return this.mode;
    }

    @Override
    public String getOperatorName() {
        return "subtreeJump(" + this.tree.getId() + ")";
    }
}

