/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.continuous;

import dr.evomodel.continuous.MultivariateDiffusionModel;
import dr.evomodel.continuous.TopographicalMap;
import dr.inference.model.Parameter;
import dr.math.MathUtils;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;

public class MapDiffusionModel
extends MultivariateDiffusionModel {
    public static final String MAP_DIFFUSION_MODEL = "mapDiffusionModel";
    public static final String GRASS_FILE_NAME = "grassMapFile";
    public static final String STARTING_VALUES = "randomStartingValues";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newStringRule("grassMapFile"), new ElementRule(Parameter.class)};

        @Override
        public String getParserName() {
            return MapDiffusionModel.MAP_DIFFUSION_MODEL;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            Object object;
            Object object2;
            Object object3;
            Parameter parameter = (Parameter)xMLObject.getChild(Parameter.class);
            String string = xMLObject.getStringAttribute(MapDiffusionModel.GRASS_FILE_NAME);
            try {
                object3 = new File(string);
                object2 = ((File)object3).getName();
                object = ((File)object3).getParent();
                if (!((File)object3).isAbsolute()) {
                    object = System.getProperty("user.dir");
                }
                File file = new File((String)object, (String)object2);
                new FileReader(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new XMLParseException("File '" + string + "' can not be opened for " + this.getParserName() + " element.");
            }
            try {
                object3 = TopographicalMap.readGRASSAscii(string);
            }
            catch (IOException iOException) {
                throw new XMLParseException("File '" + string + "' can not be read as GRASS file");
            }
            object2 = new TopographicalMap((double[][])object3);
            object = xMLObject.getChild(MapDiffusionModel.STARTING_VALUES);
            if (object != null) {
                System.err.println("Init");
                Parameter parameter2 = (Parameter)((XMLObject)object).getChild(Parameter.class);
                int n = parameter2.getDimension() / 2;
                int n2 = ((TopographicalMap)object2).getXDim();
                int n3 = ((TopographicalMap)object2).getYDim();
                for (int i = 0; i < n; ++i) {
                    int n4 = -1;
                    int n5 = -1;
                    while (((TopographicalMap)object2).getIndex(n4, n5) == -1) {
                        n4 = MathUtils.nextInt(n2);
                        n5 = MathUtils.nextInt(n3);
                        n4 = 0;
                        n5 = 100;
                    }
                    parameter2.setParameterValue(i * 2, n4);
                    parameter2.setParameterValue(i * 2 + 1, n5);
                    System.err.println("set: " + n4 + "," + n5);
                }
            }
            return new MapDiffusionModel((TopographicalMap)object2, parameter);
        }

        @Override
        public String getParserDescription() {
            return "Describes a multivariate discrete diffusion process.";
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public Class getReturnType() {
            return MapDiffusionModel.class;
        }
    };
    private final TopographicalMap map;
    private final Parameter graphRate;

    public MapDiffusionModel(TopographicalMap topographicalMap, Parameter parameter) {
        this.map = topographicalMap;
        this.graphRate = parameter;
        this.addVariable(parameter);
        this.initializationReport();
    }

    public TopographicalMap getMap() {
        return this.map;
    }

    private void initializationReport() {
        System.out.println("Constructing map diffusion model for");
        System.out.println("\tMap: " + this.map.getXDim() + "x" + this.map.getYDim());
        System.out.println("\tRandom-walk order: " + this.map.getOrder());
        System.out.println("\tRandom-walk non-zero size: " + this.map.getNonZeroSize());
        System.out.println("\tRate parameter: " + this.graphRate.getStatisticName());
    }

    @Override
    public double getLogLikelihood(double[] dArray, double[] dArray2, double d) {
        double d2 = Math.log(this.map.getCTMCProbability(dArray, dArray2, this.graphRate.getParameterValue(0) * d));
        return d2;
    }

    public void handleParameterChangedEvent(Parameter parameter, int n) {
    }
}

