/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.coalescent;

import dr.evolution.coalescent.ExponentialBSPGrowth;
import dr.evolution.tree.Tree;
import dr.evolution.util.Units;
import dr.evomodel.coalescent.OldAbstractCoalescentLikelihood;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.Parameter;
import dr.inference.model.Statistic;
import dr.math.MathUtils;
import java.util.Date;

@Deprecated
public class ExponentialSkythingLikelihood
extends OldAbstractCoalescentLikelihood {
    private final Parameter slopeParameter;
    private final Parameter popSizeParameter;
    private final Parameter groupSizeParameter;
    private final Parameter startingPopSize;
    private final int type;

    public ExponentialSkythingLikelihood(Tree tree, Parameter parameter, Parameter parameter2, int n) {
        super("generalizedSkyLineLikelihood");
        this.groupSizeParameter = new Parameter.Default(parameter.getDimension(), 1.0);
        this.popSizeParameter = new Parameter.Default(parameter.getDimension() - 1);
        this.slopeParameter = parameter;
        this.startingPopSize = parameter2;
        int n2 = tree.getExternalNodeCount() - 1;
        int n3 = parameter.getDimension();
        this.type = n;
        if (n3 != n2) {
            throw new IllegalArgumentException("There are more groups than coalescent nodes in the tree.");
        }
        this.tree = tree;
        if (tree instanceof TreeModel) {
            this.addModel((TreeModel)tree);
        }
        this.addVariable(parameter);
        this.setupIntervals();
        this.addStatistic(new GroupHeightStatistic());
    }

    @Override
    public double getLogLikelihood() {
        this.setupIntervals();
        double d = 0.0;
        double d2 = 0.0;
        int n = 0;
        int[] nArray = this.getGroupSizes();
        double[] dArray = this.getGroupHeights();
        int n2 = 0;
        ExponentialBSPGrowth exponentialBSPGrowth = new ExponentialBSPGrowth(Units.Type.YEARS);
        double d3 = 0.0;
        for (int i = this.intervalCount - 1; i >= 0; --i) {
            double d4 = i == this.intervalCount - 1 ? this.startingPopSize.getParameterValue(0) : d3;
            double d5 = d2;
            double d6 = d2 + this.intervals[i];
            d3 = d4 * Math.exp(this.slopeParameter.getParameterValue(i) * (d6 - d5));
            exponentialBSPGrowth.setupN1(d4, this.slopeParameter.getParameterValue(i), d6 - d5);
            if (this.getIntervalType(i) == OldAbstractCoalescentLikelihood.CoalescentEventType.COALESCENT && ++n2 >= nArray[n]) {
                ++n;
                n2 = 0;
            }
            d += ExponentialSkythingLikelihood.calculateIntervalLikelihood(exponentialBSPGrowth, this.intervals[i], d2, this.lineageCounts[i], this.getIntervalType(i));
            int n3 = this.getCoalescentEvents(i) - 1;
            for (int j = 0; j < n3; ++j) {
                exponentialBSPGrowth.setup(d3, d3, d6 - d5);
                d += ExponentialSkythingLikelihood.calculateIntervalLikelihood(exponentialBSPGrowth, 0.0, d2, this.lineageCounts[i] - j - 1, OldAbstractCoalescentLikelihood.CoalescentEventType.COALESCENT);
                if (++n2 < nArray[n]) continue;
                ++n;
                n2 = 0;
            }
            d2 += this.intervals[i];
        }
        return d;
    }

    public final double getPopSize(int n, double d, double[] dArray) {
        return this.popSizeParameter.getParameterValue(n);
    }

    public final int[] getGroupSizes() {
        if (this.groupSizeParameter.getParameterValue(0) < 2.0) {
            throw new IllegalArgumentException("For linear model first group size must be >= 2.");
        }
        int[] nArray = new int[this.groupSizeParameter.getDimension()];
        for (int i = 0; i < nArray.length; ++i) {
            double d = this.groupSizeParameter.getParameterValue(i);
            if (d != (double)Math.round(d)) {
                throw new RuntimeException("Group size " + i + " should be integer but found:" + d);
            }
            nArray[i] = (int)Math.round(d);
        }
        return nArray;
    }

    private int getGroupCount() {
        return this.groupSizeParameter.getDimension();
    }

    private int getGroupSize(int n) {
        double d = this.groupSizeParameter.getParameterValue(n);
        if (d != (double)Math.round(d)) {
            throw new RuntimeException("Group size " + n + " should be integer but found:" + d);
        }
        return (int)Math.round(d);
    }

    public final double[] getGroupHeights() {
        double[] dArray = new double[this.getGroupCount()];
        double d = 0.0;
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.intervalCount; ++i) {
            d += this.intervals[i];
            if (this.getIntervalType(i) != OldAbstractCoalescentLikelihood.CoalescentEventType.COALESCENT || ++n2 < this.getGroupSize(n)) continue;
            dArray[n] = d;
            ++n;
            n2 = 0;
        }
        dArray[this.getGroupCount() - 1] = d;
        return dArray;
    }

    private double getGroupHeight(int n) {
        return this.getGroupHeights()[n];
    }

    public final int getType() {
        return this.type;
    }

    public final Parameter getPopSizeParameter() {
        return this.popSizeParameter;
    }

    public final Parameter getGroupSizeParameter() {
        return this.groupSizeParameter;
    }

    public String getTitle() {
        String string = "Bayesian Skything (exponential)\nGenerated " + new Date().toString() + " [seed=" + MathUtils.getSeed() + "]";
        return string;
    }

    public class GroupHeightStatistic
    extends Statistic.Abstract {
        public GroupHeightStatistic() {
            super("groupHeight");
        }

        @Override
        public int getDimension() {
            return ExponentialSkythingLikelihood.this.getGroupCount();
        }

        @Override
        public double getStatisticValue(int n) {
            return ExponentialSkythingLikelihood.this.getGroupHeight(n);
        }
    }
}

