/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.coalescent;

import dr.evolution.coalescent.LogisticGrowth;
import dr.evolution.util.Units;

public class ExponentialLogistic
extends LogisticGrowth {
    private double time = 0.0;
    private double r1 = 0.0;

    public ExponentialLogistic(Units.Type type) {
        super(type);
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double d) {
        this.time = d;
    }

    public double getR1() {
        return this.r1;
    }

    public void setR1(double d) {
        this.r1 = d;
    }

    @Override
    public double getDemographic(double d) {
        double d2 = this.getTime();
        if (d < d2) {
            return super.getDemographic(d);
        }
        double d3 = this.getR1();
        double d4 = super.getDemographic(d2);
        return d4 * Math.exp(-d3 * (d - d2));
    }

    @Override
    public double getIntensity(double d) {
        throw new RuntimeException("Not implemented!");
    }

    @Override
    public double getInverseIntensity(double d) {
        throw new RuntimeException("Not implemented!");
    }

    @Override
    public double getIntegral(double d, double d2) {
        double d3 = this.getNumericalIntegral(d, d2);
        return d3;
    }

    @Override
    public int getNumArguments() {
        return 5;
    }

    @Override
    public String getArgumentName(int n) {
        switch (n) {
            case 0: {
                return "N0";
            }
            case 1: {
                return "r0";
            }
            case 2: {
                return "c";
            }
            case 3: {
                return "r1";
            }
            case 4: {
                return "t1";
            }
        }
        throw new IllegalArgumentException("Argument " + n + " does not exist");
    }

    @Override
    public double getArgument(int n) {
        switch (n) {
            case 0: {
                return this.getN0();
            }
            case 1: {
                return this.getGrowthRate();
            }
            case 2: {
                return this.getShape();
            }
            case 3: {
                return this.getR1();
            }
            case 4: {
                return this.getTime();
            }
        }
        throw new IllegalArgumentException("Argument " + n + " does not exist");
    }

    @Override
    public void setArgument(int n, double d) {
        switch (n) {
            case 0: {
                this.setN0(d);
                break;
            }
            case 1: {
                this.setGrowthRate(d);
                break;
            }
            case 2: {
                this.setShape(d);
                break;
            }
            case 3: {
                this.setR1(d);
                break;
            }
            case 4: {
                this.setTime(d);
                break;
            }
            default: {
                throw new IllegalArgumentException("Argument " + n + " does not exist");
            }
        }
    }

    @Override
    public double getLowerBound(int n) {
        return 0.0;
    }

    @Override
    public double getUpperBound(int n) {
        return Double.POSITIVE_INFINITY;
    }
}

