/*
 * Decompiled with CFR 0.152.
 */
package dmLab.geneticFramework;

import dmLab.geneticFramework.Parameter;
import java.util.ArrayList;
import java.util.Random;

public class Instance
implements Cloneable {
    public static int EXPLORATION = 1;
    public static int EXPLOITATION = 2;
    private Parameter[] params;
    private ArrayList<Parameter> paramsList;
    private Random rand;

    public Instance() {
        this.paramsList = new ArrayList();
        this.rand = new Random(System.currentTimeMillis());
    }

    public final void mutate(int type) {
        for (int i = 0; i < this.params.length; ++i) {
            if (this.rand.nextInt(this.params.length) != 0) continue;
            this.params[i].mutate(this.rand, type);
        }
    }

    public final int size() {
        if (this.params != null) {
            return this.params.length;
        }
        return 0;
    }

    public final void init() {
        if (this.paramsList != null) {
            Instance instance = this;
            Object[] objectArray = instance.paramsList.toArray();
            instance.params = new Parameter[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                instance.params[i] = (Parameter)objectArray[i];
            }
            instance.paramsList = null;
        }
        for (int i = 0; i < this.params.length; ++i) {
            this.params[i].init(this.rand);
        }
    }

    public Instance(Instance mother, Instance father) {
        this.rand = new Random(mother.rand.nextLong() + father.rand.nextLong());
        if (mother.size() != father.size()) {
            System.out.println("ERROR! Instances have different length of Params!");
        }
        this.params = new Parameter[mother.size()];
        double d = this.rand.nextGaussian() * 0.15 + 0.5;
        int cut = (int)(d * (double)mother.size());
        for (int i = 0; i < this.params.length; ++i) {
            this.params[i] = i <= cut ? mother.params[i].clone() : father.params[i].clone();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean add(Parameter p) {
        void var1_1;
        if (this.paramsList == null) {
            return false;
        }
        this.paramsList.add((Parameter)var1_1);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final Instance clone() {
        void var1_1;
        Instance instance = new Instance();
        new Instance().params = new Parameter[this.params.length];
        for (int j = 0; j < this.params.length; ++j) {
            instance.params[j] = this.params[j].clone();
        }
        instance.rand.setSeed(this.rand.nextLong());
        instance.paramsList = null;
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.params.length; ++i) {
            buf.append(this.params[i].toString() + "\n");
        }
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    public final Parameter getParamByIndex(int index) {
        void var1_1;
        if (this.params != null) {
            return this.params[index];
        }
        return this.paramsList.get((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void main(String[] args) {
        Instance instance = new Instance();
        instance.add(new Parameter("lag", 6.0f, 48.0f, false));
        instance.add(new Parameter("stopLossPower", 0.0f, 3.0f, false));
        instance.add(new Parameter("s1", 0.0f, 1.0f, false));
        instance.add(new Parameter("s2", 0.0f, 1.0f, false));
        instance.init();
        for (int i = 0; i < 10; ++i) {
            void var2_2;
            Instance i2 = instance.clone();
            i2.init();
            System.out.println(i2.toString());
            i2.mutate(EXPLORATION);
            System.out.println(var2_2.toString());
            System.out.println("");
        }
    }
}

