/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Range;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.UnsupervisedFilter;

public class NominalToString
extends Filter
implements UnsupervisedFilter,
OptionHandler {
    static final long serialVersionUID = 8655492378380068939L;
    private Range m_AttIndex = new Range("last");

    public String globalInfo() {
        return "Converts a nominal attribute (that is, one with a set number of values) to string (i.e. unspecified number of values).";
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    @Override
    public boolean setInputFormat(Instances instanceInfo) throws Exception {
        super.setInputFormat(instanceInfo);
        this.m_AttIndex.setUpper(instanceInfo.numAttributes() - 1);
        return false;
    }

    @Override
    public boolean input(Instance instance) {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if (this.isOutputFormatDefined()) {
            Instance newInstance = (Instance)instance.copy();
            this.push(newInstance);
            return true;
        }
        this.bufferInput(instance);
        return false;
    }

    @Override
    public boolean batchFinished() {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (!this.isOutputFormatDefined()) {
            this.setOutputFormat();
            int i = 0;
            while (i < this.getInputFormat().numInstances()) {
                this.push((Instance)this.getInputFormat().instance(i).copy());
                ++i;
            }
        }
        this.flushInput();
        this.m_NewBatch = true;
        return this.numPendingOutput() != 0;
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tSets the range of attributes to convert (default last).", "C", 1, "-C <col>"));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption('C', options);
        if (tmpStr.length() != 0) {
            this.setAttributeIndexes(tmpStr);
        } else {
            this.setAttributeIndexes("last");
        }
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-C");
        result.add(this.getAttributeIndexes());
        return result.toArray(new String[result.size()]);
    }

    public String attributeIndexesTipText() {
        return "Sets a range attributes to process. Any non-nominal attributes in the range are left untouched (\"first\" and \"last\" are valid values)";
    }

    public String getAttributeIndexes() {
        return this.m_AttIndex.getRanges();
    }

    public void setAttributeIndexes(String attIndex) {
        this.m_AttIndex.setRanges(attIndex);
    }

    private void setOutputFormat() {
        FastVector newAtts = new FastVector(this.getInputFormat().numAttributes());
        int j = 0;
        while (j < this.getInputFormat().numAttributes()) {
            Attribute att = this.getInputFormat().attribute(j);
            if (!att.isNominal() || !this.m_AttIndex.isInRange(j)) {
                newAtts.addElement(att);
            } else {
                Attribute newAtt = new Attribute(att.name(), null);
                newAtt.setWeight(this.getInputFormat().attribute(j).weight());
                newAtts.addElement(newAtt);
            }
            ++j;
        }
        Instances newData = new Instances(this.getInputFormat().relationName(), newAtts, 0);
        newData.setClassIndex(this.getInputFormat().classIndex());
        this.setOutputFormat(newData);
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8573 $");
    }

    public static void main(String[] args) {
        NominalToString.runFilter(new NominalToString(), args);
    }
}

