/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.rules;

import java.io.Serializable;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;

public class DecisionTableHashKey
implements Serializable,
RevisionHandler {
    static final long serialVersionUID = 5674163500154964602L;
    private double[] attributes;
    private boolean[] missing;
    private int key;

    public DecisionTableHashKey(Instance t, int numAtts, boolean ignoreClass) throws Exception {
        int cindex = t.classIndex();
        this.key = -999;
        this.attributes = new double[numAtts];
        this.missing = new boolean[numAtts];
        int i = 0;
        while (i < numAtts) {
            if (i == cindex && !ignoreClass) {
                this.missing[i] = true;
            } else {
                this.missing[i] = t.isMissing(i);
                if (!this.missing[i]) {
                    this.attributes[i] = t.value(i);
                }
            }
            ++i;
        }
    }

    public String toString(Instances t, int maxColWidth) {
        int cindex = t.classIndex();
        StringBuffer text = new StringBuffer();
        int i = 0;
        while (i < this.attributes.length) {
            if (i != cindex) {
                if (this.missing[i]) {
                    text.append("?");
                    int j = 0;
                    while (j < maxColWidth) {
                        text.append(" ");
                        ++j;
                    }
                } else {
                    String ss = t.attribute(i).value((int)this.attributes[i]);
                    StringBuffer sb = new StringBuffer(ss);
                    int j = 0;
                    while (j < maxColWidth - ss.length() + 1) {
                        sb.append(" ");
                        ++j;
                    }
                    text.append(sb);
                }
            }
            ++i;
        }
        return text.toString();
    }

    public DecisionTableHashKey(double[] t) {
        int l = t.length;
        this.key = -999;
        this.attributes = new double[l];
        this.missing = new boolean[l];
        int i = 0;
        while (i < l) {
            if (t[i] == Double.MAX_VALUE) {
                this.missing[i] = true;
            } else {
                this.missing[i] = false;
                this.attributes[i] = t[i];
            }
            ++i;
        }
    }

    public int hashCode() {
        int hv = 0;
        if (this.key != -999) {
            return this.key;
        }
        int i = 0;
        while (i < this.attributes.length) {
            hv = this.missing[i] ? (hv += i * 13) : (int)((double)hv + (double)(i * 5) * (this.attributes[i] + 1.0));
            ++i;
        }
        if (this.key == -999) {
            this.key = hv;
        }
        return hv;
    }

    public boolean equals(Object b) {
        if (b == null || !b.getClass().equals(this.getClass())) {
            return false;
        }
        boolean ok = true;
        if (b instanceof DecisionTableHashKey) {
            DecisionTableHashKey n = (DecisionTableHashKey)b;
            int i = 0;
            while (i < this.attributes.length) {
                boolean l = n.missing[i];
                if (this.missing[i] || l) {
                    if (this.missing[i] && !l || !this.missing[i] && l) {
                        ok = false;
                        break;
                    }
                } else if (this.attributes[i] != n.attributes[i]) {
                    ok = false;
                    break;
                }
                ++i;
            }
        } else {
            return false;
        }
        return ok;
    }

    public void print_hash_code() {
        System.out.println("Hash val: " + this.hashCode());
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.3 $");
    }
}

