/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.processing;

import java.util.Collections;
import java.util.List;
import jdplus.toolkit.base.api.processing.DummyLog;
import jdplus.toolkit.base.api.processing.NotImplementedLog;
import lombok.Generated;
import org.jspecify.annotations.Nullable;

public interface ProcessingLog {
    default public List<Information> all() {
        return Collections.emptyList();
    }

    default public void push(String routine) {
    }

    default public void pop() {
    }

    default public void error(Exception err) {
        this.error(null, err.getMessage(), null);
    }

    default public void error(String msg) {
        this.error(null, msg, null);
    }

    default public void error(String msg, Object detail) {
        this.error(null, msg, detail);
    }

    default public void error(String origin, Exception err) {
        this.error(origin, err.getMessage(), null);
    }

    default public void error(String origin, String msg, Object details) {
    }

    default public void warning(String msg) {
        this.warning(null, msg, null);
    }

    default public void warning(String msg, Object details) {
        this.warning(null, msg, details);
    }

    default public void warning(String origin, String msg) {
        this.warning(origin, msg, null);
    }

    default public void warning(String origin, String msg, Object details) {
    }

    default public void remark(String msg) {
        this.remark(null, msg, null);
    }

    default public void remark(String msg, Object details) {
        this.remark(null, msg, details);
    }

    default public void remark(String origin, String msg) {
        this.remark(origin, msg, null);
    }

    default public void remark(String origin, String msg, Object details) {
    }

    default public void info(String msg) {
        this.info(null, msg, null);
    }

    default public void info(String msg, Object details) {
        this.info(null, msg, details);
    }

    default public void info(String origin, String msg) {
        this.info(origin, msg, null);
    }

    default public void info(String origin, String msg, Object details) {
    }

    default public void step() {
        this.step(null, null);
    }

    default public void step(String msg) {
        this.step(msg, null);
    }

    default public void step(String msg, Object details) {
    }

    default public boolean isVerbose() {
        return true;
    }

    public static ProcessingLog dummy() {
        return DummyLog.DUMMY;
    }

    public static ProcessingLog notImplemented() {
        return NotImplementedLog.NOTIMPL;
    }

    public static final class Information {
        private final String name;
        private final String origin;
        private final String msg;
        private final InformationType type;
        private final Object details;

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.name).append(": ").append(this.msg);
            if (this.details != null) {
                builder.append('=').append(this.details.toString());
            }
            return builder.toString();
        }

        @Generated
        public Information(String name, String origin, String msg, InformationType type, Object details) {
            this.name = name;
            this.origin = origin;
            this.msg = msg;
            this.type = type;
            this.details = details;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getOrigin() {
            return this.origin;
        }

        @Generated
        public String getMsg() {
            return this.msg;
        }

        @Generated
        public InformationType getType() {
            return this.type;
        }

        @Generated
        public Object getDetails() {
            return this.details;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Information)) {
                return false;
            }
            Information other = (Information)o;
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$origin = this.getOrigin();
            String other$origin = other.getOrigin();
            if (this$origin == null ? other$origin != null : !this$origin.equals(other$origin)) {
                return false;
            }
            String this$msg = this.getMsg();
            String other$msg = other.getMsg();
            if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
                return false;
            }
            InformationType this$type = this.getType();
            InformationType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            Object this$details = this.getDetails();
            Object other$details = other.getDetails();
            return !(this$details == null ? other$details != null : !this$details.equals(other$details));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $origin = this.getOrigin();
            result = result * 59 + ($origin == null ? 43 : $origin.hashCode());
            String $msg = this.getMsg();
            result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
            InformationType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            Object $details = this.getDetails();
            result = result * 59 + ($details == null ? 43 : $details.hashCode());
            return result;
        }
    }

    public static enum InformationType {
        Error,
        Warning,
        Remark,
        Log,
        Step,
        Info;

    }
}

