/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math;

import jdplus.toolkit.base.api.math.Complex;
import jdplus.toolkit.base.api.math.ComplexType;
import jdplus.toolkit.base.core.math.ComplexComputer;
import lombok.Generated;

public final class ComplexMath {
    public static double absSquare(double x, double y) {
        return x * x + y * y;
    }

    public static Complex acos(ComplexType c) {
        double tmpi;
        double ci;
        double cr = c.getRe();
        double tmpr = 1.0 - (cr * cr - (ci = c.getIm()) * ci);
        double scale = ComplexType.abs((double)tmpr, (double)(tmpi = -2.0 * cr * ci));
        if (scale > 0.0) {
            if (tmpr > 0.0) {
                tmpr = Math.sqrt(0.5 * (scale + tmpr));
                tmpi = 0.5 * tmpi / tmpr;
            } else {
                double tmp = Math.sqrt(0.5 * (scale - tmpr));
                if (tmpi < 0.0) {
                    tmp = -tmp;
                }
                tmpr = 0.5 * tmpi / tmp;
                tmpi = tmp;
            }
        }
        double re = cr - tmpi;
        double im = ci + tmpr;
        return Complex.cart((double)ComplexType.arg((double)re, (double)im), (double)(-Math.log(ComplexType.abs((double)re, (double)im))));
    }

    public static Complex acosec(ComplexType c) {
        ComplexComputer tmp = new ComplexComputer(c);
        tmp.inv();
        return ComplexMath.asin((ComplexType)tmp.result());
    }

    public static Complex acosh(ComplexType c) {
        double tmpi;
        double ci;
        double cr = c.getRe();
        double tmpr = cr * cr - (ci = c.getIm()) * ci - 1.0;
        double scale = ComplexType.abs((double)tmpr, (double)(tmpi = 2.0 * cr * ci));
        if (scale > 0.0) {
            if (tmpr > 0.0) {
                tmpr = Math.sqrt(0.5 * (scale + tmpr));
                tmpi = 0.5 * tmpi / tmpr;
            } else {
                double tmp = Math.sqrt(0.5 * (scale - tmpr));
                if (tmpi < 0.0) {
                    tmp = -tmp;
                }
                tmpr = 0.5 * tmpi / tmp;
                tmpi = tmp;
            }
        }
        return ComplexMath.log(tmpr += cr, tmpi += ci);
    }

    public static Complex acot(ComplexType c) {
        double cr = c.getRe();
        double ci = c.getIm();
        ComplexComputer tmp = new ComplexComputer(-ci - 1.0, cr);
        tmp.div(1.0 - ci, cr);
        Complex ltmp = tmp.result();
        double re = ltmp.getRe();
        double im = ltmp.getIm();
        return Complex.cart((double)(0.5 * ComplexType.arg((double)re, (double)im)), (double)(-0.5 * Math.log(ComplexType.abs((double)re, (double)im))));
    }

    public static Complex acoth(ComplexType c) {
        double cr = c.getRe();
        double ci = c.getIm();
        ComplexComputer tmp = new ComplexComputer(cr + 1.0, ci);
        tmp.div(cr - 1.0, ci);
        return Complex.cart((double)(0.5 * Math.log(tmp.abs())), (double)(0.5 * tmp.arg()));
    }

    public static Complex asec(Complex c) {
        ComplexComputer tmp = new ComplexComputer((ComplexType)c);
        tmp.inv();
        return ComplexMath.acos((ComplexType)tmp.result());
    }

    public static Complex asin(ComplexType c) {
        double tmpi;
        double ci;
        double cr = c.getRe();
        double tmpr = 1.0 - (cr * cr - (ci = c.getIm()) * ci);
        double scale = ComplexType.abs((double)tmpr, (double)(tmpi = -2.0 * cr * ci));
        if (scale > 0.0) {
            if (tmpr > 0.0) {
                tmpr = Math.sqrt(0.5 * (scale + tmpr));
                tmpi = 0.5 * tmpi / tmpr;
            } else {
                double tmp = Math.sqrt(0.5 * (scale - tmpr));
                if (tmpi < 0.0) {
                    tmp = -tmp;
                }
                tmpr = 0.5 * tmpi / tmp;
                tmpi = tmp;
            }
        }
        return Complex.cart((double)ComplexType.arg((double)(tmpr -= ci), (double)(tmpi += cr)), (double)(-Math.log(ComplexType.abs((double)tmpr, (double)tmpi))));
    }

    public static Complex asinh(ComplexType c) {
        double tmpi;
        double ci;
        double cr = c.getRe();
        double tmpr = cr * cr - (ci = c.getIm()) * ci + 1.0;
        double scale = ComplexType.abs((double)tmpr, (double)(tmpi = 2.0 * cr * ci));
        if (scale > 0.0) {
            if (tmpr > 0.0) {
                tmpr = Math.sqrt(0.5 * (scale + tmpr));
                tmpi = 0.5 * tmpi / tmpr;
            } else {
                double tmp = Math.sqrt(0.5 * (scale - tmpr));
                if (tmpi < 0.0) {
                    tmp = -tmp;
                }
                tmpr = 0.5 * tmpi / tmp;
                tmpi = tmp;
            }
        }
        return ComplexMath.log(tmpr += cr, tmpi += ci);
    }

    public static Complex atan(ComplexType c) {
        double cr = c.getRe();
        double ci = c.getIm();
        ComplexComputer tmp = new ComplexComputer(-cr, 1.0 - ci);
        tmp.div(cr, 1.0 + ci);
        Complex ltmp = tmp.result();
        double re = ltmp.getRe();
        double im = ltmp.getIm();
        return Complex.cart((double)(0.5 * ComplexType.arg((double)re, (double)im)), (double)(-0.5 * Math.log(ComplexType.abs((double)re, (double)im))));
    }

    public static Complex atanh(ComplexType c) {
        double cr = c.getRe();
        double ci = c.getIm();
        ComplexComputer tmp = new ComplexComputer(cr + 1.0, ci);
        tmp.div(1.0 - cr, -ci);
        return Complex.cart((double)(0.5 * Math.log(tmp.abs())), (double)(0.5 * tmp.arg()));
    }

    public static Complex cos(ComplexType c) {
        double ric = -c.getIm();
        double iic = c.getRe();
        double scalar = Math.exp(ric);
        double ciic = Math.cos(iic);
        double siic = Math.sin(iic);
        double re1 = scalar * ciic;
        double im1 = scalar * siic;
        scalar = Math.exp(-ric);
        double re2 = scalar * ciic;
        double im2 = scalar * -siic;
        return Complex.cart((double)(0.5 * (re1 + re2)), (double)(0.5 * (im1 + im2)));
    }

    public static Complex cosec(ComplexType c) {
        ComplexComputer builder = new ComplexComputer((ComplexType)ComplexMath.sin(c));
        builder.inv();
        return builder.result();
    }

    public static Complex cosh(ComplexType c) {
        double rc = c.getRe();
        double ic = c.getIm();
        double scalar = Math.exp(rc);
        double cic = Math.cos(ic);
        double sic = Math.sin(ic);
        double re1 = scalar * cic;
        double im1 = scalar * sic;
        scalar = Math.exp(-rc);
        double re2 = scalar * cic;
        double im2 = scalar * -sic;
        return Complex.cart((double)(0.5 * (re1 + re2)), (double)(0.5 * (im1 + im2)));
    }

    public static Complex cot(ComplexType c) {
        double ric = -c.getIm();
        double iic = c.getRe();
        double scalar = Math.exp(ric);
        double ciic = Math.cos(iic);
        double siic = Math.sin(iic);
        double re1 = scalar * ciic;
        double im1 = scalar * siic;
        scalar = Math.exp(-ric);
        double re2 = scalar * ciic;
        double im2 = scalar * -siic;
        ComplexComputer result = new ComplexComputer(0.5 * (re1 + re2), 0.5 * (im1 + im2));
        result.div(0.5 * (im1 - im2), -0.5 * (re1 - re2));
        return result.result();
    }

    public static Complex coth(ComplexType c) {
        double rc = c.getRe();
        double ic = c.getIm();
        double scalar = Math.exp(rc);
        double cic = Math.cos(ic);
        double sic = Math.sin(ic);
        double re1 = scalar * cic;
        double im1 = scalar * sic;
        scalar = Math.exp(-rc);
        double re2 = scalar * cic;
        double im2 = scalar * -sic;
        ComplexComputer result = new ComplexComputer(re1 + re2, im1 + im2);
        result.div(re1 - re2, im1 - im2);
        return result.result();
    }

    public static Complex exp(ComplexType c) {
        return ComplexMath.exp(c.getRe(), c.getIm());
    }

    static Complex exp(double a, double b) {
        double scalar = Math.exp(a);
        return Complex.cart((double)(scalar * Math.cos(b)), (double)(scalar * Math.sin(b)));
    }

    public static Complex log(ComplexType c) {
        return Complex.cart((double)Math.log(c.abs()), (double)c.arg());
    }

    static Complex log(double re, double im) {
        return Complex.cart((double)Math.log(ComplexType.abs((double)re, (double)im)), (double)ComplexType.arg((double)re, (double)im));
    }

    public static Complex pow(ComplexType c, ComplexType exponent) {
        double re = Math.log(c.abs());
        double im = c.arg();
        double rtmp = re * exponent.getRe() - im * exponent.getIm();
        double itmp = re * exponent.getIm() + im * exponent.getRe();
        double scalar = Math.exp(rtmp);
        return Complex.cart((double)(scalar * Math.cos(itmp)), (double)(scalar * Math.sin(itmp)));
    }

    public static Complex pow(ComplexType c, double exponent) {
        double re = exponent * Math.log(c.abs());
        double im = exponent * c.arg();
        double scalar = Math.exp(re);
        return Complex.cart((double)(scalar * Math.cos(im)), (double)(scalar * Math.sin(im)));
    }

    public static Complex sec(ComplexType c) {
        ComplexComputer builder = new ComplexComputer((ComplexType)ComplexMath.cos(c));
        builder.inv();
        return builder.result();
    }

    public static Complex sin(ComplexType c) {
        double ric = -c.getIm();
        double iic = c.getRe();
        double scalar = Math.exp(ric);
        double ciic = Math.cos(iic);
        double siic = Math.sin(iic);
        double re1 = scalar * ciic;
        double im1 = scalar * siic;
        scalar = Math.exp(-ric);
        double re2 = scalar * ciic;
        double im2 = scalar * -siic;
        return Complex.cart((double)(0.5 * (im1 - im2)), (double)(-0.5 * (re1 - re2)));
    }

    public static Complex sinh(ComplexType c) {
        double rc = c.getRe();
        double ic = c.getIm();
        double scalar = Math.exp(rc);
        double cic = Math.cos(ic);
        double sic = Math.sin(ic);
        double re1 = scalar * cic;
        double im1 = scalar * sic;
        scalar = Math.exp(-rc);
        double re2 = scalar * cic;
        double im2 = scalar * -sic;
        return Complex.cart((double)(0.5 * (re1 - re2)), (double)(0.5 * (im1 - im2)));
    }

    public static Complex sqrt(ComplexType c) {
        return ComplexMath.sqrt(c.getRe(), c.getIm());
    }

    static Complex sqrt(double re, double im) {
        double scale = ComplexType.abs((double)re, (double)im);
        if (scale > 0.0) {
            if (re > 0.0) {
                double tmp = Math.sqrt(0.5 * (scale + re));
                return Complex.cart((double)tmp, (double)(0.5 * im / tmp));
            }
            double tmp = Math.sqrt(0.5 * (scale - re));
            if (im < 0.0) {
                tmp = -tmp;
            }
            return Complex.cart((double)(0.5 * im / tmp), (double)tmp);
        }
        return Complex.ZERO;
    }

    public static Complex tan(ComplexType c) {
        double ric = -c.getIm();
        double iic = c.getRe();
        double scalar = Math.exp(ric);
        double ciic = Math.cos(iic);
        double siic = Math.sin(iic);
        double re1 = scalar * ciic;
        double im1 = scalar * siic;
        scalar = Math.exp(-ric);
        double re2 = scalar * ciic;
        double im2 = scalar * -siic;
        ComplexComputer result = new ComplexComputer(0.5 * (im1 - im2), -0.5 * (re1 - re2));
        result.div(0.5 * (re1 + re2), 0.5 * (im1 + im2));
        return result.result();
    }

    public static Complex tanh(ComplexType c) {
        double rc = c.getRe();
        double ic = c.getIm();
        double scalar = Math.exp(rc);
        double cic = Math.cos(ic);
        double sic = Math.sin(ic);
        double re1 = scalar * cic;
        double im1 = scalar * sic;
        scalar = Math.exp(-rc);
        double re2 = scalar * cic;
        double im2 = scalar * -sic;
        ComplexComputer result = new ComplexComputer(re1 - re2, im1 - im2);
        result.div(re1 + re2, im1 + im2);
        return result.result();
    }

    @Generated
    private ComplexMath() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

