# checkCLI: CLI Messages for Checkmate Assertions and Checks

**Title:** cli messages for checkmate assertions and checks

**Description:** Providing more beautiful and more meaningful return messages for checkmate assertions and checks helping users to better understand errors.

---

## Overview

`checkCLI` is an R package that enhances the [checkmate](https://mllg.github.io/checkmate/) package by providing more informative and visually appealing error messages using the [cli](https://cli.r-lib.org/) package. Instead of cryptic error messages, users receive clear, formatted, and contextual feedback when assertions fail.

The package wraps all major checkmate assertion and check functions with CLI-enhanced versions, automatically generating beautiful, colored error messages that help developers and users understand exactly what went wrong with their data validation.

---

## Features

- **Enhanced Error Messages:** Converts raw checkmate error messages into formatted, readable CLI messages
- **Comprehensive Coverage:** Wraps all major checkmate assertion and check functions
- **Easy Integration:** Drop-in replacements for standard checkmate functions with `_cli` suffix
- **Beautiful Formatting:** Leverages the `cli` package for colored, bullet-pointed error output
- **Flexible Error Handling:** Supports both immediate errors and error collection for batch validation
- **Character Escaping:** Safely handles special characters in error messages

---

## Installation

```r
# Install from GitHub
devtools::install_github("luizesser/checkCLI")
```


---

## Troubleshooting

### No colored output in terminal
The `cli` package respects terminal capabilities. Some terminals may not support colors. This is normal and messages will still display correctly.

### Special characters in error messages
The package automatically escapes special characters (braces) to prevent formatting issues. Manual escaping is not needed.

### AssertCollection errors
Ensure you're using `checkmate::AssertCollection$new()` to create collection objects before passing to the `add` parameter.

---

## Contributing

Contributions are welcome! Please ensure that:
- All `checkmate` check functions have corresponding `_cli` wrapped versions
- Error messages remain clear and actionable
- Documentation is updated with new functions
- Tests cover new functionality

---

## See Also

- [checkmate](https://github.com/mllg/checkmate) - R package for argument checking
- [cli](https://cli.r-lib.org/) - Helpers for developing command line interfaces

---

**Questions or Issues?** Please open an issue on GitHub or contact the package maintainer.
