## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  eval = FALSE
)

## ----setup--------------------------------------------------------------------
# library(bracketeer)

## ----teams--------------------------------------------------------------------
# teams <- c(
#   "Gen.G",        "T1",          "Hanwha Life", "Dplus KIA",
#   "BLG",          "TES",         "LNG",         "JDG",
#   "G2",           "Fnatic",      "MAD Lions",   "BDS",
#   "Cloud9",       "Team Liquid",  "FlyQuest",    "100 Thieves"
# )
# 
# length(teams)

## ----define-------------------------------------------------------------------
# trn <- tournament(teams) |>
#   swiss("open", rounds = 5) |>
#   single_elim("top_cut", take = top_n(8))

## ----spec-path----------------------------------------------------------------
# worlds_spec <- spec() |>
#   swiss("open", rounds = 5) |>
#   single_elim("top_cut", take = top_n(8))
# 
# validate(worlds_spec, n = 16)   # passes
# 
# # Build for this year's entrants
# trn <- worlds_spec |> build(teams)

## ----swiss-schedule-----------------------------------------------------------
# stage_status(trn)
# 
# open_ms <- matches(trn, "open")
# nrow(open_ms)   # 5 rounds × 8 matches = 40 matches
# head(open_ms)

## ----enter-swiss--------------------------------------------------------------
# for (i in seq_len(nrow(open_ms))) {
#   trn <- trn |> result("open", match = open_ms$id[i], score = c(1, 0))
# 
#   # Refresh pending matches — Swiss generates each round dynamically.
#   open_ms <- matches(trn, "open")
# }

## ----post-swiss---------------------------------------------------------------
# stage_status(trn)
# #   stage     status     complete  total  materialized
# #   open      complete         40     40          TRUE
# #   top_cut   active            0      7          TRUE
# 
# standings(trn, "open")   # full Swiss standings, 1st through 16th
# matches(trn, "top_cut")  # 8-team bracket

## ----run-top-cut--------------------------------------------------------------
# cut_ms <- matches(trn, "top_cut")
# 
# for (i in seq_len(nrow(cut_ms))) {
#   trn <- trn |> result("top_cut", match = cut_ms$id[i], score = c(1, 0))
# }

## ----outcomes-----------------------------------------------------------------
# winner(trn)
# rankings(trn)
# routing_log(trn)

## ----manual-------------------------------------------------------------------
# trn <- tournament(teams, auto_advance = FALSE) |>
#   swiss("open", rounds = 5) |>
#   single_elim("top_cut", take = top_n(8))
# 
# # ... enter all Swiss results ...
# 
# # Stage does not advance until you say so:
# trn <- trn |> advance("open")

## ----batch--------------------------------------------------------------------
# round1 <- data.frame(
#   match  = matches(trn, "open")$id,
#   score1 = rep(1L, 8),
#   score2 = rep(0L, 8)
# )
# 
# trn <- trn |> results("open", round1)

