## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup, include=FALSE-----------------------------------------------------
library(boostmath)

## -----------------------------------------------------------------------------
# Trapezoidal rule integration of sin(x) from 0 to pi
trapezoidal(sin, 0, pi)

## -----------------------------------------------------------------------------
# Gauss-Legendre integration of exp(x) from 0 to 1
gauss_legendre(exp, 0, 1, points = 7)

## -----------------------------------------------------------------------------
# Adaptive Gauss-Kronrod integration of log(x) from 1 to 2
gauss_kronrod(log, 1, 2, points = 15, max_depth = 10)

# Non-adaptive Gauss-Kronrod integration of log(x) from 1 to 2
gauss_kronrod(log, 1, 2, points = 15, max_depth = 0)

## -----------------------------------------------------------------------------
# Tanh-sinh quadrature of log(x) from 0 to 1
tanh_sinh(function(x) { log(x) * log1p(-x) }, a = 0, b = 1)
# Sinh-sinh quadrature of exp(-x^2)
sinh_sinh(function(x) { exp(-x * x) })
# Exp-sinh quadrature of exp(-3*x) from 0 to Inf
exp_sinh(function(x) { exp(-3 * x) }, a = 0, b = Inf)

## -----------------------------------------------------------------------------
# Fourier sine integral of sin(x) with omega = 1
# ooura_fourier_sin(function(x) { 1 / x }, omega = 1)
# Fourier cosine integral of cos(x) with omega = 1
# ooura_fourier_cos(function(x) { 1/ (x * x + 1) }, omega = 1)

## -----------------------------------------------------------------------------
# Finite difference derivative of sin(x) at pi/4
finite_difference_derivative(sin, pi / 4)
# Complex step derivative of exp(x) at 1.7
complex_step_derivative(exp, 1.7)

