/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.dig;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.dig.DIGAdapter;
import com.hp.hpl.jena.reasoner.dig.DIGConnection;
import com.hp.hpl.jena.reasoner.dig.DIGQueryTranslator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.WrappedIterator;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DIGQueryDifferentFromTranslator
extends DIGQueryTranslator {
    public DIGQueryDifferentFromTranslator(String predicate) {
        super(null, predicate, null);
    }

    public Document translatePattern(TriplePattern pattern, DIGAdapter da) {
        DIGConnection dc = da.getConnection();
        Document query2 = dc.createDigVerb("asks", da.getProfile());
        Element disjoint = da.createQueryElement(query2, "disjoint");
        Element ind = da.addElement(disjoint, "iset");
        da.addNamedElement(ind, "individual", da.getNodeID(pattern.getSubject()));
        ind = da.addElement(disjoint, "iset");
        da.addNamedElement(ind, "individual", da.getNodeID(pattern.getObject()));
        return query2;
    }

    public ExtendedIterator translateResponseHook(Document response, TriplePattern query2, DIGAdapter da) {
        ArrayList<Triple> answer = new ArrayList<Triple>();
        if (this.isTrue(response)) {
            answer.add(query2.asTriple());
        }
        return WrappedIterator.create(answer.iterator());
    }

    public Document translatePattern(TriplePattern pattern, DIGAdapter da, Model premises) {
        return this.translatePattern(pattern, da);
    }

    public boolean checkSubject(Node subject, DIGAdapter da, Model premises) {
        return da.isIndividual(subject);
    }

    public boolean checkObject(Node object, DIGAdapter da, Model premises) {
        return da.isIndividual(object);
    }
}

