/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.sql;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import weka.gui.JTableHelper;
import weka.gui.sql.QueryPanel;
import weka.gui.sql.ResultSetTable;
import weka.gui.sql.ResultSetTableModel;
import weka.gui.sql.event.QueryExecuteEvent;
import weka.gui.sql.event.QueryExecuteListener;
import weka.gui.sql.event.ResultChangedEvent;
import weka.gui.sql.event.ResultChangedListener;

public class ResultPanel
extends JPanel
implements QueryExecuteListener,
ChangeListener {
    protected JFrame m_Parent;
    protected HashSet m_Listeners;
    protected QueryPanel m_QueryPanel;
    protected JTabbedPane m_TabbedPane;
    protected JButton m_ButtonClose = new JButton("Close");
    protected JButton m_ButtonCloseAll = new JButton("Close all");
    protected JButton m_ButtonCopyQuery = new JButton("Re-use query");
    protected JButton m_ButtonOptWidth = new JButton("Optimal width");
    protected int m_NameCounter;

    public ResultPanel(JFrame jFrame) {
        this.m_Parent = jFrame;
        this.m_QueryPanel = null;
        this.m_NameCounter = 0;
        this.m_Listeners = new HashSet();
        this.createPanel();
    }

    protected void createPanel() {
        this.setLayout(new BorderLayout());
        this.m_TabbedPane = new JTabbedPane(3);
        this.m_TabbedPane.addChangeListener(this);
        this.add((Component)this.m_TabbedPane, "Center");
        JPanel jPanel = new JPanel(new BorderLayout());
        this.add((Component)jPanel, "East");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel.add((Component)jPanel2, "Center");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel3, "Center");
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel3.add((Component)jPanel4, "Center");
        this.m_ButtonClose.setMnemonic('l');
        this.m_ButtonClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResultPanel.this.close();
            }
        });
        jPanel.add((Component)this.m_ButtonClose, "North");
        this.m_ButtonCloseAll.setMnemonic('a');
        this.m_ButtonCloseAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResultPanel.this.closeAll();
            }
        });
        jPanel2.add((Component)this.m_ButtonCloseAll, "North");
        this.m_ButtonCopyQuery.setMnemonic('Q');
        this.m_ButtonCopyQuery.setToolTipText("Copies the query of the currently selected tab into the query field.");
        this.m_ButtonCopyQuery.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResultPanel.this.copyQuery();
            }
        });
        jPanel3.add((Component)this.m_ButtonCopyQuery, "North");
        this.m_ButtonOptWidth.setMnemonic('p');
        this.m_ButtonOptWidth.setToolTipText("Calculates the optimal column width for the current table.");
        this.m_ButtonOptWidth.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResultPanel.this.calcOptimalWidth();
            }
        });
        jPanel4.add((Component)this.m_ButtonOptWidth, "North");
        jPanel4.add((Component)new JLabel(" "), "Center");
        jPanel4.add((Component)new JLabel(" "), "South");
        this.setButtons();
    }

    public void clear() {
        this.closeAll();
    }

    public void setFocus() {
        this.m_TabbedPane.requestFocus();
    }

    protected void setButtons() {
        int n = this.m_TabbedPane.getSelectedIndex();
        this.m_ButtonClose.setEnabled(n > -1);
        this.m_ButtonCloseAll.setEnabled(this.m_TabbedPane.getTabCount() > 0);
        this.m_ButtonCopyQuery.setEnabled(n > -1);
        this.m_ButtonOptWidth.setEnabled(n > -1);
    }

    protected String getNextTabName() {
        ++this.m_NameCounter;
        return "Query" + this.m_NameCounter;
    }

    public void queryExecuted(QueryExecuteEvent queryExecuteEvent) {
        if (queryExecuteEvent.failed()) {
            return;
        }
        if (!queryExecuteEvent.hasResult()) {
            return;
        }
        try {
            ResultSetTable resultSetTable = new ResultSetTable(queryExecuteEvent.getDbUtils().getDatabaseURL(), queryExecuteEvent.getDbUtils().getUsername(), queryExecuteEvent.getDbUtils().getPassword(), queryExecuteEvent.getQuery(), new ResultSetTableModel(queryExecuteEvent.getResultSet(), queryExecuteEvent.getMaxRows()));
            this.m_TabbedPane.addTab(this.getNextTabName(), new JScrollPane(resultSetTable));
            this.m_TabbedPane.setSelectedIndex(this.m_TabbedPane.getTabCount() - 1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setButtons();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.setButtons();
        if (this.getCurrentTable() != null) {
            this.notifyListeners(this.getCurrentTable().getURL(), this.getCurrentTable().getUser(), this.getCurrentTable().getPassword(), this.getCurrentTable().getQuery());
        }
    }

    public QueryPanel getQueryPanel() {
        return this.m_QueryPanel;
    }

    public void setQueryPanel(QueryPanel queryPanel) {
        this.m_QueryPanel = queryPanel;
    }

    protected ResultSetTable getCurrentTable() {
        ResultSetTable resultSetTable = null;
        int n = this.m_TabbedPane.getSelectedIndex();
        if (n > -1) {
            JScrollPane jScrollPane = (JScrollPane)this.m_TabbedPane.getComponentAt(n);
            JViewport jViewport = (JViewport)jScrollPane.getComponent(0);
            resultSetTable = (ResultSetTable)jViewport.getComponent(0);
        }
        return resultSetTable;
    }

    protected void close() {
        int n = this.m_TabbedPane.getSelectedIndex();
        if (n > -1) {
            try {
                this.getCurrentTable().finalize();
            }
            catch (Throwable throwable) {
                System.out.println(throwable);
            }
            this.m_TabbedPane.removeTabAt(n);
        }
        this.setButtons();
    }

    protected void closeAll() {
        while (this.m_TabbedPane.getTabCount() > 0) {
            this.m_TabbedPane.setSelectedIndex(0);
            try {
                this.getCurrentTable().finalize();
            }
            catch (Throwable throwable) {
                System.out.println(throwable);
            }
            this.m_TabbedPane.removeTabAt(0);
        }
        this.setButtons();
    }

    protected void copyQuery() {
        if (this.getCurrentTable() != null && this.getQueryPanel() != null) {
            this.getQueryPanel().setQuery(this.getCurrentTable().getQuery());
        }
    }

    protected void calcOptimalWidth() {
        if (this.getCurrentTable() != null) {
            JTableHelper.setOptimalColumnWidth(this.getCurrentTable());
        }
    }

    public void addResultChangedListener(ResultChangedListener resultChangedListener) {
        this.m_Listeners.add(resultChangedListener);
    }

    public void removeResultChangedListener(ResultChangedListener resultChangedListener) {
        this.m_Listeners.remove(resultChangedListener);
    }

    protected void notifyListeners(String string, String string2, String string3, String string4) {
        for (ResultChangedListener resultChangedListener : this.m_Listeners) {
            resultChangedListener.resultChanged(new ResultChangedEvent(this, string, string2, string3, string4));
        }
    }
}

