/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.algorithm;

import ec.tstoolkit.algorithm.IProcessing;
import ec.tstoolkit.algorithm.MultiTsData;
import ec.tstoolkit.timeseries.PeriodSelectorType;
import ec.tstoolkit.timeseries.TsPeriodSelector;
import ec.tstoolkit.timeseries.simplets.TsData;

public class MultiTsDataProcessing
implements IProcessing<TsData[], MultiTsData> {
    public static final String SERIES = "series";
    private final TsPeriodSelector selector_;
    private Validation validation;

    @Override
    public MultiTsData process(TsData[] input) {
        int i;
        TsData[] minput;
        if (this.selector_ == null || this.selector_.getType() == PeriodSelectorType.All) {
            minput = input;
        } else {
            minput = new TsData[input.length];
            for (i = 0; i < minput.length; ++i) {
                minput[i] = input[i].select(this.selector_);
            }
        }
        if (this.validation != null) {
            for (i = 0; i < minput.length; ++i) {
                if (this.validation.validate(minput)) continue;
                return null;
            }
        }
        return new MultiTsData(SERIES, minput);
    }

    public MultiTsDataProcessing(TsPeriodSelector sel) {
        this.selector_ = sel;
    }

    public void setValidation(Validation val) {
        this.validation = val;
    }

    public Validation getValidation() {
        return this.validation;
    }

    public static interface Validation {
        public boolean validate(TsData[] var1);
    }
}

