/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.circe.check.checkers;

import java.util.Objects;
import org.ohdsi.circe.check.WarningSeverity;
import org.ohdsi.circe.check.checkers.BaseCheck;
import org.ohdsi.circe.check.checkers.WarningReporter;
import org.ohdsi.circe.check.operations.Operations;
import org.ohdsi.circe.cohortdefinition.CohortExpression;

public class NoExitCriteriaCheck
extends BaseCheck {
    private static final String NO_EXIT_CRITERIA_WARNING = " \"all events\" are selected and cohort exit criteria has not been specified";

    @Override
    protected WarningSeverity defineSeverity() {
        return WarningSeverity.WARNING;
    }

    @Override
    protected void check(CohortExpression expression, WarningReporter reporter) {
        Operations.match(expression).when(e -> "All".equalsIgnoreCase(e.primaryCriteria.primaryLimit.type) && Objects.isNull(e.endStrategy) && "All".equalsIgnoreCase(e.expressionLimit.type) && (Objects.isNull(e.additionalCriteria) || "All".equalsIgnoreCase(e.qualifiedLimit.type))).then(() -> reporter.add(NO_EXIT_CRITERIA_WARNING, new Object[0]));
    }
}

