/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import beagleutil.Samples;
import java.util.Arrays;
import vcf.Marker;
import vcf.VcfEmission;

public final class LowMafRefGT
implements VcfEmission {
    private final Marker marker;
    private final Samples samples;
    private final int nHaps;
    private final int[][] hapIndices;
    private final int majorAllele;

    public LowMafRefGT(Marker marker, Samples samples, int[][] nArray) {
        int[][] nArray2 = LowMafRefGT.copyAndSortIndices(nArray);
        LowMafRefGT.checkSortedIndices(marker, samples, nArray2);
        this.marker = marker;
        this.samples = samples;
        this.nHaps = 2 * samples.nSamples();
        this.hapIndices = nArray2;
        int n = -1;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray2[i] != null) continue;
            n = i;
            break;
        }
        assert (n != -1);
        this.majorAllele = n;
    }

    private static int[][] copyAndSortIndices(int[][] nArray) {
        int[][] nArrayArray = new int[nArray.length][];
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == null) continue;
            nArrayArray[i] = (int[])nArray[i].clone();
            Arrays.sort(nArrayArray[i]);
        }
        return nArrayArray;
    }

    private static void checkSortedIndices(Marker marker, Samples samples, int[][] nArray) {
        if (marker.nAlleles() != nArray.length) {
            throw new IllegalArgumentException("ERROR: inconsistent data");
        }
        int n = 2 * samples.nSamples();
        LowMafRefGT.checkAlleleCounts(nArray, n);
        for (int[] nArray2 : nArray) {
            if (nArray2 == null || nArray2.length <= 0 || nArray2[0] >= 0 && nArray2[nArray2.length - 1] < n) continue;
            throw new IndexOutOfBoundsException(Arrays.toString(nArray2));
        }
    }

    private static void checkAlleleCounts(int[][] nArray, int n) {
        int n2;
        int n3 = n;
        int n4 = -1;
        int n5 = -1;
        for (n2 = 0; n2 < nArray.length; ++n2) {
            if (nArray[n2] == null) {
                if (n5 != -1) {
                    throw new IllegalArgumentException("ERROR: major allele error");
                }
                n5 = n2;
                continue;
            }
            if (n4 == -1 || nArray[n2].length > nArray[n4].length) {
                n4 = n2;
            }
            n3 -= nArray[n2].length;
        }
        int n6 = n2 = n4 != -1 && nArray[n4].length == n3 && n4 < n5 ? 1 : 0;
        if (n5 == -1 || n2 != 0) {
            throw new IllegalArgumentException("ERROR: major allele error");
        }
    }

    @Override
    public Samples samples() {
        return this.samples;
    }

    @Override
    public int nSamples() {
        return this.samples.nSamples();
    }

    @Override
    public int nHaps() {
        return this.nHaps;
    }

    @Override
    public int nHapPairs() {
        return this.samples.nSamples();
    }

    @Override
    public Marker marker() {
        return this.marker;
    }

    @Override
    public boolean isRefData() {
        return true;
    }

    @Override
    public float gl(int n, int n2, int n3) {
        if (n2 < 0 || n2 >= this.hapIndices.length) {
            throw new IndexOutOfBoundsException(String.valueOf(n2));
        }
        if (n3 < 0 || n3 >= this.hapIndices.length) {
            throw new IndexOutOfBoundsException(String.valueOf(n3));
        }
        boolean bl = n2 == this.allele1(n) && n3 == this.allele2(n);
        return bl ? 1.0f : 0.0f;
    }

    @Override
    public boolean isPhased(int n) {
        if (n >= this.samples.nSamples()) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        return true;
    }

    @Override
    public int allele1(int n) {
        return this.allele(2 * n);
    }

    @Override
    public int allele2(int n) {
        return this.allele(2 * n + 1);
    }

    @Override
    public int allele(int n) {
        if (n < 0 || n >= this.nHaps) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        for (int i = 0; i < this.hapIndices.length; ++i) {
            if (i == this.majorAllele || Arrays.binarySearch(this.hapIndices[i], n) < 0) continue;
            return i;
        }
        return this.majorAllele;
    }

    @Override
    public int nAlleles() {
        return this.marker().nAlleles();
    }

    @Override
    public boolean storesNonMajorIndices() {
        return true;
    }

    @Override
    public int majorAllele() {
        return this.majorAllele;
    }

    @Override
    public int alleleCount(int n) {
        if (this.hapIndices[n] == null) {
            throw new IllegalArgumentException("major allele");
        }
        return this.hapIndices[n].length;
    }

    @Override
    public int hapIndex(int n, int n2) {
        if (this.hapIndices[n] == null) {
            throw new IllegalArgumentException("major allele");
        }
        return this.hapIndices[n][n2];
    }

    public String toString() {
        return this.toVcfRec();
    }
}

