/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.fingerprint;

import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.openscience.cdk.CDK;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.fingerprint.IFingerprinter;
import org.openscience.cdk.interfaces.IAtomContainer;

public abstract class AbstractFingerprinter
implements IFingerprinter {
    protected List<Map.Entry<String, String>> getParameters() {
        return Collections.emptyList();
    }

    public final String getVersionDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("CDK-").append(this.getClass().getSimpleName()).append("/").append(CDK.getVersion());
        for (Map.Entry<String, String> param : this.getParameters()) {
            sb.append(' ').append(param.getKey()).append('=').append(param.getValue());
        }
        return sb.toString();
    }

    public BitSet getFingerprint(IAtomContainer mol) throws CDKException {
        return this.getBitFingerprint(mol).asBitSet();
    }
}

