/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.search;

import choco.cp.solver.search.AbstractSearchLoopWithRestart;
import choco.cp.solver.search.restart.IKickRestart;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.search.AbstractGlobalSearchStrategy;
import choco.kernel.solver.search.IntBranchingDecision;
import choco.kernel.solver.search.IntBranchingTrace;
import gnu.trove.TIntStack;
import java.util.Stack;

public class SearchLoopWithRecomputation
extends AbstractSearchLoopWithRestart {
    public final int gap;
    private int cpt = 0;
    private int lastSavedTraceIndex = 0;
    private final TIntStack savedTraceIndex;
    private final Stack<IntBranchingTrace> contexts;
    private final TIntStack ctxIndices;

    public SearchLoopWithRecomputation(AbstractGlobalSearchStrategy searchStrategy, IKickRestart kickRestart, int gap) {
        super(searchStrategy, kickRestart);
        this.gap = gap;
        int n = searchStrategy.solver.getNbIntVars();
        this.savedTraceIndex = new TIntStack(n);
        this.contexts = new Stack();
        this.ctxIndices = new TIntStack(n);
    }

    public final int getGap() {
        return this.gap;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.savedTraceIndex.reset();
        this.lastSavedTraceIndex = this.searchStrategy.getCurrentTraceIndex();
        this.savedTraceIndex.push(this.lastSavedTraceIndex);
        this.ctxIndices.push(this.contexts.size());
        this.searchStrategy.solver.worldPush();
    }

    @Override
    public void restart() {
        this.cpt = 0;
        super.restart();
    }

    @Override
    protected void worldPop() {
        this.searchStrategy.solver.worldPop();
        if (this.lastSavedTraceIndex != 0 && this.searchStrategy.getCurrentTraceIndex() == this.lastSavedTraceIndex) {
            this.savedTraceIndex.pop();
            this.lastSavedTraceIndex = this.savedTraceIndex.peek();
            this.searchStrategy.solver.worldPop();
        }
        int ind = this.ctxIndices.pop();
        while (this.contexts.size() > ind) {
            this.contexts.pop();
        }
        this.searchStrategy.solver.worldPush();
    }

    @Override
    protected void goUpBranch() throws ContradictionException {
        int ind;
        this.searchStrategy.postDynamicCut();
        LOGGER.finest("recomputation ...");
        for (int i = this.lastSavedTraceIndex; i < this.searchStrategy.getCurrentTraceIndex(); ++i) {
            this.ctx = this.searchStrategy.getTrace(i);
            this.ctx.getBranching().goDownBranch(this.ctx);
            this.searchStrategy.solver.propagate();
        }
        this.ctx = this.searchStrategy.topTrace();
        LOGGER.finest("backtrack ...");
        for (int i = ind = this.ctxIndices.peek(); i < this.contexts.size(); ++i) {
            this.ctx.getBranching().goUpBranch((IntBranchingDecision)this.contexts.get(i));
            this.searchStrategy.solver.propagate();
        }
        this.ctx.getBranching().goUpBranch(this.ctx);
        LOGGER.finest("continue ...");
        this.searchStrategy.solver.propagate();
        this.contexts.push(this.ctx.copy());
        this.cpt = 0;
    }

    @Override
    protected void worldPush() {
        if (this.cpt % this.gap == 0) {
            this.searchStrategy.solver.worldPush();
            this.lastSavedTraceIndex = this.searchStrategy.getCurrentTraceIndex();
            this.savedTraceIndex.push(this.lastSavedTraceIndex);
            this.cpt = 0;
        }
        this.ctxIndices.push(this.contexts.size());
        ++this.cpt;
    }
}

