## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## -----------------------------------------------------------------------------
library(callback)
m <- inter1
table(m$origin, m$lastn)
table(m$origin, m$firstn)

## -----------------------------------------------------------------------------
str(m)

## -----------------------------------------------------------------------------
levels(m$origin)
levels(m$gender)

## -----------------------------------------------------------------------------
m$gender2 <- relevel(m$gender, ref = "Woman")
levels(m$gender2)

## -----------------------------------------------------------------------------
dtest <- callback(
  data = m,
  cluster = "offer",
  candid = c("origin", "gender"),
  callback = "callback"
)

## -----------------------------------------------------------------------------
print(dtest)

## -----------------------------------------------------------------------------
print(stat_raw(dtest))

## ----fig.width=7,fig.height=4.4-----------------------------------------------
plot(stat_raw(dtest))

## ----fig.width=7,fig.height=4.4-----------------------------------------------
g <- stat_raw(dtest, level = 0.9,method="cp")
print(g)
plot(g, col = c("steelblue3","black"))

## -----------------------------------------------------------------------------
sp <- stat_paired(dtest)

## -----------------------------------------------------------------------------
print(sp)

## -----------------------------------------------------------------------------
sp$props

## -----------------------------------------------------------------------------
mcr <- stat_mcr(dtest)
print(mcr)

## ----fig.width=7,fig.height=4.4-----------------------------------------------
plot(mcr)

## ----fig.width=7,fig.height=4.4-----------------------------------------------
plot(mcr, dif = FALSE)

## -----------------------------------------------------------------------------
tcs <- stat_tcs(dtest)
print(tcs)

## ----fig.width=7,fig.height=4.4-----------------------------------------------
plot(tcs)

## ----fig.width=7,fig.height=4.4-----------------------------------------------
plot(tcs, dif = FALSE)

## -----------------------------------------------------------------------------
print(stat_tcs(dtest,method = "cp"))

## -----------------------------------------------------------------------------
ecs <- stat_ecs(dtest)
print(ecs)
plot(ecs)

## ----fig.width=7,fig.height=4.4-----------------------------------------------
plot(ecs, dif = FALSE)

## ----fig.width=7,fig.height=4.4-----------------------------------------------
ecs <- stat_ecs(dtest, method = "wilson")
print(ecs)
plot(ecs)

