/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.timeseries.simplets;

import java.util.Arrays;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.TsDomain;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.api.timeseries.TsUnit;
import jdplus.toolkit.base.api.timeseries.calendars.CalendarUtility;
import jdplus.toolkit.base.api.timeseries.calendars.LengthOfPeriodType;
import jdplus.toolkit.base.core.data.transformation.LogJacobian;
import jdplus.toolkit.base.core.timeseries.simplets.TsDataTransformation;

class LengthOfPeriodTransformation
implements TsDataTransformation {
    private final boolean back;
    private final LengthOfPeriodType type;

    public LengthOfPeriodTransformation(LengthOfPeriodType ltype) {
        this(ltype, false);
    }

    private LengthOfPeriodTransformation(LengthOfPeriodType ltype, boolean back) {
        this.type = ltype;
        this.back = back;
    }

    @Override
    public TsDataTransformation converse() {
        return new LengthOfPeriodTransformation(this.type, !this.back);
    }

    @Override
    public TsData transform(TsData data, LogJacobian ljacobian) {
        int ratio = data.getTsUnit().ratioOf(TsUnit.P1Y);
        if (this.type == LengthOfPeriodType.LengthOfPeriod) {
            return this.length(data, ratio, ljacobian);
        }
        return this.lp(data, ratio, ljacobian);
    }

    @Override
    public double transform(TsPeriod p, double value) {
        TsData s = TsData.of((TsPeriod)p, (DoubleSeq)DoubleSeq.of((double[])new double[]{value}));
        TsData t = this.transform(s, (LogJacobian)null);
        return t.getValue(0);
    }

    private TsData length(TsData tsdata, int ratio, LogJacobian lj) {
        double[] data;
        block18: {
            double fac;
            double m;
            int[] ndays;
            block17: {
                double fac2;
                ndays = CalendarUtility.daysCount((TsDomain)tsdata.getDomain());
                m = 365.25 / (double)ratio;
                data = tsdata.getValues().toArray();
                if (!this.back) break block17;
                int i = 0;
                while (i < ndays.length) {
                    fac2 = (double)ndays[i] / m;
                    int n = i++;
                    data[n] = data[n] * fac2;
                }
                if (lj == null) break block18;
                if (lj.missing == null) {
                    for (i = lj.start; i < lj.end; ++i) {
                        if (!Double.isFinite(data[i])) continue;
                        fac2 = (double)ndays[i] / m;
                        lj.value += Math.log(fac2);
                    }
                } else {
                    double fac3;
                    int imissing;
                    int nmissing = lj.missing.length;
                    int ic = lj.start;
                    for (imissing = 0; imissing < nmissing && lj.missing[imissing] < ic; ++imissing) {
                    }
                    while (imissing != nmissing && ic < lj.end) {
                        if (ic == lj.missing[imissing]) {
                            ++ic;
                            ++imissing;
                            continue;
                        }
                        fac3 = (double)ndays[ic++] / m;
                        lj.value += Math.log(fac3);
                    }
                    while (ic < lj.end) {
                        fac3 = (double)ndays[ic++] / m;
                        lj.value += Math.log(fac3);
                    }
                }
                break block18;
            }
            int i = 0;
            while (i < ndays.length) {
                fac = m / (double)ndays[i];
                int n = i++;
                data[n] = data[n] * fac;
            }
            if (lj != null) {
                if (lj.missing == null) {
                    for (i = lj.start; i < lj.end; ++i) {
                        if (!Double.isFinite(data[i])) continue;
                        fac = m / (double)ndays[i];
                        lj.value += Math.log(fac);
                    }
                } else {
                    double fac4;
                    int imissing;
                    int nmissing = lj.missing.length;
                    int ic = lj.start;
                    for (imissing = 0; imissing < nmissing && lj.missing[imissing] < ic; ++imissing) {
                    }
                    while (imissing != nmissing && ic < lj.end) {
                        if (ic == lj.missing[imissing]) {
                            ++ic;
                            ++imissing;
                            continue;
                        }
                        fac4 = m / (double)ndays[ic++];
                        lj.value += Math.log(fac4);
                    }
                    while (ic < lj.end) {
                        fac4 = m / (double)ndays[ic++];
                        lj.value += Math.log(fac4);
                    }
                }
            }
        }
        return TsData.ofInternal((TsPeriod)tsdata.getStart(), (double[])data);
    }

    private TsData lp(TsData tsdata, int freq, LogJacobian lj) {
        TsPeriod start;
        int pos;
        int idx;
        if (!tsdata.hasDefaultEpoch()) {
            throw new UnsupportedOperationException();
        }
        TsDomain domain = tsdata.getDomain();
        int period = 0;
        if (freq == 12) {
            period = 1;
        }
        if ((idx = period - (pos = ((start = domain.getStartPeriod()).start().getMonthValue() - 1) % freq)) < 0) {
            idx += freq;
        }
        int lppos = idx;
        int year = domain.get(idx).year();
        while (!CalendarUtility.isLeap((int)year)) {
            lppos += freq;
            ++year;
        }
        int ndays = switch (freq) {
            case 12 -> 28;
            case 1 -> 365;
            default -> CalendarUtility.getCumulatedMonthDays((int)(12 / freq));
        };
        double[] data = tsdata.getValues().toArray();
        if (this.back) {
            double leap = (double)(ndays + 1) / ((double)ndays + 0.25);
            double nleap = (double)ndays / ((double)ndays + 0.25);
            while (idx < domain.getLength()) {
                double fac = (idx - lppos) % (4 * freq) != 0 ? nleap : leap;
                int n = idx;
                data[n] = data[n] * fac;
                if (lj != null && idx >= lj.start && idx < lj.end) {
                    if (lj.missing == null) {
                        if (Double.isFinite(data[idx])) {
                            lj.value += Math.log(fac);
                        }
                    } else {
                        int lpos = Arrays.binarySearch(lj.missing, idx);
                        if (lpos < 0) {
                            lj.value += Math.log(fac);
                        }
                    }
                }
                idx += freq;
            }
        } else {
            double leap = ((double)ndays + 0.25) / (double)(ndays + 1);
            double nleap = ((double)ndays + 0.25) / (double)ndays;
            while (idx < domain.getLength()) {
                double fac = (idx - lppos) % (4 * freq) != 0 ? nleap : leap;
                int n = idx;
                data[n] = data[n] * fac;
                if (lj != null && idx >= lj.start && idx < lj.end) {
                    if (lj.missing == null) {
                        if (Double.isFinite(data[idx])) {
                            lj.value += Math.log(fac);
                        }
                    } else {
                        int lpos = Arrays.binarySearch(lj.missing, idx);
                        if (lpos < 0) {
                            lj.value += Math.log(fac);
                        }
                    }
                }
                idx += freq;
            }
        }
        return TsData.ofInternal((TsPeriod)start, (double[])data);
    }
}

