/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.regarima.diagnostics;

import java.util.Arrays;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.timeseries.regression.ModellingUtility;
import jdplus.toolkit.base.api.timeseries.regression.Variable;
import jdplus.toolkit.base.core.regarima.RegArimaModel;
import jdplus.toolkit.base.core.regarima.RegArimaUtility;
import jdplus.toolkit.base.core.regarima.diagnostics.OutOfSampleDiagnosticsConfiguration;
import jdplus.toolkit.base.core.regarima.tests.OneStepAheadForecastingTest;
import jdplus.toolkit.base.core.regsarima.RegSarimaComputer;
import jdplus.toolkit.base.core.sarima.SarimaModel;
import jdplus.toolkit.base.core.stats.tests.NiidTests;
import lombok.Generated;

public final class RegArimaDiagnostics {
    private static final int OUTOFSAMPLE_MIN = 5;

    public static OneStepAheadForecastingTest oneStepAheadForecastingTest(RegArimaModel<SarimaModel> regarima, double forecastLength) {
        int ifreq;
        int nback;
        double len = forecastLength;
        if (len == 0.0) {
            len = OutOfSampleDiagnosticsConfiguration.getDefault().getOutOfSampleLength();
        }
        if ((nback = (int)Math.round(len * (double)(ifreq = regarima.arima().getPeriod()))) < 5) {
            nback = 5;
        }
        RegSarimaComputer processor = RegSarimaComputer.builder().build();
        return OneStepAheadForecastingTest.of(regarima, processor, nback);
    }

    public static double outliersRatio(RegArimaModel<SarimaModel> regarima, Variable[] variables, boolean all) {
        int n = regarima.getY().length() - regarima.getMissingValuesCount();
        double o = all ? (double)Arrays.stream(variables).filter(var -> ModellingUtility.isOutlier((Variable)var)).count() : (double)Arrays.stream(variables).filter(var -> ModellingUtility.isOutlier((Variable)var)).filter(var -> ModellingUtility.isAutomaticallyIdentified((Variable)var)).count();
        return o / (double)n;
    }

    public static NiidTests residualTests(DoubleSeq res, int period, int nhyperparameters) {
        try {
            return NiidTests.builder().data(res).period(period).k(RegArimaUtility.defaultLjungBoxLength(period)).ks(2).seasonal(period > 1).hyperParametersCount(nhyperparameters).build();
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Generated
    private RegArimaDiagnostics() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

