/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ml;

import java.util.Random;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.math.matrices.Matrix;
import jdplus.toolkit.base.api.util.IntList;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.ml.IsolationForests;
import lombok.Generated;

public final class XIsolationForest {
    static IsolationForests.TreeBuilder BUILDER = (X, selection, limit, rnd) -> new Builder(X, limit, rnd).root(selection);

    @Generated
    private XIsolationForest() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static class Builder {
        final Matrix X;
        final double limit;
        final Random rnd;

        IsolationForests.Node root(int[] selection) {
            int[] sel = selection;
            if (sel == null) {
                sel = new int[this.X.getColumnsCount()];
                for (int i = 0; i < sel.length; ++i) {
                    sel[i] = i;
                }
            }
            return this.node(sel, 0);
        }

        IsolationForests.Node node(int[] items, int level) {
            double xdotn;
            int size = items.length;
            int dim = this.X.getRowsCount();
            double[] n = new double[dim];
            for (int i = 0; i < dim; ++i) {
                n[i] = this.rnd.nextGaussian();
            }
            double[] d = new double[size];
            IntList XL = new IntList(size);
            IntList XR = new IntList(size);
            DataBlock N = DataBlock.of(n);
            d[0] = xdotn = this.X.column(items[0]).dot((DoubleSeq)N);
            double min = xdotn;
            double max = xdotn;
            for (int i = 1; i < size; ++i) {
                d[i] = xdotn = this.X.column(items[i]).dot((DoubleSeq)N);
                if (xdotn < min) {
                    min = xdotn;
                    continue;
                }
                if (!(xdotn > max)) continue;
                max = xdotn;
            }
            double p = this.rnd.nextDouble() * (max - min) + min;
            for (int i = 0; i < size; ++i) {
                if (d[i] < p) {
                    XL.add(i);
                    continue;
                }
                XR.add(i);
            }
            IsolationForests.Node left = (double)level > this.limit || XL.size() <= 1 ? IsolationForests.FinalNode.of(XL.size()) : this.node(XL.toArray(), level + 1);
            IsolationForests.Node right = (double)level > this.limit || XR.size() <= 1 ? IsolationForests.FinalNode.of(XR.size()) : this.node(XR.toArray(), level + 1);
            return new XNode(items, N, p, left, right);
        }

        @Generated
        public Builder(Matrix X, double limit, Random rnd) {
            this.X = X;
            this.limit = limit;
            this.rnd = rnd;
        }
    }

    static class XNode
    implements IsolationForests.Node {
        final int[] items;
        final DataBlock normalVector;
        final double threshold;
        final IsolationForests.Node left;
        final IsolationForests.Node right;

        @Override
        public boolean isFinal() {
            return false;
        }

        @Override
        public int size() {
            return this.items.length;
        }

        @Override
        public IsolationForests.Node left() {
            return this.left;
        }

        @Override
        public IsolationForests.Node right() {
            return this.right;
        }

        @Override
        public IsolationForests.Node branch(DoubleSeq x) {
            double d = x.dot((DoubleSeq)this.normalVector);
            return d < this.threshold ? this.left : this.right;
        }

        @Generated
        public XNode(int[] items, DataBlock normalVector, double threshold, IsolationForests.Node left, IsolationForests.Node right) {
            this.items = items;
            this.normalVector = normalVector;
            this.threshold = threshold;
            this.left = left;
            this.right = right;
        }
    }
}

