/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.set;

import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.BitSet;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.tools.ArrayUtils;

public class PropUnionVar
extends Propagator<SetVar> {
    private final int k;
    private final int iOffset;
    private final TIntObjectHashMap<int[]> mates;
    private final BitSet iii = new BitSet();
    private boolean firstProp = true;
    private final BitSet checker = new BitSet();

    public PropUnionVar(SetVar union, SetVar indices, int iOffset, SetVar[] sets) {
        super((Variable[])ArrayUtils.append(sets, {union, indices}), (Priority)PropagatorPriority.QUADRATIC, false);
        this.k = sets.length;
        this.iOffset = iOffset;
        this.mates = new TIntObjectHashMap();
        ISetIterator iSetIterator = union.getUB().iterator();
        while (iSetIterator.hasNext()) {
            int i = (Integer)iSetIterator.next();
            this.mates.put(i, new int[]{0, 1});
        }
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        SetVar indices = ((SetVar[])this.vars)[this.k + 1];
        if (this.firstProp) {
            this.firstProp = false;
            this.model.getEnvironment().save(() -> {
                this.firstProp = true;
            });
            this.boundIndices(indices);
        }
        SetVar union = ((SetVar[])this.vars)[this.k];
        this.filter1(indices, union);
        this.filter2(indices, union);
        this.filter6(indices, union);
        this.filter1(indices, union);
    }

    private void boundIndices(SetVar indices) throws ContradictionException {
        if (indices.getUB().size() > 0) {
            int min = indices.getUB().min();
            while (min - this.iOffset < 0 && indices.getUB().size() > 0) {
                indices.remove(min, this);
                min = indices.getUB().min();
            }
        }
        if (indices.getUB().size() > 0) {
            int max = indices.getUB().max();
            while (max - this.iOffset >= this.k && indices.getUB().size() > 0) {
                indices.remove(max, this);
                max = indices.getUB().max();
            }
        }
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        return 255;
    }

    private void filter1(SetVar indices, SetVar union) throws ContradictionException {
        ISetIterator iSetIterator = indices.getLB().iterator();
        while (iSetIterator.hasNext()) {
            int i = (Integer)iSetIterator.next();
            ISetIterator it = ((SetVar[])this.vars)[i -= this.iOffset].getUB().newIterator();
            while (it.hasNext()) {
                int v = it.nextInt();
                if (!union.getUB().contains(v)) {
                    ((SetVar[])this.vars)[i].remove(v, this);
                    continue;
                }
                if (!((SetVar[])this.vars)[i].getLB().contains(v)) continue;
                union.force(v, this);
            }
        }
    }

    private void filter2(SetVar indices, SetVar union) throws ContradictionException {
        ISetIterator iSetIterator = indices.getUB().iterator();
        while (iSetIterator.hasNext()) {
            int i = (Integer)iSetIterator.next();
            if (indices.getLB().contains(i)) continue;
            boolean isInstantiated = ((SetVar[])this.vars)[i - this.iOffset].isInstantiated();
            ISetIterator it = ((SetVar[])this.vars)[i - this.iOffset].getUB().newIterator();
            boolean found = isInstantiated;
            while (it.hasNext()) {
                int v = it.nextInt();
                if (union.getUB().contains(v) == isInstantiated) continue;
                found = !isInstantiated;
                break;
            }
            if (found) continue;
            indices.remove(i, this);
        }
    }

    private void filter6(SetVar indices, SetVar union) throws ContradictionException {
        this.iii.clear();
        ISetIterator it = indices.getUB().newIterator();
        while (it.hasNext()) {
            this.iii.set(it.nextInt() - this.iOffset);
        }
        ISetIterator iSetIterator = union.getUB().iterator();
        while (iSetIterator.hasNext()) {
            int u = (Integer)iSetIterator.next();
            this.filter66(u, indices, union);
        }
    }

    private void filter66(int u, SetVar indices, SetVar union) throws ContradictionException {
        boolean l1;
        int[] ms = this.mates.get(u);
        boolean l0 = this.iii.get(ms[0]) && ((SetVar[])this.vars)[ms[0]].getUB().contains(u);
        boolean bl = l1 = this.iii.get(ms[1]) && ((SetVar[])this.vars)[ms[1]].getUB().contains(u);
        if (l0 && !l1) {
            int m = ms[0];
            ms[0] = ms[1];
            ms[1] = m;
            boolean b = l0;
            l0 = l1;
            l1 = b;
        }
        if (!l0) {
            int k = 0;
            int i = this.iii.nextSetBit(0);
            while (i > -1) {
                if (i != ms[0] && i != ms[1] && ((SetVar[])this.vars)[i].getUB().contains(u)) {
                    if (k == 0) {
                        ms[k++] = i;
                        l0 = true;
                        if (l1) {
                            break;
                        }
                    } else {
                        ms[k] = i;
                        l1 = true;
                        break;
                    }
                }
                i = this.iii.nextSetBit(i + 1);
            }
        }
        if (!l0 && !l1) {
            union.remove(u, this);
        } else if (l0 ^ l1 && union.getLB().contains(u)) {
            int mate = l0 ? ms[0] : ms[1];
            indices.force(mate + this.iOffset, this);
            ((SetVar[])this.vars)[mate].force(u, this);
        }
    }

    @Override
    public ESat isEntailed() {
        if (this.isCompletelyInstantiated()) {
            this.checker.clear();
            for (int i : ((SetVar[])this.vars)[this.k + 1].getLB().toArray()) {
                for (int j : ((SetVar[])this.vars)[i -= this.iOffset].getLB().toArray()) {
                    if (!((SetVar[])this.vars)[this.k].getLB().contains(j)) {
                        return ESat.FALSE;
                    }
                    this.checker.set(j);
                }
            }
            return ESat.eval(this.checker.cardinality() == ((SetVar[])this.vars)[this.k].getLB().size());
        }
        return ESat.UNDEFINED;
    }
}

