/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.extension;

import java.util.Random;
import org.chocosolver.solver.Settings;
import org.chocosolver.solver.constraints.Operator;
import org.chocosolver.solver.constraints.extension.TupleValidator;
import org.chocosolver.solver.constraints.extension.Tuples;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.tools.ArrayUtils;

public class TuplesFactory {
    TuplesFactory() {
    }

    public static Tuples generateTuples(TupleValidator filter, boolean feasible, int[] ... doms) {
        int j;
        Tuples tuples = new Tuples(feasible);
        int n = doms.length;
        int[] t = new int[n];
        int[] i = new int[n];
        for (j = 0; j < n; ++j) {
            t[j] = doms[j][0];
        }
        block1: do {
            if (filter.valid(t)) {
                tuples.add((int[])t.clone());
            }
            for (j = 0; j < n; ++j) {
                int n2 = j;
                i[n2] = i[n2] + 1;
                if (i[j] < doms[j].length) {
                    t[j] = doms[j][i[j]];
                    continue block1;
                }
                i[j] = 0;
                t[j] = doms[j][0];
            }
        } while (j != n);
        return tuples;
    }

    public static Tuples generateTuples(TupleValidator filter, boolean feasible, IntVar ... vars) {
        int j;
        Tuples tuples = new Tuples(feasible);
        int n = vars.length;
        int[] cvalue = new int[n];
        int[] t = new int[n];
        for (j = 0; j < n; ++j) {
            t[j] = cvalue[j] = vars[j].getLB();
        }
        block1: do {
            if (filter.valid(t)) {
                tuples.add((int[])t.clone());
            }
            for (j = 0; j < n; ++j) {
                t[j] = cvalue[j] = vars[j].nextValue(cvalue[j]);
                int v = cvalue[j];
                if (v < Integer.MAX_VALUE) continue block1;
                t[j] = cvalue[j] = vars[j].getLB();
            }
        } while (j != n);
        return tuples;
    }

    public static Tuples randomTuples(double proba, Random random, IntVar ... vars) {
        return TuplesFactory.generateTuples((int[] vs) -> random.nextDouble() < proba, true, vars);
    }

    public static Tuples absolute(IntVar VAR1, IntVar VAR2) {
        return TuplesFactory.generateTuples((int[] values) -> values[0] == Math.abs(values[1]), true, VAR1, VAR2);
    }

    public static Tuples arithm(IntVar VAR1, String OP, IntVar VAR2) {
        Operator op = Operator.get(OP);
        return TuplesFactory.generateTuples((int[] values) -> {
            switch (op) {
                case LT: {
                    return values[0] < values[1];
                }
                case GT: {
                    return values[0] > values[1];
                }
                case LE: {
                    return values[0] <= values[1];
                }
                case GE: {
                    return values[0] >= values[1];
                }
                case NQ: {
                    return values[0] != values[1];
                }
                case EQ: {
                    return values[0] == values[1];
                }
            }
            throw new SolverException("Unexpected Tuple operator " + (Object)((Object)op) + " (should be in {\"=\", \"!=\", \">\",\"<\",\">=\",\"<=\"})");
        }, true, VAR1, VAR2);
    }

    public static Tuples element(IntVar VALUE, int[] TABLE, IntVar INDEX, int OFFSET) {
        Tuples t = new Tuples(true);
        int v = INDEX.getLB();
        while (v <= INDEX.getUB()) {
            if (v - OFFSET >= 0 && v - OFFSET < TABLE.length && VALUE.contains(TABLE[v - OFFSET])) {
                t.add(TABLE[v - OFFSET], v);
            }
            v = INDEX.nextValue(v);
        }
        return t;
    }

    public static Tuples element(IntVar VALUE, int[][] MATRIX, IntVar ROWINDEX, int ROWOFFSET, IntVar COLINDEX, int COLOFFSET) {
        Tuples t = new Tuples(true);
        for (int i = 0; i < MATRIX.length; ++i) {
            for (int j = 0; j < MATRIX[i].length; ++j) {
                if (!ROWINDEX.contains(i - ROWOFFSET) || !COLINDEX.contains(j - COLOFFSET) || !VALUE.contains(MATRIX[i][j])) continue;
                t.add(i, j, MATRIX[i - -ROWOFFSET][j - COLOFFSET]);
            }
        }
        return t;
    }

    public static Tuples modulo(IntVar VAR1, int m, IntVar VAR2) {
        return TuplesFactory.generateTuples((int[] values) -> values[1] == values[0] % m, true, VAR1, VAR2);
    }

    public static Tuples power(IntVar VAR1, IntVar VAR2, int POWER) {
        return TuplesFactory.generateTuples((int[] values) -> (double)values[0] == Math.pow(values[1], POWER), true, VAR1, VAR2);
    }

    public static Tuples square(IntVar VAR1, IntVar VAR2) {
        return TuplesFactory.generateTuples((int[] values) -> (double)values[0] == Math.pow(values[1], 2.0), true, VAR1, VAR2);
    }

    public static Tuples eucl_div(IntVar DIVIDEND, IntVar DIVISOR, IntVar RESULT) {
        return TuplesFactory.generateTuples((int[] values) -> values[0] / values[1] == values[2], true, DIVIDEND, DIVISOR, RESULT);
    }

    public static Tuples maximum(IntVar VAR1, IntVar VAR2, IntVar MAX) {
        return TuplesFactory.generateTuples((int[] values) -> values[0] == Math.max(values[1], values[2]), true, MAX, VAR1, VAR2);
    }

    public static Tuples minimum(IntVar VAR1, IntVar VAR2, IntVar MIN) {
        return TuplesFactory.generateTuples((int[] values) -> values[0] == Math.min(values[1], values[2]), true, MIN, VAR1, VAR2);
    }

    public static Tuples modulo(IntVar VAR1, IntVar VAR2, IntVar RES) {
        return TuplesFactory.generateTuples((int[] values) -> values[1] != 0 && values[2] == values[0] % values[1], true, VAR1, VAR2, RES);
    }

    public static Tuples minus(IntVar VAR1, IntVar VAR2, IntVar RESULT) {
        return TuplesFactory.generateTuples((int[] values) -> values[0] - values[1] == values[2], true, VAR1, VAR2, RESULT);
    }

    public static Tuples plus(IntVar VAR1, IntVar VAR2, IntVar RESULT) {
        return TuplesFactory.generateTuples((int[] values) -> values[0] + values[1] == values[2], true, VAR1, VAR2, RESULT);
    }

    public static Tuples times(IntVar VAR1, IntVar VAR2, IntVar RESULT) {
        return TuplesFactory.generateTuples((int[] values) -> values[0] * values[1] == values[2], true, VAR1, VAR2, RESULT);
    }

    public static Tuples allDifferent(IntVar ... VARS) {
        return TuplesFactory.generateTuples((int[] values) -> {
            for (int i = 0; i < values.length - 1; ++i) {
                for (int j = i + 1; j < values.length; ++j) {
                    if (values[j] != values[i]) continue;
                    return false;
                }
            }
            return true;
        }, true, VARS);
    }

    public static Tuples allEquals(IntVar ... VARS) {
        int min = Integer.MIN_VALUE;
        int max = Integer.MAX_VALUE;
        for (int i = 0; i < VARS.length; ++i) {
            min = Math.max(min, VARS[i].getLB());
            max = Math.min(max, VARS[i].getUB());
        }
        Tuples tuples = new Tuples(true);
        for (int k = min; k <= max; ++k) {
            int[] t = new int[VARS.length];
            for (int i = 0; i < VARS.length; ++i) {
                t[i] = k;
            }
            tuples.add((int[])t.clone());
        }
        return tuples;
    }

    public static Tuples lex_chain_less(IntVar ... VARS) {
        return TuplesFactory.generateTuples((int[] values) -> {
            for (int i = 0; i < values.length - 1; ++i) {
                if (values[i] >= values[i + 1]) continue;
                return false;
            }
            return true;
        }, true, VARS);
    }

    public static Tuples lex_chain_less_eq(IntVar ... VARS) {
        return TuplesFactory.generateTuples((int[] values) -> {
            for (int i = 0; i < values.length - 1; ++i) {
                if (values[i] > values[i + 1]) continue;
                return false;
            }
            return true;
        }, true, VARS);
    }

    public static Tuples scalar(IntVar[] VARS, int[] COEFFS, IntVar SCALAR, int SCALAR_COEFF) {
        Tuples left = TuplesFactory.generateTuples(TupleValidator.TRUE, true, VARS);
        Tuples tuples = new Tuples(true);
        int n = VARS.length;
        for (int[] tleft : left.tuples) {
            int right = 0;
            for (int i = 0; i < n; ++i) {
                right += tleft[i] * COEFFS[i];
            }
            if (right % SCALAR_COEFF != 0 || !SCALAR.contains(right / SCALAR_COEFF)) continue;
            int[] t = new int[n + 1];
            System.arraycopy(tleft, 0, t, 0, n);
            t[n] = right / SCALAR_COEFF;
            tuples.add(t);
        }
        return tuples;
    }

    public static Tuples scalar(IntVar[] VARS, int[] COEFFS, String OPERATOR, IntVar SCALAR, int SCALAR_COEFF, int CSTE) {
        if ("=".equals(OPERATOR) && CSTE == 0) {
            return TuplesFactory.scalar(VARS, COEFFS, SCALAR, SCALAR_COEFF);
        }
        Operator op = Operator.get(OPERATOR);
        return TuplesFactory.generateTuples((int[] values) -> {
            int scalar = 0;
            for (int i = 0; i < values.length - 1; ++i) {
                scalar += values[i] * COEFFS[i];
            }
            switch (op) {
                case LT: {
                    return scalar < values[values.length - 1] * SCALAR_COEFF + CSTE;
                }
                case GT: {
                    return scalar > values[values.length - 1] * SCALAR_COEFF + CSTE;
                }
                case LE: {
                    return scalar <= values[values.length - 1] * SCALAR_COEFF + CSTE;
                }
                case GE: {
                    return scalar >= values[values.length - 1] * SCALAR_COEFF + CSTE;
                }
                case NQ: {
                    return scalar != values[values.length - 1] * SCALAR_COEFF + CSTE;
                }
                case EQ: {
                    return scalar == values[values.length - 1] * SCALAR_COEFF + CSTE;
                }
            }
            throw new SolverException("Unexpected Tuple operator " + (Object)((Object)op) + " (should be in {\"=\", \"!=\", \">\",\"<\",\">=\",\"<=\"})");
        }, true, ArrayUtils.concat(VARS, SCALAR));
    }

    public static Tuples sum(IntVar[] VARS, String OPERATOR, IntVar SUM, int CSTE) {
        Operator op = Operator.get(OPERATOR);
        return TuplesFactory.generateTuples((int[] values) -> {
            int sum = 0;
            for (int i = 0; i < values.length - 1; ++i) {
                sum += values[i];
            }
            switch (op) {
                case LT: {
                    return sum < values[values.length - 1] + CSTE;
                }
                case GT: {
                    return sum > values[values.length - 1] + CSTE;
                }
                case LE: {
                    return sum <= values[values.length - 1] + CSTE;
                }
                case GE: {
                    return sum >= values[values.length - 1] + CSTE;
                }
                case NQ: {
                    return sum != values[values.length - 1] + CSTE;
                }
                case EQ: {
                    return sum == values[values.length - 1] + CSTE;
                }
            }
            throw new SolverException("Unexpected Tuple operator " + (Object)((Object)op) + " (should be in {\"=\", \"!=\", \">\",\"<\",\">=\",\"<=\"})");
        }, true, ArrayUtils.concat(VARS, SUM));
    }

    public static boolean canBeTupled(IntVar ... VARS) {
        Settings settings = VARS[0].getModel().getSettings();
        if (!settings.enableTableSubstitution()) {
            return false;
        }
        long doms = 1L;
        for (int i = 0; i < VARS.length && doms < (long)settings.getMaxTupleSizeForSubstitution(); doms *= (long)VARS[i].getDomainSize(), ++i) {
            if (VARS[i].hasEnumeratedDomain()) continue;
            return false;
        }
        return doms < (long)settings.getMaxTupleSizeForSubstitution();
    }
}

