/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.binary;

import org.chocosolver.sat.Reason;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Explained;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;

@Explained
public final class PropGreaterOrEqualX_Y
extends Propagator<IntVar> {
    private final IntVar x;
    private final IntVar y;

    public PropGreaterOrEqualX_Y(IntVar[] vars) {
        super((Variable[])vars, (Priority)PropagatorPriority.BINARY, true);
        this.x = vars[0];
        this.y = vars[1];
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        if (vIdx == 0) {
            return IntEventType.upperBoundAndInst();
        }
        return IntEventType.lowerBoundAndInst();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        this.x.updateLowerBound(this.y.getLB(), this, this.lcg() ? Reason.r(this.y.getMinLit()) : Reason.undef());
        this.y.updateUpperBound(this.x.getUB(), this, this.lcg() ? Reason.r(this.x.getMaxLit()) : Reason.undef());
        if (this.x.getLB() >= this.y.getUB()) {
            this.setPassive();
        }
    }

    @Override
    public void propagate(int varIdx, int mask) throws ContradictionException {
        if (varIdx == 0) {
            this.y.updateUpperBound(this.x.getUB(), this, this.lcg() ? Reason.r(this.x.getMaxLit()) : Reason.undef());
        } else {
            this.x.updateLowerBound(this.y.getLB(), this, this.lcg() ? Reason.r(this.y.getMinLit()) : Reason.undef());
        }
        if (this.x.getLB() >= this.y.getUB()) {
            this.setPassive();
        }
    }

    @Override
    public ESat isEntailed() {
        if (this.x.getUB() < this.y.getLB()) {
            return ESat.FALSE;
        }
        if (this.x.getLB() >= this.y.getUB()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }

    @Override
    public String toString() {
        return "prop(" + ((IntVar[])this.vars)[0].getName() + ".GEQ." + ((IntVar[])this.vars)[1].getName() + ")";
    }
}

