/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.integer.extension;

import choco.cp.solver.constraints.integer.extension.CspLargeSConstraint;
import choco.cp.solver.constraints.integer.extension.FastBooleanValidityChecker;
import choco.cp.solver.constraints.integer.extension.FastValidityChecker;
import choco.cp.solver.constraints.integer.extension.ValidityChecker;
import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.memory.IEnvironment;
import choco.kernel.memory.IStateInt;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.SolverException;
import choco.kernel.solver.constraints.integer.extension.LargeRelation;
import choco.kernel.solver.variables.integer.IntDomain;
import choco.kernel.solver.variables.integer.IntDomainVar;

public final class GAC2001LargeSConstraint
extends CspLargeSConstraint {
    protected IStateInt[] supports;
    protected int[] blocks;
    protected int size;
    protected int[] offsets;
    protected ValidityChecker valcheck;

    public GAC2001LargeSConstraint(IntDomainVar[] vs, LargeRelation relation, IEnvironment environment) {
        super(vs, relation);
        int i;
        this.size = vs.length;
        this.blocks = new int[this.size];
        this.offsets = new int[this.size];
        int nbElt = 0;
        boolean allboolean = true;
        for (i = 0; i < this.size; ++i) {
            this.offsets[i] = vs[i].getInf();
            this.blocks[i] = nbElt;
            if (!((IntDomainVar[])this.vars)[i].hasBooleanDomain()) {
                allboolean = false;
            }
            if (!((IntDomainVar[])this.vars)[i].hasEnumeratedDomain()) {
                throw new SolverException("GAC2001 can not be used with bound variables");
            }
            nbElt += ((IntDomainVar[])this.vars)[i].getSup() - ((IntDomainVar[])this.vars)[i].getInf() + 1;
        }
        this.supports = new IStateInt[nbElt * this.size];
        for (i = 0; i < this.supports.length; ++i) {
            this.supports[i] = environment.makeInt(Integer.MIN_VALUE);
        }
        this.valcheck = allboolean ? new FastBooleanValidityChecker(this.size, (IntDomainVar[])this.vars) : new FastValidityChecker(this.size, (IntDomainVar[])this.vars);
    }

    @Override
    public int getFilteredEventMask(int idx) {
        return 12;
    }

    public void reviseVar(int indexVar, boolean fromScratch) throws ContradictionException {
        int left;
        IntDomain dom = ((IntDomainVar[])this.vars)[indexVar].getDomain();
        int right = left = Integer.MIN_VALUE;
        int val = ((IntDomainVar[])this.vars)[indexVar].getInf();
        while (val <= ((IntDomainVar[])this.vars)[indexVar].getSup()) {
            int[] currentSupport = this.seekNextSupport(indexVar, val, fromScratch);
            if (currentSupport != null) {
                this.setSupport(indexVar, val, currentSupport);
            } else if (val == right + 1) {
                right = val;
            } else {
                ((IntDomainVar[])this.vars)[indexVar].removeInterval(left, right, this, false);
                left = right = val;
            }
            val = dom.getNextValue(val);
        }
        ((IntDomainVar[])this.vars)[indexVar].removeInterval(left, right, this, false);
    }

    public void setSupport(int indexVar, int value, int[] support) {
        for (int i = 0; i < ((IntDomainVar[])this.vars).length; ++i) {
            this.supports[(this.blocks[indexVar] + value - this.offsets[indexVar]) * this.size + i].set(support[i]);
        }
    }

    public int[] getSupport(int indexVar, int value) {
        int[] resultat = new int[this.size];
        for (int i = 0; i < this.size; ++i) {
            resultat[i] = this.supports[(this.blocks[indexVar] + value - this.offsets[indexVar]) * this.size + i].get();
        }
        return resultat;
    }

    public int[] lastSupport(int indexVar, int value) {
        return this.getSupport(indexVar, value);
    }

    public int[] seekNextSupport(int indexVar, int val, boolean fromscratch) {
        int[] currentSupport = new int[this.size];
        int k = 0;
        if (fromscratch) {
            for (int i = 0; i < this.size; ++i) {
                currentSupport[i] = i != indexVar ? ((IntDomainVar[])this.vars)[i].getInf() : val;
            }
            if (this.relation.isConsistent(currentSupport)) {
                return currentSupport;
            }
        } else {
            currentSupport = this.getSupport(indexVar, val);
            if (this.valcheck.isValid(currentSupport)) {
                return currentSupport;
            }
            if ((currentSupport = this.getFirstValidTupleFrom(currentSupport, indexVar)) == null) {
                return null;
            }
            if (this.relation.isConsistent(currentSupport)) {
                return currentSupport;
            }
        }
        while (k < ((IntDomainVar[])this.vars).length) {
            if (k == indexVar) {
                ++k;
            }
            if (k >= ((IntDomainVar[])this.vars).length) continue;
            if (!((IntDomainVar[])this.vars)[k].getDomain().hasNextValue(currentSupport[k])) {
                currentSupport[k] = ((IntDomainVar[])this.vars)[k].getInf();
                ++k;
                continue;
            }
            currentSupport[k] = ((IntDomainVar[])this.vars)[k].getDomain().getNextValue(currentSupport[k]);
            if (this.relation.isConsistent(currentSupport)) {
                return currentSupport;
            }
            k = 0;
        }
        return null;
    }

    public int[] getFirstValidTupleFrom(int[] t, int indexVar) {
        int k = 0;
        while (k < ((IntDomainVar[])this.vars).length) {
            if (k == indexVar) {
                ++k;
            }
            if (k >= ((IntDomainVar[])this.vars).length) continue;
            if (!((IntDomainVar[])this.vars)[k].getDomain().hasNextValue(t[k])) {
                t[k] = ((IntDomainVar[])this.vars)[k].getInf();
                ++k;
                continue;
            }
            t[k] = ((IntDomainVar[])this.vars)[k].getDomain().getNextValue(t[k]);
            if (this.valcheck.isValid(t)) {
                return t;
            }
            k = 0;
        }
        return null;
    }

    @Override
    public void awake() throws ContradictionException {
        for (int i = 0; i < ((IntDomainVar[])this.vars).length; ++i) {
            this.reviseVar(i, true);
        }
        this.propagate();
    }

    @Override
    public void propagate() throws ContradictionException {
        for (int i = 0; i < this.size; ++i) {
            this.reviseVar(i, false);
        }
    }

    @Override
    public void awakeOnRemovals(int idx, DisposableIntIterator deltaDomain) throws ContradictionException {
        this.filter(idx);
    }

    @Override
    public void awakeOnInf(int idx) throws ContradictionException {
        this.filter(idx);
    }

    @Override
    public void awakeOnSup(int idx) throws ContradictionException {
        this.filter(idx);
    }

    @Override
    public void awakeOnRem(int idx, int x) throws ContradictionException {
        this.filter(idx);
    }

    @Override
    public void awakeOnBounds(int varIndex) throws ContradictionException {
        this.filter(varIndex);
    }

    @Override
    public void awakeOnInst(int idx) throws ContradictionException {
        this.filter(idx);
    }

    public void filter(int idx) throws ContradictionException {
        this.valcheck.sortvars();
        if (((IntDomainVar[])this.vars)[idx].hasEnumeratedDomain()) {
            for (int i = 0; i < this.size; ++i) {
                if (idx == this.valcheck.position[i]) continue;
                this.reviseVar(this.valcheck.position[i], false);
            }
        } else {
            for (int i = 0; i < this.size; ++i) {
                this.reviseVar(this.valcheck.position[i], false);
            }
        }
    }

    @Override
    public String pretty() {
        StringBuilder sb = new StringBuilder();
        sb.append("GAC2001ValidLarge({");
        for (int i = 0; i < ((IntDomainVar[])this.vars).length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            IntDomainVar var = ((IntDomainVar[])this.vars)[i];
            sb.append(var.pretty());
        }
        sb.append("})");
        return sb.toString();
    }
}

