## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(TrueWAP)

data(nikkei)

## ----indicators---------------------------------------------------------------
twap <- TWAP(nikkei$OHLC, 50)
vwap <- VWAP(nikkei$HLC3, nikkei$Volume, 50)
true_wap <- TrueWAP(high = nikkei$High, low = nikkei$Low, close = nikkei$Close, true_range = nikkei$tr, period = 50)

twap_anchored <- anchoredTWAP(OHLC = nikkei$OHLC, period = nikkei$bars_since_segment)
vwap_anchored <- anchoredVWAP(HLC3 = nikkei$HLC3, volume = nikkei$Volume, period = nikkei$bars_since_segment)
true_wap_anchored <- anchoredTrueWAP(high = nikkei$High, low = nikkei$Low, close = nikkei$Close, true_range = nikkei$tr, period = nikkei$bars_since_segment)

